/*
 * Decompiled with CFR 0.152.
 */
package net.musicalmetacreation.musebot.conductor;

import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Clock;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.WavePlayer;
import net.musicalmetacreation.musebot.conductor.ClientRep;
import net.musicalmetacreation.musebot.conductor.ClientRepGUICell;
import net.musicalmetacreation.musebot.conductor.Config;
import net.musicalmetacreation.musebot.conductor.Host;
import net.musicalmetacreation.musebot.util.AudioErrorHandler;
import net.musicalmetacreation.musebot.util.EZShell;
import org.jaudiolibs.beads.AudioServerIO;

public class Conductor
extends Application {
    static AudioContext ac;
    OSCServer server;
    Map<String, Host> hosts = new Hashtable<String, Host>();
    ObservableList<ClientRep> knownClients = FXCollections.observableArrayList(new ArrayList());
    Map<String, ClientRep> activeClients = new HashMap<String, ClientRep>();
    int tick;
    Stage stage;
    Text tempoTextBox = new Text("Starting...");
    double tempo = 120.0;
    int nextPort = 7474;
    boolean clientDebugMode = false;
    Clock clock;

    public static void main(String[] args) throws InterruptedException {
        ac = new AudioContext(new AudioServerIO.Jack("Java Musebot Conductor"));
        ac.start();
        Thread.sleep(2000L);
        Application.launch((String[])args);
    }

    public void start(Stage stage) {
        this.stage = stage;
        boolean audioError = AudioErrorHandler.handleAudioError(ac);
        this.rebuildKnownClientListFromScratch();
        this.setupNetworkCommunication();
        this.setupGUI(stage);
        if (audioError) {
            AudioErrorHandler.runAudioErrorAlert("Java Musebot Conductor");
        }
    }

    void setupGUI(Stage stage) {
        VBox box = new VBox();
        HBox tempoPanel = new HBox();
        tempoPanel.setPadding(new Insets(5.0));
        Slider tempoSlider = new Slider(10.0, 1000.0, 120.0);
        tempoSlider.setOrientation(Orientation.HORIZONTAL);
        tempoSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number oldval, Number newval) {
                Conductor.this.tempo = newval.doubleValue();
                Conductor.this.clock.getIntervalUGen().setValue(60000.0f / (float)Conductor.this.tempo);
            }
        });
        tempoPanel.getChildren().add((Object)new Text("Tempo: "));
        tempoPanel.getChildren().add((Object)tempoSlider);
        tempoPanel.getChildren().add((Object)this.tempoTextBox);
        BorderPane borderPane = new BorderPane();
        borderPane.setLeft((Node)tempoPanel);
        final CheckBox tick = new CheckBox("Metro Tick");
        tick.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (tick.isSelected()) {
                    Conductor.ac.out.setGain(0.1f);
                } else {
                    Conductor.ac.out.setGain(0.0f);
                }
            }
        });
        final CheckBox debug = new CheckBox("Client Debug");
        debug.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Conductor.this.clientDebugMode = debug.isSelected();
            }
        });
        HBox refreshbox = new HBox();
        Button refresh = new Button("Refresh Clients");
        refresh.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Conductor.this.rebuildKnownClientListFromScratch();
            }
        });
        refreshbox.getChildren().add((Object)tick);
        HBox spacerh = new HBox();
        spacerh.setMinWidth(10.0);
        refreshbox.getChildren().add((Object)spacerh);
        refreshbox.getChildren().add((Object)debug);
        HBox spacerh2 = new HBox();
        spacerh2.setMinWidth(10.0);
        refreshbox.getChildren().add((Object)spacerh2);
        refreshbox.getChildren().add((Object)refresh);
        borderPane.setRight((Node)refreshbox);
        VBox spacerv = new VBox();
        spacerv.setMinHeight(10.0);
        borderPane.setBottom((Node)spacerv);
        box.getChildren().add((Object)borderPane);
        ListView list = new ListView();
        list.setItems(this.knownClients);
        list.setCellFactory((Callback)new Callback<ListView<ClientRep>, ListCell<ClientRep>>(){

            public ListCell<ClientRep> call(ListView<ClientRep> theView) {
                return new ClientRepGUICell(Conductor.this);
            }
        });
        list.setMinWidth(1000.0);
        list.setMaxWidth(1000.0);
        list.setMinHeight(700.0);
        box.getChildren().add((Object)list);
        box.setPadding(new Insets(30.0));
        Scene scene = new Scene((Parent)box);
        stage.setResizable(false);
        stage.setWidth(725.0);
        stage.setTitle("Musebot Conductor");
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                System.exit(0);
            }
        });
        stage.setScene(scene);
        stage.sizeToScene();
        stage.show();
        stage.centerOnScreen();
    }

    void setupNetworkCommunication() {
        try {
            this.server = OSCServer.newUsing("udp", 4747);
            this.server.addOSCListener(new OSCListener(){

                @Override
                public void messageReceived(OSCMessage msg, SocketAddress arg1, long arg2) {
                    Conductor.this.msg(msg);
                }
            });
            this.server.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    ArrayList<ClientRep> deadClients = new ArrayList<ClientRep>();
                    for (ClientRep client : Conductor.this.activeClients.values()) {
                        if (!client.isOutOfDate()) continue;
                        deadClients.add(client);
                        System.out.println("Client " + client.name + " is out of date. Killing it.");
                    }
                    for (ClientRep deadClient : deadClients) {
                        Conductor.this.killClient(deadClient);
                        Conductor.this.activeClients.remove(deadClient.longName());
                        deadClient.setDead();
                    }
                    Conductor.this.sendToClients("/mc/agentList", Conductor.this.activeClients.keySet().toArray());
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        this.clock = new Clock(ac, 60000.0f / (float)this.tempo);
        Conductor.ac.out.addDependent(this.clock);
        this.clock.addMessageListener(new Bead(){

            @Override
            public void messageReceived(Bead message) {
                if (Conductor.this.tick % 16 == 0) {
                    WavePlayer wp = new WavePlayer(ac, 500.0f, Buffer.SQUARE);
                    Envelope e = new Envelope(ac, 1.0f);
                    Gain g = new Gain(ac, 1, e);
                    e.addSegment(0.0f, 50.0f, new KillTrigger(g));
                    g.addInput(wp);
                    Conductor.ac.out.addInput(g);
                }
                Conductor.this.tick();
            }
        });
        Conductor.ac.out.setGain(0.0f);
    }

    void tick() {
        this.sendToClients("/mc/time", this.tempo, this.tick++);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Conductor.this.tempoTextBox.setText(" " + Config.DP2.format(Conductor.this.tempo) + " bpm. Beat/Tick Time: " + Conductor.this.tick / 16 + "/" + Conductor.this.tick % 16);
            }
        });
    }

    void rebuildKnownClientListFromScratch() {
        this.rebuildHostList();
        this.rebuildClientListFromHosts();
    }

    void rebuildHostList() {
        this.hosts.clear();
        try {
            Scanner hostListFile = new Scanner(new File("hosts.txt"));
            while (hostListFile.hasNextLine()) {
                String line = hostListFile.nextLine().trim();
                if (line.startsWith("#") || line.equals("")) continue;
                ArrayList<String> list = new ArrayList<String>();
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(line);
                while (m.find()) {
                    list.add(m.group(1).replace("\"", ""));
                }
                if (list.size() != 3) continue;
                Host newHost = new Host((String)list.get(0), (String)list.get(1), (String)list.get(2));
                this.hosts.put(newHost.hostname, newHost);
                System.out.println("Found host: [hostname=" + newHost.hostname + ", user=" + newHost.username + ", path=" + newHost.absPath + "]");
            }
            hostListFile.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.addLocalhostToHostList();
    }

    void rebuildClientListFromHosts() {
        this.knownClients.clear();
        for (Host host : this.hosts.values()) {
            String[] musebots;
            String[] stringArray = musebots = host.getMusebotList();
            int n = musebots.length;
            int n2 = 0;
            while (n2 < n) {
                String musebot = stringArray[n2];
                String longname = String.valueOf(musebot) + "@" + host.hostname;
                ClientRep client = null;
                client = this.activeClients.containsKey(longname) ? this.activeClients.get(longname) : new ClientRep(musebot, host, this.nextPort++);
                this.knownClients.add((Object)client);
                System.out.println("Adding client: " + client);
                ++n2;
            }
        }
    }

    void addLocalhostToHostList() {
        if (this.hosts.containsKey("localhost")) {
            return;
        }
        String musebotLocation = new File("../../../Musebots").getAbsolutePath();
        if (!new File(musebotLocation).exists()) {
            musebotLocation = "~/Documents/Musebots";
        }
        if (!new File(musebotLocation).exists()) {
            DirectoryChooser choose = new DirectoryChooser();
            choose.setTitle("Is there a musebot folder on the local machine? I can't find it.");
            File choice = choose.showDialog((Window)this.stage);
            musebotLocation = choice == null ? null : choice.getAbsolutePath();
        }
        if (musebotLocation != null) {
            System.out.println("Adding localhost: [path=" + musebotLocation + "]");
            this.hosts.put("localhost", new Host("localhost", System.getProperty("user.name"), musebotLocation));
        }
    }

    boolean validateMusebotFolderLocal(String location) {
        boolean isValid = false;
        return isValid;
    }

    boolean validateMusebotFolderRemote(Host host) {
        boolean isValid = false;
        return isValid;
    }

    void msg(OSCMessage msg) {
        System.out.println("Incoming msg: " + msg.getName());
        if (msg.getName().equals("/agent/alive")) {
            String name = (String)msg.getArg(0);
            this.notifyClientAlive(name);
        } else if (msg.getName().startsWith("/broadcast")) {
            this.sendToClients(msg);
        }
    }

    boolean startClient(ClientRep client) {
        System.out.println("Starting client: " + client.name);
        if (this.activeClients.containsKey(client.name)) {
            System.out.println("Trying to start client that is already supposed to be running: " + client.name + " ... Aborting.");
            return false;
        }
        this.activeClients.put(client.longName(), client);
        client.touch();
        String myrelativehostname = client.host.hostname.equals("localhost") ? "localhost" : EZShell.call("hostname");
        String configdata = "id " + client.longName() + "\n" + "mc_hostname " + myrelativehostname + "\n" + "mc_listen_port " + 4747 + "\n" + "my_listen_port " + client.address.getPort() + "\n" + "output_channels " + 2 + "\n";
        String configDest = String.valueOf(client.host.absPath) + "/" + client.name + "/config.txt";
        String runcommand = String.valueOf(client.host.absPath) + "/" + client.name + "/run.command";
        if (client.host.isLocalhost()) {
            try {
                PrintStream ps = new PrintStream(configDest);
                ps.print(configdata);
                ps.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            EZShell.callNoResult("open", runcommand);
        } else {
            String tmpFile = "./.temp_config_" + client.host + "_" + client.name;
            try {
                PrintStream ps = new PrintStream(tmpFile);
                ps.print(configdata);
                ps.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            EZShell.callNoResult("scp", tmpFile, String.valueOf(client.host.userHost()) + ":\"" + configDest + "\"");
            EZShell.callNoResult("rm", tmpFile);
            EZShell.callNoResult("ssh", client.host.userHost(), "open \"" + runcommand + "\"");
        }
        System.out.println("Client started.");
        return true;
    }

    void killClient(ClientRep client) {
        try {
            this.server.send(new OSCMessage("/agent/off"), this.activeClients.get((Object)client.longName()).address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void notifyClientAlive(String name) {
        System.out.println("Recieved notification of active client: " + name);
        System.out.println("Currently active clients I know of: " + this.activeClients.keySet());
        if (this.activeClients.containsKey(name)) {
            this.activeClients.get(name).setAlive();
        } else if (!this.clientDebugMode) {
            System.err.println("Warning: contacted by an unknown agent.");
        }
    }

    void setClientLevel(String name, double gain) {
        try {
            this.server.send(new OSCMessage("/agent/gain", new Object[]{gain}), this.activeClients.get((Object)name).address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void setClientLevel(ClientRep client, double gain, double time) {
        try {
            this.server.send(new OSCMessage("/agent/gain", new Object[]{gain, time}), client.address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendToClients(String msg, Object ... args) {
        OSCMessage oscMsg = new OSCMessage(msg, args);
        this.sendToClients(oscMsg);
    }

    void sendToClients(OSCMessage oscMsg) {
        try {
            for (ClientRep client : this.activeClients.values()) {
                this.server.send(oscMsg, client.address);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

