/*
 * Decompiled with CFR 0.152.
 */
package net.musicalmetacreation.musebot.util;

import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import net.beadsproject.beads.core.AudioContext;

public abstract class AudioErrorHandler {
    public static boolean handleAudioError(AudioContext ac) {
        if (ac.getTime() <= 0.0) {
            if (ac != null) {
                ac.stop();
            }
            ac = new AudioContext();
            ac.start();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void runAudioErrorAlert(String programName) {
        Stage alertStage = new Stage();
        alertStage.setTitle("Audio Alert");
        Text alertText = new Text("Hi there! \n\nThe " + programName + " is running, but " + "you don't seem to have Jack running, " + "or we can't connect to it for whatever reason. " + "Hopefully the only result of this is that your " + "metronome might sound a little out of time because " + "we're not making use of Jack's low-latency audio. " + "But it could mean the program doesn't run properly.\n\n" + "Please download and install Jack, then run it with buffer " + "size 512, and sample rate 44100.\n\n" + "http://jackaudio.org/");
        alertText.setWrappingWidth(200.0);
        HBox alertBox = new HBox();
        alertBox.setPadding(new Insets(10.0));
        alertBox.setMaxWidth(200.0);
        alertBox.getChildren().add((Object)alertText);
        Scene alertScene = new Scene((Parent)alertBox);
        alertStage.setScene(alertScene);
        alertStage.sizeToScene();
        alertStage.show();
        alertStage.centerOnScreen();
    }
}

