/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.jack;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackShutdownCallback;

public class JackAudioServer
implements AudioServer {
    private String id;
    private AudioConfiguration context;
    private AudioClient client;
    private Jack jack;
    private JackClient jackclient;
    private AtomicReference<State> state;
    private JackPort[] inputPorts;
    private List<FloatBuffer> inputBuffers;
    private JackPort[] outputPorts;
    private List<FloatBuffer> outputBuffers;
    private Callback callback;
    private boolean autoconnect;

    private JackAudioServer(String id, AudioConfiguration ctxt, boolean autoconnect, AudioClient client) {
        this.id = id;
        this.context = ctxt;
        this.client = client;
        this.autoconnect = autoconnect;
        this.state = new AtomicReference<State>(State.New);
    }

    public void run() throws Exception {
        if (!this.state.compareAndSet(State.New, State.Initialising)) {
            throw new IllegalStateException();
        }
        try {
            this.initialise();
        }
        catch (Exception ex) {
            this.state.set(State.Terminated);
            this.closeAll();
            this.client.shutdown();
            throw ex;
        }
        if (this.state.compareAndSet(State.Initialising, State.Active)) {
            this.runImpl();
        }
        this.closeAll();
        this.client.shutdown();
        this.state.set(State.Terminated);
    }

    private void initialise() throws Exception {
        int i;
        this.jack = Jack.getInstance();
        EnumSet<JackOptions> options = EnumSet.of(JackOptions.JackNoStartServer, JackOptions.JackUseExactName);
        this.jackclient = this.jack.openClient(this.id, options, null);
        int count = this.context.getInputChannelCount();
        this.inputPorts = new JackPort[count];
        this.inputBuffers = Arrays.asList(new FloatBuffer[count]);
        for (i = 0; i < count; ++i) {
            this.inputPorts[i] = this.jackclient.registerPort("Input_" + (i + 1), JackPortType.AUDIO, JackPortFlags.JackPortIsInput);
        }
        count = this.context.getOutputChannelCount();
        this.outputPorts = new JackPort[count];
        this.outputBuffers = Arrays.asList(new FloatBuffer[count]);
        for (i = 0; i < count; ++i) {
            this.outputPorts[i] = this.jackclient.registerPort("Output_" + (i + 1), JackPortType.AUDIO, JackPortFlags.JackPortIsOutput);
        }
    }

    private void runImpl() {
        try {
            this.context = new AudioConfiguration(this.jackclient.getSampleRate(), this.inputPorts.length, this.outputPorts.length, this.jackclient.getBufferSize(), true);
            this.client.configure(this.context);
            this.jackclient.setProcessCallback(new Callback());
            this.jackclient.onShutdown(new ShutDownHook());
            this.jackclient.activate();
            if (this.autoconnect) {
                this.autoconnect();
            }
            while (this.state.get() == State.Active) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            this.shutdown();
        }
    }

    private void autoconnect() {
        try {
            String[] ins = this.jack.getPorts(this.jackclient, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsOutput, JackPortFlags.JackPortIsPhysical));
            String[] outs = this.jack.getPorts(this.jackclient, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsInput, JackPortFlags.JackPortIsPhysical));
            int inCount = Math.min(ins.length, this.inputPorts.length);
            for (int i = 0; i < inCount; ++i) {
                this.jack.connect(this.jackclient, ins[i], this.inputPorts[i].getName());
            }
            int outCount = Math.min(outs.length, this.outputPorts.length);
            for (int i = 0; i < outCount; ++i) {
                this.jack.connect(this.jackclient, this.outputPorts[i].getName(), outs[i]);
            }
        }
        catch (JackException ex) {
            Logger.getLogger(JackAudioServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processBuffers(int nframes) {
        int i;
        for (i = 0; i < this.inputPorts.length; ++i) {
            this.inputBuffers.set(i, this.inputPorts[i].getFloatBuffer());
        }
        for (i = 0; i < this.outputPorts.length; ++i) {
            this.outputBuffers.set(i, this.outputPorts[i].getFloatBuffer());
        }
        this.client.process(System.nanoTime(), this.inputBuffers, this.outputBuffers, nframes);
    }

    public AudioConfiguration getAudioContext() {
        return this.context;
    }

    public boolean isActive() {
        State st = this.state.get();
        return st == State.Active || st == State.Closing;
    }

    public void shutdown() {
        State st;
        while ((st = this.state.get()) != State.Terminated && st != State.Closing && !this.state.compareAndSet(st, State.Closing)) {
        }
    }

    private void closeAll() {
        try {
            this.jackclient.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static JackAudioServer create(String id, AudioConfiguration ctxt, boolean autoconnect, AudioClient client) {
        if (id == null || ctxt == null || client == null) {
            throw new NullPointerException();
        }
        return new JackAudioServer(id, ctxt, autoconnect, client);
    }

    private class Callback
    implements JackProcessCallback {
        private Callback() {
        }

        public boolean process(JackClient client, int nframes) {
            if (JackAudioServer.this.state.get() != State.Active) {
                return false;
            }
            try {
                JackAudioServer.this.processBuffers(nframes);
                return true;
            }
            catch (Exception ex) {
                JackAudioServer.this.shutdown();
                return false;
            }
        }
    }

    private class ShutDownHook
    implements JackShutdownCallback {
        private ShutDownHook() {
        }

        public void clientShutdown(JackClient client) {
            JackAudioServer.this.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        New,
        Initialising,
        Active,
        Closing,
        Terminated;

    }
}

