/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.beads;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioIO;
import net.beadsproject.beads.core.UGen;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.jack.JackAudioServer;
import org.jaudiolibs.audioservers.javasound.JavasoundAudioServer;

public abstract class AudioServerIO
extends AudioIO
implements AudioClient {
    protected AudioServer server;
    protected AudioConfiguration config;
    private List<FloatBuffer> inputs;

    @Override
    protected UGen getAudioInput(int[] nArray) {
        return new RTInput(this.context, nArray);
    }

    @Override
    public void configure(AudioConfiguration audioConfiguration) throws Exception {
        if (this.config.getSampleRate() != audioConfiguration.getSampleRate() || this.config.getInputChannelCount() != audioConfiguration.getInputChannelCount() || this.config.getOutputChannelCount() != audioConfiguration.getOutputChannelCount() || this.config.getMaxBufferSize() != audioConfiguration.getMaxBufferSize() || !audioConfiguration.isFixedBufferSize()) {
            System.out.println("Unexpected audio configuration");
            throw new IllegalArgumentException("Unexpected audio configuration");
        }
    }

    protected boolean runThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioServerIO.this.server.run();
                }
                catch (Exception exception) {
                    Logger.getLogger(AudioServerIO.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
        }, "audio");
        thread.setPriority(10);
        thread.start();
        return true;
    }

    @Override
    public boolean process(long l, List<FloatBuffer> list, List<FloatBuffer> list2, int n) {
        if (!this.context.isRunning()) {
            return false;
        }
        this.inputs = list;
        this.update();
        for (int i = 0; i < list2.size(); ++i) {
            list2.get(i).put(this.context.out.getOutBuffer(i));
        }
        this.inputs = null;
        return true;
    }

    @Override
    public void shutdown() {
    }

    public static class JavaSound
    extends AudioServerIO {
        String device = null;

        public JavaSound() {
        }

        public JavaSound(String string) {
            this.device = string;
        }

        @Override
        protected boolean start() {
            System.out.println("Starting JavaSound implementation of AudioServerIO");
            this.config = new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), true);
            try {
                this.server = JavasoundAudioServer.create(this.device, this.config, JavasoundAudioServer.TimingMode.FramePosition, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.runThread();
        }
    }

    public static class Jack
    extends AudioServerIO {
        private String name = "Beads";

        public Jack() {
        }

        public Jack(String string) {
            this.name = string;
        }

        @Override
        protected boolean start() {
            System.out.println("Starting Jack implementation of AudioServerIO");
            this.config = new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), true);
            this.server = JackAudioServer.create(this.name, this.config, true, this);
            return this.runThread();
        }
    }

    private class RTInput
    extends UGen {
        private int[] channels;

        RTInput(AudioContext audioContext, int[] nArray) {
            super(audioContext, nArray.length);
            this.channels = nArray;
        }

        @Override
        public void calculateBuffer() {
            for (int i = 0; i < this.channels.length; ++i) {
                ((FloatBuffer)AudioServerIO.this.inputs.get(this.channels[i] - 1)).get(this.bufOut[i]);
            }
        }
    }
}

