/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackBufferSizeCallback;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackSampleRateCallback;
import org.jaudiolibs.jnajack.JackShutdownCallback;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackClient {
    private static final Logger LOG = Logger.getLogger(JackClient.class.getName());
    private static final String CALL_ERROR_MSG = "Error calling native lib";
    private static final int FRAME_SIZE = 4;
    JackLibrary._jack_client clientPtr;
    private ProcessCallbackWrapper processCallback;
    private BufferSizeCallbackWrapper buffersizeCallback;
    private SampleRateCallbackWrapper samplerateCallback;
    private ShutdownCallback shutdownCallback;
    private JackShutdownCallback userShutdownCallback;
    private JackPort[] ports;
    private Jack jack;
    private JackLibrary jackLib;
    private String name;

    JackClient(String name, Jack jack, JackLibrary._jack_client client) {
        this.name = name;
        this.jack = jack;
        this.jackLib = jack.jackLib;
        this.clientPtr = client;
        this.shutdownCallback = new ShutdownCallback();
        try {
            this.jackLib.jack_on_shutdown(client, this.shutdownCallback, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
        this.ports = new JackPort[0];
    }

    public JackPort registerPort(String name, JackPortType type, EnumSet<JackPortFlags> flags) throws JackException {
        int fl = 0;
        for (JackPortFlags flag : flags) {
            fl |= flag.getIntValue();
        }
        String typeString = type.getTypeString();
        NativeLong bufferSize = new NativeLong((long)type.getBufferSize());
        NativeLong nativeFlags = new NativeLong((long)fl);
        JackLibrary._jack_port portPtr = null;
        try {
            portPtr = this.jackLib.jack_port_register(this.clientPtr, name, typeString, nativeFlags, bufferSize);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            portPtr = null;
        }
        if (portPtr == null) {
            throw new JackException("Could not register port");
        }
        JackPort port = new JackPort(name, this, portPtr);
        this.addToPortArray(port);
        return port;
    }

    public JackPort registerPort(String name, JackPortType type, JackPortFlags flag) throws JackException {
        return this.registerPort(name, type, EnumSet.of(flag));
    }

    private void addToPortArray(JackPort port) {
        JackPort[] pts = this.ports;
        ArrayList<JackPort> portList = new ArrayList<JackPort>(Arrays.asList(pts));
        portList.add(port);
        this.ports = pts = portList.toArray(new JackPort[portList.size()]);
    }

    public void setProcessCallback(JackProcessCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        ProcessCallbackWrapper wrapper = new ProcessCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_process_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.processCallback = wrapper;
    }

    public void setBuffersizeCallback(JackBufferSizeCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        BufferSizeCallbackWrapper wrapper = new BufferSizeCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_buffer_size_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.buffersizeCallback = wrapper;
    }

    public void setSampleRateCallback(JackSampleRateCallback callback) throws JackException {
        if (callback == null) {
            throw new NullPointerException();
        }
        SampleRateCallbackWrapper wrapper = new SampleRateCallbackWrapper(callback);
        int ret = -1;
        try {
            ret = this.jackLib.jack_set_sample_rate_callback(this.clientPtr, wrapper, null);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
        this.samplerateCallback = wrapper;
    }

    public void onShutdown(JackShutdownCallback callback) throws JackException {
        this.userShutdownCallback = callback;
    }

    public void activate() throws JackException {
        int ret = -1;
        try {
            ret = this.jackLib.jack_activate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
    }

    public void deactivate() {
        try {
            this.jackLib.jack_deactivate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.clientPtr != null) {
                this.jackLib.jack_client_close(this.clientPtr);
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
        }
        finally {
            this.clientPtr = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSampleRate() throws JackException {
        try {
            return this.jackLib.jack_get_sample_rate(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public int getBufferSize() throws JackException {
        try {
            return this.jackLib.jack_get_buffer_size(this.clientPtr);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    private void processShutdown() {
        this.clientPtr = null;
        if (this.userShutdownCallback != null) {
            this.userShutdownCallback.clientShutdown(this);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private class BufferSizeCallbackWrapper
    implements JackLibrary.JackBufferSizeCallback {
        JackBufferSizeCallback callback;

        BufferSizeCallbackWrapper(JackBufferSizeCallback callback) {
            this.callback = callback;
        }

        public int invoke(int nframes, Pointer arg) {
            int ret = -1;
            try {
                this.callback.buffersizeChanged(JackClient.this, nframes);
                ret = 0;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in buffersize callback", e);
                ret = -1;
            }
            return ret;
        }
    }

    private class ProcessCallbackWrapper
    implements JackLibrary.JackProcessCallback {
        JackProcessCallback callback;

        ProcessCallbackWrapper(JackProcessCallback callback) {
            this.callback = callback;
            JackClient.this.jack.setupCTI(this);
        }

        public int invoke(int nframes) {
            int ret = 1;
            try {
                JackPort[] pts = JackClient.this.ports;
                int nbyteframes = nframes * 4;
                for (JackPort port : pts) {
                    Pointer buffer = JackClient.this.jackLib.jack_port_get_buffer(port.portPtr, nframes);
                    if (buffer == port.buffer && port.byteBuffer.capacity() == nbyteframes) {
                        port.byteBuffer.rewind();
                        port.floatBuffer.rewind();
                        continue;
                    }
                    port.buffer = buffer;
                    port.byteBuffer = buffer.getByteBuffer(0L, nbyteframes);
                    port.floatBuffer = port.byteBuffer.asFloatBuffer();
                }
                if (this.callback.process(JackClient.this, nframes)) {
                    ret = 0;
                }
            }
            catch (Throwable ex) {
                LOG.log(Level.SEVERE, "Error in process callback", ex);
                ret = 1;
            }
            if (ret != 0) {
                JackClient.this.jack.forceThreadDetach();
            }
            return ret;
        }
    }

    private class SampleRateCallbackWrapper
    implements JackLibrary.JackSampleRateCallback {
        JackSampleRateCallback callback;

        SampleRateCallbackWrapper(JackSampleRateCallback callback) {
            this.callback = callback;
        }

        public int invoke(int nframes, Pointer arg) {
            int ret = -1;
            try {
                this.callback.sampleRateChanged(JackClient.this, nframes);
                ret = 0;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error in samplerate callback", e);
                ret = -1;
            }
            return ret;
        }
    }

    private class ShutdownCallback
    implements JackLibrary.JackShutdownCallback {
        private ShutdownCallback() {
        }

        public void invoke(Pointer arg) {
            JackClient.this.processShutdown();
            JackClient.this.jack.forceThreadDetach();
        }
    }
}

