/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.util.Hashtable;
import java.util.List;
import net.beadsproject.beads.analysis.AudioSegmenter;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.FeatureSet;
import net.beadsproject.beads.analysis.FeatureTrack;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.SegmentMaker;
import net.beadsproject.beads.analysis.featureextractors.FFT;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.MelSpectrum;
import net.beadsproject.beads.analysis.featureextractors.PeakDetector;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.PowerSpectrum;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.analysis.featureextractors.SpectralDifference;
import net.beadsproject.beads.analysis.featureextractors.SpectralPeaks;
import net.beadsproject.beads.analysis.segmenters.ShortFrameSegmenter;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Analyzer
implements SegmentMaker {
    private static AnalysisSettings defaultSettings = new AnalysisSettings();
    private ShortFrameSegmenter sfs;
    private FeatureSet results;
    private Hashtable<Class<?>, Object> extractorArrangement;
    private SegmentMaker beatSegmentMaker;

    public Analyzer(AudioContext audioContext, List<Class<? extends FeatureExtractor<?, ?>>> list) {
        this(audioContext, list, defaultSettings);
    }

    public Analyzer(AudioContext audioContext, List<Class<? extends FeatureExtractor<?, ?>>> list, AnalysisSettings analysisSettings) {
        this.setup(audioContext, list, analysisSettings);
    }

    @Override
    public void addSegmentListener(SegmentListener segmentListener) {
        this.sfs.addSegmentListener(segmentListener);
    }

    @Override
    public void removeSegmentListener(SegmentListener segmentListener) {
        this.sfs.removeSegmentListener(segmentListener);
    }

    public void addBeatListener(SegmentListener segmentListener) {
        this.beatSegmentMaker.addSegmentListener(segmentListener);
    }

    public void removeBeatListener(SegmentListener segmentListener) {
        this.beatSegmentMaker.removeSegmentListener(segmentListener);
    }

    public void listenTo(UGen uGen) {
        this.sfs.addInput(0, uGen, 0);
    }

    public void updateFrom(UGen uGen) {
        uGen.addDependent(this.sfs);
    }

    public FeatureFrame getLastLowLevelFrame() {
        return this.results.get("Low Level").getLastFrame();
    }

    public FeatureFrame getLastBeatFrame() {
        return this.results.get("Beats").getLastFrame();
    }

    public Object getElement(Class<?> clazz) {
        return this.extractorArrangement.get(clazz);
    }

    public FeatureSet getResults() {
        return this.results;
    }

    private void setup(AudioContext audioContext, List<Class<? extends FeatureExtractor<?, ?>>> list, AnalysisSettings analysisSettings) {
        Class<FeatureExtractor<Object, Object>> clazz2;
        this.results = new FeatureSet();
        FeatureTrack featureTrack = new FeatureTrack();
        FeatureTrack featureTrack2 = new FeatureTrack();
        this.results.add("Low Level", featureTrack);
        this.results.add("Beats", featureTrack2);
        this.extractorArrangement = new Hashtable();
        this.extractorArrangement.put(AudioContext.class, audioContext);
        this.sfs = new ShortFrameSegmenter(audioContext);
        this.sfs.setChunkSize(analysisSettings.chunkSize);
        this.sfs.setHopSize(analysisSettings.hopSize);
        this.sfs.addSegmentListener(featureTrack);
        this.extractorArrangement.put(AudioSegmenter.class, this.sfs);
        if (list != null) {
            for (Class<FeatureExtractor<Object, Object>> clazz2 : list) {
                if (clazz2.equals(PowerSpectrum.class)) {
                    Analyzer.powerSpectrum(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(FFT.class)) {
                    Analyzer.fft(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(Frequency.class)) {
                    Analyzer.frequency(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(MelSpectrum.class)) {
                    Analyzer.melSpectrum(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(MFCC.class)) {
                    Analyzer.mfcc(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(SpectralPeaks.class)) {
                    Analyzer.spectralPeaks(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(Power.class)) {
                    Analyzer.power(this.extractorArrangement);
                    continue;
                }
                if (clazz2.equals(SpectralCentroid.class)) {
                    Analyzer.spectralCentroid(this.extractorArrangement);
                    continue;
                }
                System.err.println("Analyzer: unknown extractor class: " + clazz2);
            }
        }
        Analyzer.spectralDifference(this.extractorArrangement);
        Object object = this.extractorArrangement.keySet().iterator();
        while (object.hasNext()) {
            clazz2 = object.next();
            if (!(this.extractorArrangement.get(clazz2) instanceof FeatureExtractor)) continue;
            featureTrack.addFeatureExtractor((FeatureExtractor)this.extractorArrangement.get(clazz2));
        }
        this.beatSegmentMaker = object = new PeakDetector();
        ((PeakDetector)object).setThreshold(0.1f);
        ((PeakDetector)object).setAlpha(0.9f);
        ((PeakDetector)object).setResetDelay(200.0f);
        clazz2 = (SpectralDifference)this.extractorArrangement.get(SpectralDifference.class);
        ((FeatureExtractor)((Object)clazz2)).addListener(object);
        ((SpectralDifference)((Object)clazz2)).setDifferenceType(SpectralDifference.DifferenceType.POSITIVEMEANDIFFERENCE);
        ((PeakDetector)object).addSegmentListener(featureTrack2);
    }

    public void setFrameMemory(int n) {
        for (FeatureTrack featureTrack : this.results.tracks().values()) {
            featureTrack.setFrameMemory(n);
        }
    }

    private static void spectralPeaks(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(SpectralPeaks.class)) {
            Analyzer.powerSpectrum(hashtable);
            AudioContext audioContext = (AudioContext)hashtable.get(AudioContext.class);
            SpectralPeaks spectralPeaks = new SpectralPeaks(audioContext, 10);
            PowerSpectrum powerSpectrum = (PowerSpectrum)hashtable.get(PowerSpectrum.class);
            powerSpectrum.addListener(spectralPeaks);
            hashtable.put(SpectralPeaks.class, spectralPeaks);
        }
    }

    private static void spectralDifference(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(SpectralDifference.class)) {
            Analyzer.powerSpectrum(hashtable);
            AudioContext audioContext = (AudioContext)hashtable.get(AudioContext.class);
            SpectralDifference spectralDifference = new SpectralDifference(audioContext.getSampleRate());
            spectralDifference.setDifferenceType(SpectralDifference.DifferenceType.POSITIVERMS);
            PowerSpectrum powerSpectrum = (PowerSpectrum)hashtable.get(PowerSpectrum.class);
            powerSpectrum.addListener(spectralDifference);
            hashtable.put(SpectralDifference.class, spectralDifference);
        }
    }

    private static void mfcc(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(MFCC.class)) {
            Analyzer.melSpectrum(hashtable);
            MFCC mFCC = new MFCC(20);
            MelSpectrum melSpectrum = (MelSpectrum)hashtable.get(MelSpectrum.class);
            melSpectrum.addListener(mFCC);
            hashtable.put(MFCC.class, mFCC);
        }
    }

    private static void melSpectrum(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(MelSpectrum.class)) {
            Analyzer.powerSpectrum(hashtable);
            AudioContext audioContext = (AudioContext)hashtable.get(AudioContext.class);
            MelSpectrum melSpectrum = new MelSpectrum(audioContext.getSampleRate(), 200);
            PowerSpectrum powerSpectrum = (PowerSpectrum)hashtable.get(PowerSpectrum.class);
            powerSpectrum.addListener(melSpectrum);
            hashtable.put(MelSpectrum.class, melSpectrum);
        }
    }

    private static void frequency(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(Frequency.class)) {
            Analyzer.powerSpectrum(hashtable);
            AudioContext audioContext = (AudioContext)hashtable.get(AudioContext.class);
            Frequency frequency = new Frequency(audioContext.getSampleRate());
            PowerSpectrum powerSpectrum = (PowerSpectrum)hashtable.get(PowerSpectrum.class);
            powerSpectrum.addListener(frequency);
            hashtable.put(Frequency.class, frequency);
        }
    }

    private static void spectralCentroid(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(SpectralCentroid.class)) {
            Analyzer.powerSpectrum(hashtable);
            AudioContext audioContext = (AudioContext)hashtable.get(AudioContext.class);
            SpectralCentroid spectralCentroid = new SpectralCentroid(audioContext.getSampleRate());
            PowerSpectrum powerSpectrum = (PowerSpectrum)hashtable.get(PowerSpectrum.class);
            powerSpectrum.addListener(spectralCentroid);
            hashtable.put(SpectralCentroid.class, spectralCentroid);
        }
    }

    private static void powerSpectrum(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(PowerSpectrum.class)) {
            Analyzer.fft(hashtable);
            PowerSpectrum powerSpectrum = new PowerSpectrum();
            FFT fFT = (FFT)hashtable.get(FFT.class);
            fFT.addListener(powerSpectrum);
            hashtable.put(PowerSpectrum.class, powerSpectrum);
        }
    }

    private static void fft(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(FFT.class)) {
            FFT fFT = new FFT();
            AudioSegmenter audioSegmenter = (AudioSegmenter)hashtable.get(AudioSegmenter.class);
            audioSegmenter.addListener(fFT);
            hashtable.put(FFT.class, fFT);
        }
    }

    private static void power(Hashtable<Class<?>, Object> hashtable) {
        if (!hashtable.containsKey(Power.class)) {
            Power power = new Power();
            AudioSegmenter audioSegmenter = (AudioSegmenter)hashtable.get(AudioSegmenter.class);
            audioSegmenter.addListener(power);
            hashtable.put(Power.class, power);
        }
    }

    static {
        Analyzer.defaultSettings.hopSize = 512;
        Analyzer.defaultSettings.chunkSize = 1024;
    }

    public static class AnalysisSettings {
        int hopSize;
        int chunkSize;

        public AnalysisSettings(int n, int n2) {
            this.hopSize = n;
            this.chunkSize = n2;
        }

        public AnalysisSettings() {
        }
    }
}

