/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.util.ArrayList;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.TimeStamp;

public abstract class FeatureExtractor<R, P>
extends Bead {
    protected int numFeatures;
    protected R features = null;
    protected String name = this.getClass().getSimpleName();
    protected String[] featureDescriptions;
    private ArrayList<FeatureExtractor<?, R>> featureExtractorListeners = new ArrayList();

    public abstract void process(TimeStamp var1, TimeStamp var2, P var3);

    public void forward(TimeStamp timeStamp, TimeStamp timeStamp2) {
        for (FeatureExtractor<?, R> featureExtractor : this.featureExtractorListeners) {
            featureExtractor.process(timeStamp, timeStamp2, this.features);
        }
    }

    public void addListener(FeatureExtractor<?, R> featureExtractor) {
        this.featureExtractorListeners.add(featureExtractor);
    }

    public void removeListener(FeatureExtractor<?, R> featureExtractor) {
        this.featureExtractorListeners.remove(featureExtractor);
    }

    public R getFeatures() {
        return this.features;
    }

    public int getNumberOfFeatures() {
        return this.numFeatures;
    }

    public void setNumberOfFeatures(int n) {
        this.numFeatures = n;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getFeatureDescriptions() {
        return this.featureDescriptions;
    }
}

