/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;
import net.beadsproject.beads.analysis.FeatureTrack;
import net.beadsproject.beads.data.Sample;

public class FeatureSet {
    private Hashtable<String, FeatureTrack> tracks = new Hashtable();
    private Hashtable<String, Object> globalFeatures = new Hashtable();
    private File file;

    public static FeatureSet forSample(Sample sample) {
        File file;
        String string = sample.getFileName();
        FeatureSet featureSet = null;
        if (string != null && (file = new File(string + ".features")).exists()) {
            featureSet = new FeatureSet(file);
        }
        return featureSet;
    }

    public FeatureSet() {
    }

    public FeatureSet(File file) {
        this();
        this.read(file);
    }

    public FeatureTrack get(String string) {
        return this.tracks.get(string);
    }

    public void add(String string, FeatureTrack featureTrack) {
        this.tracks.put(string, featureTrack);
    }

    public boolean contains(String string) {
        return this.tracks.containsKey(string);
    }

    public void addGlobal(String string, Object object) {
        this.globalFeatures.put(string, object);
    }

    public Object getGlobal(String string) {
        return this.globalFeatures.get(string);
    }

    public boolean containsGlobal(String string) {
        return this.globalFeatures.containsKey(string);
    }

    public void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.tracks);
            objectOutputStream.writeObject(this.globalFeatures);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void read(File file) {
        this.file = file;
        this.read();
    }

    private void read() {
        if (this.file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.tracks = (Hashtable)objectInputStream.readObject();
                this.globalFeatures = (Hashtable)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void refresh() {
        this.read();
    }

    public void write(File file) {
        this.file = file;
        this.write();
    }

    public void write(String string) {
        this.write(new File(string));
    }

    public Map<String, FeatureTrack> tracks() {
        return this.tracks;
    }

    public void printGlobalFeatures() {
        System.out.println("Features for " + this + ":");
        for (String string : this.globalFeatures.keySet()) {
            System.out.println("- " + string);
        }
    }
}

