/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class MelSpectrum
extends FeatureExtractor<float[], float[]> {
    public static final float LOG10 = (float)Math.log(10.0);
    private final float sampleRate;
    private int bufferSize;
    private double[] melCenter;
    private double[] melWidth;
    private double[] melOfLin;
    private double hardMax;

    public MelSpectrum(float f, int n) {
        this.sampleRate = f;
        this.setNumberOfFeatures(n);
        this.hardMax = 8000.0;
    }

    private void setup() {
        int n;
        int n2 = this.bufferSize * 2;
        this.features = new float[this.numFeatures];
        this.melCenter = new double[this.numFeatures + 2];
        this.melWidth = new double[this.numFeatures + 2];
        double d = MelSpectrum.lin2mel(0.0);
        double d2 = MelSpectrum.lin2mel(this.hardMax < (double)(this.sampleRate / 2.0f) ? this.hardMax : (double)(this.sampleRate / 2.0f));
        double d3 = this.sampleRate / 2.0f / (float)n2;
        for (n = 0; n < this.numFeatures + 2; ++n) {
            this.melCenter[n] = d + (double)n * (d2 - d) / (double)(this.numFeatures + 1);
        }
        for (n = 0; n < this.numFeatures + 1; ++n) {
            this.melWidth[n] = this.melCenter[n + 1] - this.melCenter[n];
            double d4 = (MelSpectrum.mel2lin(this.melCenter[n + 1]) - MelSpectrum.mel2lin(this.melCenter[n])) / d3;
            if (d4 < 1.0) {
                this.melWidth[n] = MelSpectrum.lin2mel(MelSpectrum.mel2lin(this.melCenter[n]) + d3) - this.melCenter[n];
            }
            if (this.melWidth[n] != 0.0) continue;
            System.out.println("zero melwidth");
        }
        this.melOfLin = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.melOfLin[n] = MelSpectrum.lin2mel((float)n * this.sampleRate / (float)(2 * n2));
            if (!Double.isInfinite(this.melOfLin[n])) continue;
            System.out.println("infinte meloflin");
        }
        this.featureDescriptions = new String[this.numFeatures];
        for (n = 0; n < this.numFeatures; ++n) {
            this.featureDescriptions[n] = n < 9 ? "mel0" + (n + 1) : "mel" + (n + 1);
        }
    }

    @Override
    public void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        int n;
        if (fArray.length != this.bufferSize) {
            this.bufferSize = fArray.length;
            this.setup();
        }
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = fArray[n];
        }
        for (n = 0; n < ((float[])this.features).length; ++n) {
            ((float[])this.features)[n] = 0.0f;
            for (int i = 0; i < fArray2.length; ++i) {
                double d = 1.0 - Math.abs(this.melOfLin[i] - this.melCenter[n]) / this.melWidth[n];
                if (!(d > 0.0)) continue;
                float[] fArray3 = (float[])this.features;
                int n2 = n;
                fArray3[n2] = (float)((double)fArray3[n2] + d * (double)fArray2[i]);
            }
            ((float[])this.features)[n] = Math.max(0.0f, (float)(10.0 * Math.log(((float[])this.features)[n]) / (double)LOG10));
        }
        this.forward(timeStamp, timeStamp2);
    }

    @Override
    public void setNumberOfFeatures(int n) {
        super.setNumberOfFeatures(n);
        this.bufferSize = -1;
    }

    private static double lin2mel(double d) {
        return 1127.0 * Math.log(1.0 + d / 700.0);
    }

    private static double mel2lin(double d) {
        return 700.0 * (Math.exp(d / 1127.0) - 1.0);
    }

    public double getFreqForBin(int n) {
        if (this.melCenter != null) {
            return MelSpectrum.mel2lin(this.melCenter[n]);
        }
        return Double.NaN;
    }

    public int getBinForFreq(double d) {
        if (this.melCenter != null) {
            int n;
            double d2 = MelSpectrum.lin2mel(d);
            for (n = 0; n < this.melCenter.length && !(d2 <= this.melCenter[n]); ++n) {
            }
            if (n >= this.numFeatures) {
                return this.numFeatures - 1;
            }
            return n;
        }
        return 0;
    }
}

