/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import java.util.ArrayList;
import java.util.List;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.SegmentMaker;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.BeadArray;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.buffers.MeanFilter;

public class PeakDetector
extends FeatureExtractor<Float, Float>
implements SegmentMaker {
    private BeadArray listeners = new BeadArray();
    private List<SegmentListener> segmentListeners = new ArrayList<SegmentListener>();
    private TimeStamp lastStartTime;
    private double resetDelay = 100.0;
    private float valueAtOnset = 0.0f;
    private float threshold = 0.0f;
    private float baseThreshold = 0.1f;
    private float[] lastValues = new float[13];
    private Buffer filter = new MeanFilter().generateBuffer(13);
    private final int W = 3;
    private final int WM = 3;
    private final int M = 13;
    private float alpha = 0.9f;

    public void setThreshold(float f) {
        this.baseThreshold = f;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public void setResetDelay(float f) {
        this.resetDelay = f;
    }

    public float getLastOnsetValue() {
        return this.valueAtOnset;
    }

    public int getLagInFrames() {
        return 3;
    }

    public int getBufferSize() {
        return 13;
    }

    public void setFilter(Buffer buffer) {
        assert (buffer.buf.length == 13);
        this.filter = buffer;
    }

    @Override
    public void process(TimeStamp timeStamp, TimeStamp timeStamp2, Float f) {
        if (this.lastStartTime == null) {
            this.lastStartTime = timeStamp;
        }
        for (int i = 1; i < 13; ++i) {
            this.lastValues[i - 1] = this.lastValues[i];
        }
        this.lastValues[12] = f.floatValue();
        float f2 = this.lastValues[9];
        if (f2 > this.threshold && timeStamp2.since(this.lastStartTime) > this.resetDelay) {
            boolean bl = true;
            for (int i = 6; i <= 12; ++i) {
                if (i == 9 || !(f2 < this.lastValues[i])) continue;
                bl = false;
            }
            if (bl) {
                float f3 = 0.0f;
                for (int i = 1; i < 13; ++i) {
                    f3 += this.lastValues[i] * this.filter.buf[i];
                }
                if (f2 > (f3 += f.floatValue() * this.filter.buf[12]) + this.baseThreshold) {
                    this.valueAtOnset = f2;
                    this.features = Float.valueOf(this.valueAtOnset);
                    this.forward(timeStamp, timeStamp2);
                    for (SegmentListener segmentListener : this.segmentListeners) {
                        segmentListener.newSegment(this.lastStartTime, timeStamp2);
                    }
                    this.listeners.message(this);
                    this.lastStartTime = timeStamp2;
                }
            }
        }
        this.threshold = Math.max(f2, this.alpha * this.threshold + (1.0f - this.alpha) * f2);
    }

    public void addMessageListener(Bead bead) {
        this.listeners.add(bead);
    }

    public void removeMessageListener(Bead bead) {
        this.listeners.remove(bead);
    }

    @Override
    public void addSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.add(segmentListener);
    }

    @Override
    public void removeSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.remove(segmentListener);
    }
}

