/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.TimeStamp;

public class SpectralPeaks
extends FeatureExtractor<float[][], float[]> {
    static final int FIRSTBAND = 3;
    private float bin2hz = -1.0f;
    private float samplingRate;

    public SpectralPeaks(AudioContext audioContext) {
        this(audioContext, 10);
    }

    public SpectralPeaks(AudioContext audioContext, int n) {
        this.samplingRate = audioContext.getSampleRate();
        this.setNumberOfFeatures(n);
    }

    @Override
    public synchronized void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        int n;
        if (this.bin2hz < 0.0f) {
            this.bin2hz = this.samplingRate / (float)(2 * fArray.length - 1);
        }
        double[] dArray = new double[fArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = fArray[n];
        }
        for (n = 0; n < ((float[][])this.features).length; ++n) {
            double d = -1.0;
            int n2 = 0;
            for (int i = 3; i < fArray.length; ++i) {
                double d2 = dArray[i];
                if (!(d2 > d)) continue;
                d = d2;
                n2 = i;
            }
            double d3 = dArray[n2];
            double d4 = n2 <= 0 ? dArray[n2] : dArray[n2 - 1];
            double d5 = n2 < dArray.length - 1 ? dArray[n2 + 1] : dArray[n2];
            double d6 = (d5 + d4) / 2.0 - d3;
            double d7 = (d4 - d5) / (4.0 * d6);
            ((float[][])this.features)[n][0] = (float)((double)this.bin2hz * ((double)n2 + d7));
            ((float[][])this.features)[n][1] = (float)d;
            ((float[][])this.features)[n][1] = (float)Math.sqrt(((float[][])this.features)[n][1] / (float)fArray.length);
            if (Float.isNaN(((float[][])this.features)[n][0]) || ((float[][])this.features)[n][0] < 0.0f) {
                ((float[][])this.features)[n][0] = 0.0f;
                ((float[][])this.features)[n][1] = 0.0f;
            }
            dArray[n2] = -1.0;
        }
        this.forward(timeStamp, timeStamp2);
    }

    @Override
    public float[][] getFeatures() {
        float[][] fArray = (float[][])this.features;
        float[][] fArray2 = new float[fArray.length][fArray[0].length];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray2[i].length; ++j) {
                fArray2[i][j] = fArray[i][j];
            }
        }
        return fArray2;
    }

    @Override
    public void setNumberOfFeatures(int n) {
        this.features = new float[n][2];
        this.featureDescriptions = new String[n];
        for (int i = 0; i < n; ++i) {
            this.featureDescriptions[i] = "peak" + i;
        }
    }
}

