/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.segmenters;

import net.beadsproject.beads.analysis.AudioSegmenter;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.buffers.HanningWindow;

public class ShortFrameSegmenter
extends AudioSegmenter {
    private int chunkSize;
    private int hopSize;
    private float[][] chunks;
    private int cycleLen;
    private int count;
    private TimeStamp lastTimeStamp;
    private TimeStamp beginningTimeStamp;
    private Buffer window;

    public ShortFrameSegmenter(AudioContext audioContext) {
        super(audioContext);
        this.hopSize = this.chunkSize = audioContext.getBufferSize();
        this.window = new HanningWindow().getDefault();
        this.count = 0;
        this.setupBuffers();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int n) {
        this.chunkSize = n;
        this.setupBuffers();
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public void setHopSize(int n) {
        this.hopSize = n;
        this.setupBuffers();
    }

    public void setWindow(Buffer buffer) {
        this.window = buffer;
    }

    private void setupBuffers() {
        int n = (int)Math.ceil((float)this.chunkSize / (float)this.hopSize);
        this.chunks = new float[n][this.chunkSize];
        this.cycleLen = n * this.hopSize;
    }

    @Override
    public void calculateBuffer() {
        if (this.beginningTimeStamp == null) {
            this.resetTimeStamp();
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            int n;
            for (int j = 0; j < this.chunks.length; ++j) {
                n = this.count - j * this.hopSize;
                if (n < 0) {
                    n += this.cycleLen;
                }
                if (n >= this.chunkSize) continue;
                this.chunks[j][n] = this.bufIn[0][i] * this.window.getValueFraction((float)n / (float)(this.chunkSize - 1));
            }
            ++this.count;
            if (this.count % this.hopSize == 0) {
                TimeStamp timeStamp = TimeStamp.add(this.context, this.context.generateTimeStamp(i), this.beginningTimeStamp);
                n = this.count / this.hopSize - 1;
                this.segment(this.lastTimeStamp, timeStamp, this.chunks[n]);
                this.lastTimeStamp = timeStamp;
            }
            this.count %= this.cycleLen;
        }
    }

    @Override
    public void resetTimeStamp() {
        this.lastTimeStamp = this.context.generateTimeStamp(0);
        this.beginningTimeStamp = this.context.generateTimeStamp(0);
        this.count = 0;
    }

    @Override
    public void setLastTimeStamp(TimeStamp timeStamp) {
        this.lastTimeStamp = timeStamp;
        this.count = 0;
    }

    @Override
    public void setBeginningTimeStamp(TimeStamp timeStamp) {
        this.beginningTimeStamp = timeStamp;
        this.count = 0;
    }
}

