/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.beadsproject.beads.core.AudioIO;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.IOAudioFormat;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.core.io.NonrealtimeIO;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.events.AudioContextStopTrigger;
import net.beadsproject.beads.ugens.DelayTrigger;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.RecordToSample;

public class AudioContext {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private AudioIO audioIO;
    private IOAudioFormat audioFormat;
    private boolean stopped;
    public final Gain out;
    private long timeStep;
    private boolean logTime;
    private int bufferSizeInFrames;
    private int maxReserveBufs;
    private ArrayList<float[]> bufferStore;
    private int bufStoreIndex;
    private float[] zeroBuf;
    private long nanoLeap;
    private boolean lastFrameGood;
    private final ConcurrentLinkedQueue<Bead> beforeFrameQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> afterFrameQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> beforeEveryFrameList = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> afterEveryFrameList = new ConcurrentLinkedQueue();

    public AudioContext() {
        this(512);
    }

    public AudioContext(int n) {
        Object object;
        AudioIO audioIO = null;
        try {
            object = Class.forName("net.beadsproject.beads.core.io.JavaSoundAudioIO");
            Constructor<?> constructor = ((Class)object).getConstructor(new Class[0]);
            audioIO = (AudioIO)constructor.newInstance(new Object[0]);
            System.out.println("AudioContext : no AudioIO specified, using default => " + ((Class)object).getName() + ".");
        }
        catch (Exception exception) {
            System.out.println("AudioContext : warning : unable to find default (JavaSound) AudioIO.");
            System.out.println("AudioContext : warning : reverting to NonrealtimeIO. You can still process audio but don't expect to hear anything.");
            audioIO = new NonrealtimeIO();
        }
        object = AudioContext.defaultAudioFormat(2, 2);
        this.audioIO = audioIO;
        this.audioIO.context = this;
        this.audioFormat = object;
        this.setBufferSize(n);
        this.logTime = false;
        this.maxReserveBufs = 50;
        this.stopped = true;
        this.out = new Gain(this, ((IOAudioFormat)object).outputs);
        this.audioIO.prepare();
    }

    public AudioContext(AudioIO audioIO) {
        this(audioIO, 512, AudioContext.defaultAudioFormat(2, 2));
    }

    public AudioContext(AudioIO audioIO, int n) {
        this(audioIO, n, AudioContext.defaultAudioFormat(2, 2));
    }

    public AudioContext(AudioIO audioIO, int n, IOAudioFormat iOAudioFormat) {
        this.audioIO = audioIO;
        this.audioIO.context = this;
        this.audioFormat = iOAudioFormat;
        this.setBufferSize(n);
        this.logTime = false;
        this.maxReserveBufs = 50;
        this.stopped = true;
        this.out = new Gain(this, iOAudioFormat.outputs);
        this.audioIO.prepare();
    }

    public UGen getAudioInput(int[] nArray) {
        return this.audioIO.getAudioInput(nArray);
    }

    public UGen getAudioInput() {
        int[] nArray = new int[this.audioFormat.inputs];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + 1;
        }
        return this.audioIO.getAudioInput(nArray);
    }

    private void setupBufs() {
        this.bufferStore = new ArrayList();
        while (this.bufferStore.size() < this.maxReserveBufs) {
            this.bufferStore.add(new float[this.bufferSizeInFrames]);
        }
        this.zeroBuf = new float[this.bufferSizeInFrames];
    }

    protected void update() {
        try {
            this.bufStoreIndex = 0;
            Arrays.fill(this.zeroBuf, 0.0f);
            this.sendBeforeFrameMessages();
            this.out.update();
            this.sendAfterFrameMessages();
            ++this.timeStep;
            if (Thread.interrupted()) {
                System.out.println("Thread interrupted");
            }
            if (this.logTime && this.timeStep % 100L == 0L) {
                System.out.println(this.samplesToMs(this.timeStep * (long)this.bufferSizeInFrames) / 1000.0 + " (seconds)");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public float[] getBuf() {
        if (this.bufStoreIndex < this.bufferStore.size()) {
            return this.bufferStore.get(this.bufStoreIndex++);
        }
        float[] fArray = new float[this.bufferSizeInFrames];
        this.bufferStore.add(fArray);
        ++this.bufStoreIndex;
        return fArray;
    }

    public float[] getCleanBuf() {
        float[] fArray = this.getBuf();
        Arrays.fill(fArray, 0.0f);
        return fArray;
    }

    public float[] getZeroBuf() {
        return this.zeroBuf;
    }

    public void runNonRealTime() {
        if (this.stopped) {
            this.stopped = false;
            this.reset();
            while (this.out != null && !this.stopped) {
                this.bufStoreIndex = 0;
                Arrays.fill(this.zeroBuf, 0.0f);
                if (!this.out.isPaused()) {
                    this.out.update();
                }
                ++this.timeStep;
                if (!this.logTime || this.timeStep % 100L != 0L) continue;
                System.out.println(this.samplesToMs(this.timeStep * (long)this.bufferSizeInFrames) / 1000.0 + " (seconds)");
            }
        }
    }

    public void runForNMillisecondsNonRealTime(double d) {
        DelayTrigger delayTrigger = new DelayTrigger(this, d, new AudioContextStopTrigger(this));
        this.out.addDependent(delayTrigger);
        this.runNonRealTime();
    }

    private void setBufferSize(int n) {
        this.bufferSizeInFrames = n;
        this.setupBufs();
    }

    public int getBufferSize() {
        return this.bufferSizeInFrames;
    }

    public float getSampleRate() {
        return this.audioFormat.sampleRate;
    }

    public IOAudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public IOAudioFormat getAudioFormat(int n, int n2) {
        IOAudioFormat iOAudioFormat = new IOAudioFormat(this.audioFormat.sampleRate, this.audioFormat.bitDepth, n, n2);
        return iOAudioFormat;
    }

    public static IOAudioFormat defaultAudioFormat(int n, int n2) {
        return new IOAudioFormat(44100.0f, 16, n, n2, true, true);
    }

    public void postAudioFormatInfo() {
        System.out.println("Sample Rate: " + this.audioFormat.sampleRate);
        System.out.println("Inputs: " + this.audioFormat.inputs);
        System.out.println("Outputs: " + this.audioFormat.outputs);
        System.out.println("Bit Depth: " + this.audioFormat.bitDepth);
        System.out.println("Big Endian: " + this.audioFormat.bigEndian);
        System.out.println("Signed: " + this.audioFormat.signed);
    }

    public static void printCallChain(UGen uGen, int n) {
        Set<UGen> set = uGen.getConnectedInputs();
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("- " + uGen);
        for (UGen uGen2 : set) {
            AudioContext.printCallChain(uGen2, n + 1);
        }
    }

    public void printCallChain() {
        AudioContext.printCallChain(this.out, 0);
    }

    public double msToSamples(double d) {
        return d * ((double)this.audioFormat.sampleRate / 1000.0);
    }

    public double samplesToMs(double d) {
        return d / (double)this.audioFormat.sampleRate * 1000.0;
    }

    public long getTimeStep() {
        return this.timeStep;
    }

    public TimeStamp generateTimeStamp(int n) {
        return new TimeStamp(this, this.timeStep, n);
    }

    public double getTime() {
        return this.samplesToMs(this.getTimeStep() * (long)this.getBufferSize());
    }

    public void logTime(boolean bl) {
        this.logTime = bl;
    }

    public void record(double d, String string) throws Exception {
        Sample sample = new Sample(d, this.audioFormat.outputs, this.audioFormat.sampleRate);
        try {
            RecordToSample recordToSample = new RecordToSample(this, sample);
            recordToSample.addInput(this.out);
            this.out.addDependent(recordToSample);
            recordToSample.start();
            recordToSample.setKillListener(new AudioContextStopTrigger(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.isRunning()) {
        }
        sample.write(string);
    }

    public void quickie(UGen uGen) {
        this.out.addInput(uGen);
        this.start();
    }

    public void start() {
        if (this.stopped) {
            this.nanoLeap = (long)(1.0E9f * ((float)this.bufferSizeInFrames / this.audioFormat.sampleRate));
            this.lastFrameGood = true;
            this.reset();
            this.stopped = false;
            this.audioIO.start();
        }
    }

    public void reset() {
        this.timeStep = 0L;
    }

    public void stop() {
        this.stopped = true;
        this.audioIO.stop();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public AudioIO getAudioIO() {
        return this.audioIO;
    }

    public AudioContext invokeAfterFrame(Bead bead) {
        this.afterFrameQueue.offer(bead);
        return this;
    }

    public AudioContext invokeAfterEveryFrame(Bead bead) {
        this.afterEveryFrameList.offer(bead);
        return this;
    }

    public boolean stopInvokingAfterEveryFrame(Bead bead) {
        return this.afterEveryFrameList.remove(bead);
    }

    public AudioContext invokeBeforeFrame(Bead bead) {
        this.beforeFrameQueue.add(bead);
        return this;
    }

    public AudioContext invokeBeforeEveryFrame(Bead bead) {
        this.beforeEveryFrameList.offer(bead);
        return this;
    }

    public boolean stopInvokingBeforeEveryFrame(Bead bead) {
        return this.beforeEveryFrameList.remove(bead);
    }

    private void sendBeforeFrameMessages() {
        Bead bead;
        while ((bead = this.beforeFrameQueue.poll()) != null) {
            bead.message(null);
        }
        for (Bead bead2 : this.beforeEveryFrameList) {
            bead2.message(null);
        }
    }

    private void sendAfterFrameMessages() {
        Bead bead;
        while ((bead = this.afterFrameQueue.poll()) != null) {
            bead.message(null);
        }
        for (Bead bead2 : this.afterEveryFrameList) {
            bead2.message(null);
        }
    }
}

