/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import net.beadsproject.beads.core.AudioContext;

public class TimeStamp {
    public final AudioContext context;
    public final long timeStep;
    public final int index;
    private double timeMs;
    private long timeSamples;

    public TimeStamp(AudioContext audioContext, long l, int n) {
        this.context = audioContext;
        this.timeStep = l;
        this.index = n;
    }

    public TimeStamp(AudioContext audioContext, long l) {
        this.context = audioContext;
        this.timeStep = l / (long)audioContext.getBufferSize();
        this.index = (int)(l % (long)audioContext.getBufferSize());
    }

    public double getTimeMS() {
        this.timeMs = this.context.samplesToMs(this.getTimeSamples());
        return this.timeMs;
    }

    public long getTimeSamples() {
        this.timeSamples = this.timeStep * (long)this.context.getBufferSize() + (long)this.index;
        return this.timeSamples;
    }

    public double since(TimeStamp timeStamp) {
        return this.getTimeMS() - timeStamp.getTimeMS();
    }

    public boolean isBefore(TimeStamp timeStamp) {
        if (this.timeStep < timeStamp.timeStep) {
            return true;
        }
        return this.timeStep == timeStamp.timeStep && this.timeSamples < timeStamp.timeSamples;
    }

    public boolean isAfter(TimeStamp timeStamp) {
        if (this.timeStep > timeStamp.timeStep) {
            return true;
        }
        return this.timeStep == timeStamp.timeStep && this.timeSamples > timeStamp.timeSamples;
    }

    public static TimeStamp subtract(AudioContext audioContext, TimeStamp timeStamp, TimeStamp timeStamp2) {
        return new TimeStamp(audioContext, timeStamp.getTimeSamples() - timeStamp2.getTimeSamples());
    }

    public static TimeStamp add(AudioContext audioContext, TimeStamp timeStamp, TimeStamp timeStamp2) {
        return new TimeStamp(audioContext, timeStamp.getTimeSamples() + timeStamp2.getTimeSamples());
    }
}

