/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

public abstract class Pitch {
    public static final float LOG2 = 0.6931472f;
    public static final String[] pitchNames = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    public static final int[] dorian = new int[]{0, 2, 3, 5, 7, 9, 10};
    public static final int[] major = new int[]{0, 2, 4, 5, 7, 9, 11};
    public static final int[] minor = new int[]{0, 2, 3, 5, 7, 8, 10};
    public static final int[] circleOfFifths = new int[]{0, 5, 10, 3, 8, 1, 6, 11, 4, 9, 2, 7};
    public static final int[] pentatonic = new int[]{0, 2, 4, 7, 9};

    public static final float ftom(float f) {
        return Math.max(0.0f, (float)Math.log(f / 440.0f) / 0.6931472f * 12.0f + 69.0f);
    }

    public static final float mtof(float f) {
        return 440.0f * (float)Math.pow(2.0, (f - 69.0f) / 12.0f);
    }

    public static final int forceToScale(int n, int[] nArray, int n2) {
        int n3 = n % n2;
        int n4 = n / n2;
        int n5 = -1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (n3 < nArray[i]) continue;
            n5 = nArray[i];
            break;
        }
        if (n5 == -1) {
            n5 = n3;
        }
        return n4 * n2 + n5;
    }

    public static final int forceToScale(int n, int[] nArray) {
        return Pitch.forceToScale(n, nArray, 12);
    }

    public static final float forceFrequencyToScale(float f, int[] nArray) {
        return Pitch.mtof(Pitch.forceToScale((int)Pitch.ftom(f), nArray));
    }
}

