/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.audiofile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import net.beadsproject.beads.data.SampleAudioFormat;
import net.beadsproject.beads.data.audiofile.AudioFileReader;
import net.beadsproject.beads.data.audiofile.AudioFileType;
import net.beadsproject.beads.data.audiofile.AudioFileWriter;
import net.beadsproject.beads.data.audiofile.FileFormatException;
import net.beadsproject.beads.data.audiofile.OperationUnsupportedException;

public class WavFileReaderWriter
implements AudioFileReader,
AudioFileWriter {
    private static final int BUFFER_SIZE = 4096;
    private static final int FMT_CHUNK_ID = 544501094;
    private static final int DATA_CHUNK_ID = 1635017060;
    private static final int RIFF_CHUNK_ID = 1179011410;
    private static final int RIFF_TYPE_ID = 1163280727;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_IEEE_FLOAT = 3;
    private File file;
    private int bytesPerSample;
    private long numFrames;
    private FileOutputStream oStream;
    private FileInputStream iStream;
    private double floatScale;
    private double floatOffset;
    private boolean wordAlignAdjust;
    private int numChannels;
    private long sampleRate;
    private int blockAlign;
    private int validBits;
    private int compressionCode;
    private byte[] buffer;
    private int bufferPointer;
    private int bytesRead;
    private long frameCounter;
    private IOState ioState = IOState.CLOSED;

    public WavFileReaderWriter() {
        this.buffer = new byte[4096];
    }

    @Override
    public void writeAudioFile(float[][] fArray, String string, AudioFileType audioFileType, SampleAudioFormat sampleAudioFormat) throws IOException, OperationUnsupportedException, FileFormatException {
        if (!this.getSupportedFileTypesForWriting().contains((Object)audioFileType)) {
            throw new OperationUnsupportedException("Unsupported file type for writing: " + (Object)((Object)audioFileType));
        }
        this.sampleRate = (long)sampleAudioFormat.sampleRate;
        this.numChannels = fArray.length;
        this.validBits = sampleAudioFormat.bitDepth;
        this.numFrames = fArray[0].length;
        this.file = new File(string);
        this.ioState = IOState.WRITING;
        try {
            this.writeHeader();
            this.writeData(fArray);
            this.close();
        }
        catch (IOException iOException) {
            throw new IOException("Could not write audio file: " + iOException.getMessage());
        }
        catch (FileFormatException fileFormatException) {
            throw new FileFormatException("Could not write audio file: " + fileFormatException.getMessage());
        }
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForWriting() {
        HashSet<AudioFileType> hashSet = new HashSet<AudioFileType>();
        hashSet.add(AudioFileType.WAV);
        return hashSet;
    }

    @Override
    public float[][] readAudioFile(String string) throws IOException, OperationUnsupportedException, FileFormatException {
        if (!string.endsWith(".wav") && !string.endsWith(".WAV")) {
            throw new OperationUnsupportedException("Only wav files (ending in .wav or .WAV) are supported");
        }
        this.file = new File(string);
        float[][] fArray = null;
        try {
            this.readHeader();
            fArray = this.readData();
            this.close();
        }
        catch (IOException iOException) {
            throw new IOException("Could not read audio file: " + iOException.getMessage());
        }
        catch (FileFormatException fileFormatException) {
            throw new FileFormatException("Could not read audio file: " + fileFormatException.getMessage());
        }
        catch (OperationUnsupportedException operationUnsupportedException) {
            throw new OperationUnsupportedException("Could not read audio file: " + operationUnsupportedException.getMessage());
        }
        return fArray;
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForReading() {
        HashSet<AudioFileType> hashSet = new HashSet<AudioFileType>();
        hashSet.add(AudioFileType.WAV);
        return hashSet;
    }

    @Override
    public SampleAudioFormat getSampleAudioFormat() {
        return new SampleAudioFormat(this.sampleRate, this.validBits, this.numChannels);
    }

    private void writeHeader() throws IOException, FileFormatException {
        this.bytesPerSample = (this.validBits + 7) / 8;
        this.blockAlign = this.bytesPerSample * this.numChannels;
        if (this.numChannels < 1 || this.numChannels > 65535) {
            throw new FileFormatException("Illegal number of channels, valid range 1 to 65536");
        }
        if (this.numFrames < 0L) {
            throw new FileFormatException("Number of frames must be positive");
        }
        if (this.validBits < 2 || this.validBits > 65535) {
            throw new FileFormatException("Illegal number of valid bits, valid range 2 to 65536");
        }
        if (this.sampleRate < 0L) {
            throw new FileFormatException("Sample rate must be positive");
        }
        this.compressionCode = this.validBits == 32 || this.validBits == 64 ? 3 : 1;
        this.oStream = new FileOutputStream(this.file);
        long l = (long)this.blockAlign * this.numFrames;
        int n = this.compressionCode == 1 ? 16 : 18;
        long l2 = (long)(12 + n + 8) + l;
        if (l % 2L == 1L) {
            ++l2;
            this.wordAlignAdjust = true;
        } else {
            this.wordAlignAdjust = false;
        }
        WavFileReaderWriter.putLE(1179011410L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(l2, this.buffer, 4, 4);
        WavFileReaderWriter.putLE(1163280727L, this.buffer, 8, 4);
        this.oStream.write(this.buffer, 0, 12);
        long l3 = this.sampleRate * (long)this.blockAlign;
        WavFileReaderWriter.putLE(544501094L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(n, this.buffer, 4, 4);
        WavFileReaderWriter.putLE(this.compressionCode, this.buffer, 8, 2);
        WavFileReaderWriter.putLE(this.numChannels, this.buffer, 10, 2);
        WavFileReaderWriter.putLE(this.sampleRate, this.buffer, 12, 4);
        WavFileReaderWriter.putLE(l3, this.buffer, 16, 4);
        WavFileReaderWriter.putLE(this.blockAlign, this.buffer, 20, 2);
        WavFileReaderWriter.putLE(this.validBits, this.buffer, 22, 2);
        if (this.compressionCode == 3) {
            WavFileReaderWriter.putLE(0L, this.buffer, 24, 2);
        }
        this.oStream.write(this.buffer, 0, 8 + n);
        WavFileReaderWriter.putLE(1635017060L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(l, this.buffer, 4, 4);
        this.oStream.write(this.buffer, 0, 8);
        if (this.validBits > 8) {
            this.floatOffset = 0.0;
            this.floatScale = Long.MAX_VALUE >> 64 - this.validBits;
        } else {
            this.floatOffset = 1.0;
            this.floatScale = 0.5 * (double)((1 << this.validBits) - 1);
        }
        this.bufferPointer = 0;
        this.bytesRead = 0;
        this.frameCounter = 0L;
        this.ioState = IOState.WRITING;
    }

    private void writeData(float[][] fArray) throws IOException {
        int n = 0;
        int n2 = 10000;
        while ((long)n < this.numFrames) {
            long l = this.getFramesRemaining();
            int n3 = l > (long)n2 ? n2 : (int)l;
            this.writeFrames(fArray, n, n3);
            n += n3;
        }
    }

    private void readHeader() throws IOException, FileFormatException, OperationUnsupportedException {
        this.iStream = new FileInputStream(this.file);
        int n = this.iStream.read(this.buffer, 0, 12);
        if (n != 12) {
            throw new FileFormatException("Not enough wav file bytes for header");
        }
        long l = WavFileReaderWriter.getLE(this.buffer, 0, 4);
        long l2 = WavFileReaderWriter.getLE(this.buffer, 4, 4);
        long l3 = WavFileReaderWriter.getLE(this.buffer, 8, 4);
        if (l != 1179011410L) {
            throw new FileFormatException("Invalid Wav Header data, incorrect riff chunk ID");
        }
        if (l3 != 1163280727L) {
            throw new FileFormatException("Invalid Wav Header data, incorrect riff type ID");
        }
        if (this.file.length() != l2 + 8L) {
            throw new FileFormatException("Header chunk size (" + l2 + ") does not match file size (" + this.file.length() + ")");
        }
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            long l4;
            if ((n = this.iStream.read(this.buffer, 0, 8)) == -1) {
                throw new FileFormatException("Reached end of file without finding format chunk");
            }
            if (n != 8) {
                throw new FileFormatException("Could not read chunk header");
            }
            long l5 = WavFileReaderWriter.getLE(this.buffer, 0, 4);
            l2 = WavFileReaderWriter.getLE(this.buffer, 4, 4);
            long l6 = l4 = l2 % 2L == 1L ? l2 + 1L : l2;
            if (l5 == 544501094L) {
                bl = true;
                n = this.iStream.read(this.buffer, 0, 16);
                int n2 = (int)WavFileReaderWriter.getLE(this.buffer, 0, 2);
                if (n2 != 1 && n2 != 3) {
                    throw new OperationUnsupportedException("Compression Code " + n2 + " not supported");
                }
                this.compressionCode = n2;
                this.numChannels = (int)WavFileReaderWriter.getLE(this.buffer, 2, 2);
                this.sampleRate = WavFileReaderWriter.getLE(this.buffer, 4, 4);
                this.blockAlign = (int)WavFileReaderWriter.getLE(this.buffer, 12, 2);
                this.validBits = (int)WavFileReaderWriter.getLE(this.buffer, 14, 2);
                if (this.numChannels == 0) {
                    throw new FileFormatException("Number of channels specified in header is equal to zero");
                }
                if (this.blockAlign == 0) {
                    throw new FileFormatException("Block Align specified in header is equal to zero");
                }
                if (this.validBits < 2) {
                    throw new FileFormatException("Valid Bits specified in header is less than 2");
                }
                if (this.validBits > 64) {
                    throw new FileFormatException("Valid Bits specified in header is greater than 64, this is greater than a long can hold");
                }
                if (this.compressionCode == 3 && this.validBits != 32 && this.validBits != 64) {
                    throw new IOException("Only 32-bit and 64-bit Floating Point PCM files are supported");
                }
                this.bytesPerSample = (this.validBits + 7) / 8;
                if (this.bytesPerSample * this.numChannels != this.blockAlign) {
                    throw new FileFormatException("Block Align does not agree with bytes required for validBits and number of channels");
                }
                if ((l4 -= 16L) <= 0L) continue;
                this.iStream.skip(l4);
                continue;
            }
            if (l5 == 1635017060L) {
                if (!bl) {
                    throw new FileFormatException("Data chunk found before Format chunk");
                }
                if (l2 % (long)this.blockAlign != 0L) {
                    throw new FileFormatException("Data Chunk size is not multiple of Block Align");
                }
                break;
            }
            this.iStream.skip(l4);
        }
        this.numFrames = l2 / (long)this.blockAlign;
        bl2 = true;
        if (!bl2) {
            throw new FileFormatException("Did not find a data chunk");
        }
        if (this.validBits > 8) {
            this.floatOffset = 0.0;
            this.floatScale = 1 << this.validBits - 1;
        } else {
            this.floatOffset = -1.0;
            this.floatScale = 0.5 * (double)((1 << this.validBits) - 1);
        }
        this.bufferPointer = 0;
        this.bytesRead = 0;
        this.frameCounter = 0L;
        this.ioState = IOState.READING;
    }

    private float[][] readData() throws IOException {
        float[][] fArray = new float[this.numChannels][(int)this.numFrames];
        long l = 0L;
        int n = 0;
        int n2 = 10000;
        do {
            l = this.readFrames(fArray, n, n2);
            n = (int)((long)n + l);
        } while (l != 0L);
        return fArray;
    }

    private void close() throws IOException {
        if (this.iStream != null) {
            this.iStream.close();
            this.iStream = null;
        }
        if (this.oStream != null) {
            if (this.bufferPointer > 0) {
                this.oStream.write(this.buffer, 0, this.bufferPointer);
            }
            if (this.wordAlignAdjust) {
                this.oStream.write(0);
            }
            this.oStream.close();
            this.oStream = null;
        }
        this.ioState = IOState.CLOSED;
    }

    private int writeFrames(float[][] fArray, int n, int n2) throws IOException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample(Float.floatToIntBits(fArray[j][n]));
                }
                ++n;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample(Double.doubleToLongBits(fArray[j][n]));
                }
                ++n;
                ++this.frameCounter;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample((long)(this.floatScale * (this.floatOffset + (double)fArray[j][n])));
                }
                ++n;
                ++this.frameCounter;
            }
        }
        return n2;
    }

    private int writeFrames(double[][] dArray, int n, int n2) throws IOException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample(Float.floatToIntBits((float)dArray[j][n]));
                }
                ++n;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample(Double.doubleToLongBits(dArray[j][n]));
                }
                ++n;
                ++this.frameCounter;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    this.writeSample((long)(this.floatScale * (this.floatOffset + dArray[j][n])));
                }
                ++n;
                ++this.frameCounter;
            }
        }
        return n2;
    }

    private void writeSample(long l) throws IOException {
        for (int i = 0; i < this.bytesPerSample; ++i) {
            if (this.bufferPointer == 4096) {
                this.oStream.write(this.buffer, 0, 4096);
                this.bufferPointer = 0;
            }
            this.buffer[this.bufferPointer] = (byte)(l & 0xFFL);
            l >>= 8;
            ++this.bufferPointer;
        }
    }

    private int readFrames(float[][] fArray, int n, int n2) throws IOException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    fArray[j][n] = Float.intBitsToFloat((int)this.readSample());
                }
                ++n;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    fArray[j][n] = (float)Double.longBitsToDouble(this.readSample());
                }
                ++n;
                ++this.frameCounter;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    fArray[j][n] = (float)(this.floatOffset + (double)this.readSample() / this.floatScale);
                }
                ++n;
                ++this.frameCounter;
            }
        }
        return n2;
    }

    private int readFrames(double[][] dArray, int n, int n2) throws IOException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    dArray[j][n] = Float.intBitsToFloat((int)this.readSample());
                }
                ++n;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    dArray[j][n] = Double.longBitsToDouble(this.readSample());
                }
                ++n;
                ++this.frameCounter;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (this.frameCounter == this.numFrames) {
                    return i;
                }
                for (int j = 0; j < this.numChannels; ++j) {
                    dArray[j][n] = this.floatOffset + (double)this.readSample() / this.floatScale;
                }
                ++n;
                ++this.frameCounter;
            }
        }
        return n2;
    }

    private long readSample() throws IOException {
        long l = 0L;
        for (int i = 0; i < this.bytesPerSample; ++i) {
            if (this.bufferPointer == this.bytesRead) {
                int n = this.iStream.read(this.buffer, 0, 4096);
                if (n == -1) {
                    throw new IOException("Not enough data available");
                }
                this.bytesRead = n;
                this.bufferPointer = 0;
            }
            long l2 = this.buffer[this.bufferPointer];
            if (i < this.bytesPerSample - 1 || this.bytesPerSample == 1) {
                l2 &= 0xFFL;
            }
            l += l2 << i * 8;
            ++this.bufferPointer;
        }
        return l;
    }

    private long getFramesRemaining() {
        return this.numFrames - this.frameCounter;
    }

    private static long getLE(byte[] byArray, int n, int n2) {
        long l = byArray[n += --n2] & 0xFF;
        for (int i = 0; i < n2; ++i) {
            l = (l << 8) + (long)(byArray[--n] & 0xFF);
        }
        return l;
    }

    private static void putLE(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n;
        }
    }

    private static enum IOState {
        READING,
        WRITING,
        CLOSED;

    }
}

