/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.Static;

public class Clip
extends UGen
implements DataBeadReceiver {
    private float min;
    private float max;
    private UGen minUGen;
    private UGen maxUGen;
    private boolean isMinStatic;
    private boolean isMaxStatic;

    public Clip(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public Clip(AudioContext audioContext, int n) {
        super(audioContext, n, n);
        this.setRange(-1.0f, 1.0f);
    }

    @Override
    public void calculateBuffer() {
        if (this.isMinStatic && this.isMaxStatic) {
            for (int i = 0; i < this.ins; ++i) {
                float[] fArray = this.bufIn[i];
                float[] fArray2 = this.bufOut[i];
                for (int j = 0; j < this.bufferSize; ++j) {
                    float f = fArray[j];
                    fArray2[j] = f < this.min ? this.min : (f > this.max ? this.max : f);
                }
            }
        } else {
            this.minUGen.update();
            this.maxUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.min = this.minUGen.getValue(0, i);
                this.max = this.maxUGen.getValue(0, i);
                for (int j = 0; j < this.ins; ++j) {
                    float f = this.bufIn[j][i];
                    this.bufOut[j][i] = f < this.min ? this.min : (f > this.max ? this.max : f);
                }
            }
        }
    }

    public Clip setRange(float f, float f2) {
        this.setMinimum(f);
        this.setMaximum(f2);
        return this;
    }

    public float getMinimum() {
        return this.min;
    }

    public Clip setMinimum(float f) {
        this.min = f;
        if (this.isMinStatic) {
            ((Static)this.minUGen).setValue(f);
        } else {
            this.minUGen = new Static(this.context, f);
            this.isMinStatic = true;
        }
        return this;
    }

    public Clip setMinimum(UGen uGen) {
        if (uGen == null) {
            this.setMinimum(this.min);
        } else {
            this.minUGen = uGen;
            this.minUGen.update();
            this.min = this.minUGen.getValue();
            this.isMinStatic = false;
        }
        return this;
    }

    public UGen getMinimumUGen() {
        if (this.isMinStatic) {
            return null;
        }
        return this.minUGen;
    }

    public float getMaximum() {
        return this.max;
    }

    public Clip setMaximum(float f) {
        this.max = f;
        if (this.isMaxStatic) {
            ((Static)this.maxUGen).setValue(f);
        } else {
            this.maxUGen = new Static(this.context, f);
            this.isMaxStatic = true;
        }
        return this;
    }

    public Clip setMaximum(UGen uGen) {
        if (uGen == null) {
            this.setMaximum(this.max);
        } else {
            this.maxUGen = uGen;
            this.maxUGen.update();
            this.max = this.maxUGen.getValue();
            this.isMaxStatic = false;
        }
        return this;
    }

    public UGen getMaximumUGen() {
        if (this.isMaxStatic) {
            return null;
        }
        return this.maxUGen;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            UGen uGen = dataBead.getUGen("maximum");
            if (uGen == null) {
                this.setMaximum(dataBead.getFloat("maximum", this.max));
            } else {
                this.setMaximum(uGen);
            }
            uGen = dataBead.getUGen("minimum");
            if (uGen == null) {
                this.setMinimum(dataBead.getFloat("minimum", this.min));
            } else {
                this.setMinimum(uGen);
            }
        }
        return this;
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isMinStatic) {
            dataBead.put("minimum", (Object)Float.valueOf(this.min));
        } else {
            dataBead.put("minimum", (Object)this.minUGen);
        }
        if (this.isMaxStatic) {
            dataBead.put("maximum", (Object)Float.valueOf(this.max));
        } else {
            dataBead.put("maximum", (Object)this.maxUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("minimum", (Object)Float.valueOf(this.min));
        dataBead.put("maximum", (Object)Float.valueOf(this.max));
        return dataBead;
    }
}

