/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.RMS;

public class Compressor
extends UGen
implements DataBeadReceiver {
    private int channels;
    private int memSize;
    private int index = 0;
    private float[][] delayMem;
    private UGen powerUGen;
    private BiquadFilter pf;
    private float downstep = 0.9998f;
    private float upstep = 1.0002f;
    private float ratio = 0.5f;
    private float threshold = 0.5f;
    private float knee = 1.0f;
    private float tok;
    private float kt;
    private float ikp1;
    private float ktrm1;
    private float tt1mr;
    private float attack;
    private float decay;
    private float currval = 1.0f;
    private float target = 1.0f;
    private float delay;
    private int delaySamps;
    private int rmsMemorySize = 500;
    private UGen myInputs;
    private float[][] myBufIn;

    public Compressor(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public Compressor(AudioContext audioContext, int n) {
        this(audioContext, n, 0.0f, null);
    }

    public Compressor(AudioContext audioContext, int n, UGen uGen) {
        this(audioContext, n, 0.0f, uGen);
    }

    public Compressor(AudioContext audioContext, int n, float f) {
        this(audioContext, n, f, null);
    }

    public Compressor(AudioContext audioContext, int n, float f, UGen uGen) {
        super(audioContext, n, n);
        this.channels = n;
        this.delay = f;
        this.delaySamps = (int)this.delay;
        this.memSize = (int)audioContext.msToSamples(this.delay) + 1;
        this.delayMem = new float[n][this.memSize];
        this.myBufIn = this.bufIn;
        class MyInputs
        extends UGen {
            MyInputs(AudioContext audioContext, int n) {
                super(audioContext, 0, n);
                this.bufOut = Compressor.this.myBufIn;
                this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
            }

            @Override
            public void calculateBuffer() {
            }
        }
        this.myInputs = new MyInputs(audioContext, n);
        this.setSideChain(uGen).setAttack(1.0f).setDecay(0.5f).setRatio(2.0f).setThreshold(0.5f).setKnee(0.5f);
    }

    @Override
    public void calculateBuffer() {
        this.pf.update();
        if (this.channels == 1) {
            float[] fArray = this.bufIn[0];
            float[] fArray2 = this.bufOut[0];
            float[] fArray3 = this.delayMem[0];
            for (int i = 0; i < this.bufferSize; ++i) {
                float f = this.pf.getValue(0, i);
                if (f <= this.tok) {
                    this.target = 1.0f;
                } else if (f >= this.kt) {
                    this.target = ((f - this.threshold) * this.ratio + this.threshold) / f;
                } else {
                    float f2 = (f - this.tok) * this.ikp1 + this.tok;
                    this.target = ((this.ktrm1 * f2 + this.tt1mr) * (f - f2) / (f2 * (this.knee - 1.0f)) + f2) / f;
                }
                if (this.currval > this.target) {
                    this.currval *= this.downstep;
                    if (this.currval < this.target) {
                        this.currval = this.target;
                    }
                } else if (this.currval < this.target) {
                    this.currval *= this.upstep;
                    if (this.currval > this.target) {
                        this.currval = this.target;
                    }
                }
                fArray3[this.index] = fArray[i];
                fArray2[i] = fArray3[(this.index + this.delaySamps) % this.memSize] * this.currval;
                this.index = (this.index + 1) % this.memSize;
            }
        } else {
            for (int i = 0; i < this.bufferSize; ++i) {
                float f = this.pf.getValue(0, i);
                if (f <= this.tok) {
                    this.target = 1.0f;
                } else if (f >= this.kt) {
                    this.target = ((f - this.threshold) * this.ratio + this.threshold) / f;
                } else {
                    float f3 = (f - this.tok) * this.ikp1 + this.tok;
                    this.target = (this.ktrm1 * f3 + this.tt1mr) * (f - f3) / (f3 * (this.knee - 1.0f)) + f3;
                }
                if (this.currval > this.target) {
                    this.currval *= this.downstep;
                    if (this.currval < this.target) {
                        this.currval = this.target;
                    }
                } else if (this.currval < this.target) {
                    this.currval *= this.upstep;
                    if (this.currval > this.target) {
                        this.currval = this.target;
                    }
                }
                int n = (this.index + this.delaySamps) % this.memSize;
                for (int j = 0; j < this.channels; ++j) {
                    this.delayMem[j][this.index] = this.bufIn[j][i];
                    this.bufOut[j][i] = this.delayMem[j][n] * this.currval;
                }
                this.index = (this.index + 1) % this.memSize;
            }
        }
    }

    private void calcVals() {
        this.tok = this.threshold / this.knee;
        this.kt = this.knee * this.threshold;
        this.ikp1 = 1.0f / (this.knee + 1.0f);
        this.ktrm1 = this.knee * this.ratio - 1.0f;
        this.tt1mr = this.threshold * (1.0f - this.ratio);
    }

    public Compressor setSideChain(UGen uGen) {
        this.pf = new BiquadFilter(this.context, 1, BiquadFilter.BUTTERWORTH_LP).setFrequency(31.0f);
        if (uGen == null) {
            this.powerUGen = new RMS(this.context, this.channels, this.rmsMemorySize);
            this.powerUGen.addInput(this.myInputs);
            this.pf.addInput(this.powerUGen);
        } else {
            this.powerUGen = new RMS(this.context, uGen.getOuts(), this.rmsMemorySize);
            this.powerUGen.addInput(uGen);
            this.pf.addInput(this.powerUGen);
        }
        return this;
    }

    public float getAttack() {
        return this.attack;
    }

    public Compressor setAttack(float f) {
        if (f < 1.0E-4f) {
            f = 1.0E-4f;
        }
        this.attack = f;
        this.downstep = (float)Math.pow(Math.pow(10.0, f / 20.0f), -1000.0f / this.context.getSampleRate());
        return this;
    }

    public float getDecay() {
        return this.decay;
    }

    public Compressor setDecay(float f) {
        if (f < 1.0E-4f) {
            f = 1.0E-4f;
        }
        this.decay = f;
        this.upstep = (float)Math.pow(Math.pow(10.0, f / 20.0f), 1000.0f / this.context.getSampleRate());
        return this;
    }

    public float getRatio() {
        return 1.0f / this.ratio;
    }

    public Compressor setRatio(float f) {
        if (f <= 0.0f) {
            f = 0.01f;
        }
        this.ratio = 1.0f / f;
        this.calcVals();
        return this;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public Compressor setThreshold(float f) {
        this.threshold = f;
        this.calcVals();
        return this;
    }

    public float getKnee() {
        return this.knee - 1.0f;
    }

    public Compressor setKnee(float f) {
        this.knee = f + 1.0f;
        this.calcVals();
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            this.setThreshold(dataBead.getFloat("threshold", this.threshold));
            this.setRatio(dataBead.getFloat("ratio", this.getRatio()));
            this.setAttack(dataBead.getFloat("attack", this.getAttack()));
            this.setDecay(dataBead.getFloat("decay", this.getDecay()));
            this.setKnee(dataBead.getFloat("knee", this.getKnee()));
            this.setSideChain(dataBead.getUGen("sidechain"));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("threshold", (Object)Float.valueOf(this.getThreshold()));
        dataBead.put("ratio", (Object)Float.valueOf(this.getRatio()));
        dataBead.put("attack", (Object)Float.valueOf(this.getAttack()));
        dataBead.put("decay", (Object)Float.valueOf(this.getDecay()));
        dataBead.put("knee", (Object)Float.valueOf(this.getKnee()));
        return dataBead;
    }

    public float getCurrentCompression() {
        return this.currval;
    }
}

