/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Glide
extends UGen {
    private float currentValue;
    private float previousValue;
    private float targetValue;
    private int glideTime;
    private int countSinceGlide;
    private boolean gliding;
    private boolean nothingChanged;

    public Glide(AudioContext audioContext, float f, float f2) {
        super(audioContext, 1);
        this.currentValue = f;
        this.countSinceGlide = 0;
        this.gliding = false;
        this.nothingChanged = false;
        this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
        this.outputPauseRegime = UGen.OutputPauseRegime.RETAIN;
        this.bufOut[0] = new float[this.bufferSize];
        this.setGlideTime(f2);
    }

    public Glide(AudioContext audioContext, float f) {
        this(audioContext, f, 100.0f);
    }

    public Glide(AudioContext audioContext) {
        this(audioContext, 0.0f);
    }

    @Override
    public void setValue(float f) {
        this.targetValue = f;
        this.gliding = true;
        this.nothingChanged = false;
        this.countSinceGlide = 0;
        this.previousValue = this.currentValue;
    }

    public void setValueImmediately(float f) {
        this.currentValue = f;
        this.gliding = false;
        this.nothingChanged = false;
        this.countSinceGlide = 0;
    }

    public void setGlideTime(float f) {
        this.glideTime = (int)this.context.msToSamples(f);
    }

    public float getGlideTime() {
        return (float)this.context.samplesToMs(this.glideTime);
    }

    @Override
    public void calculateBuffer() {
        if (!this.nothingChanged) {
            this.nothingChanged = true;
            for (int i = 0; i < this.bufferSize; ++i) {
                if (this.gliding) {
                    if ((float)this.glideTime <= 0.0f) {
                        this.gliding = false;
                        this.previousValue = this.currentValue = this.targetValue;
                        this.bufOut[0][i] = this.currentValue;
                        this.nothingChanged = false;
                    } else if (this.countSinceGlide > this.glideTime) {
                        this.gliding = false;
                        this.bufOut[0][i] = this.previousValue = this.targetValue;
                    } else {
                        float f = (float)this.countSinceGlide / (float)this.glideTime;
                        this.bufOut[0][i] = this.currentValue = f * this.targetValue + (1.0f - f) * this.previousValue;
                        this.nothingChanged = false;
                    }
                    ++this.countSinceGlide;
                    continue;
                }
                this.bufOut[0][i] = this.currentValue;
            }
        }
    }
}

