/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;

public class OnePoleFilter
extends IIRFilter
implements DataBeadReceiver {
    private float freq;
    private float b0;
    private float a1;
    private float y1 = 0.0f;
    private UGen freqUGen;
    protected float samplingfreq;
    protected float two_pi_over_sf;
    protected boolean isFreqStatic;

    public OnePoleFilter(AudioContext audioContext, float f) {
        super(audioContext, 1, 1);
        this.samplingfreq = audioContext.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.setFrequency(f);
    }

    public OnePoleFilter(AudioContext audioContext, UGen uGen) {
        super(audioContext, 1, 1);
        this.samplingfreq = audioContext.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.setFrequency(uGen);
    }

    protected void calcVals() {
        this.b0 = (float)Math.sin(this.two_pi_over_sf * this.freq);
        this.a1 = this.b0 - 1.0f;
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        float[] fArray2 = this.bufOut[0];
        if (this.isFreqStatic) {
            for (int i = 0; i < this.bufferSize; ++i) {
                fArray2[i] = this.y1 = this.b0 * fArray[i] - this.a1 * this.y1;
            }
        } else {
            this.freqUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.b0 = (float)Math.sin(this.two_pi_over_sf * this.freqUGen.getValue(0, i));
                this.a1 = this.b0 - 1.0f;
                fArray2[i] = this.y1 = this.b0 * fArray[i] - this.a1 * this.y1;
            }
            this.freq = this.freqUGen.getValue(0, this.bufferSize - 1);
        }
        if (Float.isNaN(this.y1)) {
            this.y1 = 0.0f;
        }
    }

    public float getFrequency() {
        return this.freq;
    }

    public OnePoleFilter setFrequency(float f) {
        this.freq = f;
        this.b0 = (float)Math.sin(this.two_pi_over_sf * f);
        this.a1 = this.b0 - 1.0f;
        this.isFreqStatic = true;
        return this;
    }

    public OnePoleFilter setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = uGen;
            uGen.update();
            this.freq = uGen.getValue();
            this.isFreqStatic = false;
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public OnePoleFilter setFreq(float f) {
        return this.setFrequency(f);
    }

    @Deprecated
    public OnePoleFilter setFreq(UGen uGen) {
        return this.setFrequency(uGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public OnePoleFilter setParams(DataBead dataBead) {
        Object object;
        if (dataBead != null && (object = dataBead.get("frequency")) != null) {
            if (object instanceof UGen) {
                this.setFrequency((UGen)object);
            } else {
                this.setFrequency(dataBead.getFloat("frequency", this.freq));
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isFreqStatic) {
            dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            dataBead.put("frequency", (Object)this.freqUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        return dataBead;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        this.setParams(dataBead);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float f) {
        return OnePoleFilter.calculateFilterResponse(new float[]{this.b0}, new float[]{1.0f, this.a1}, f, this.context.getSampleRate());
    }
}

