/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Phasor
extends UGen {
    private UGen frequencyUGen;
    protected float frequency = 0.0f;
    protected double phase = 0.0;
    protected double one_over_sr;

    public Phasor(AudioContext audioContext) {
        super(audioContext, 0, 1);
        this.one_over_sr = 1.0 / (double)audioContext.getSampleRate();
    }

    public Phasor(AudioContext audioContext, float f) {
        this(audioContext);
        this.setFrequency(f);
    }

    public Phasor(AudioContext audioContext, UGen uGen) {
        this(audioContext);
        this.setFrequency(uGen);
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufOut[0];
        if (this.frequencyUGen == null) {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.phase = ((this.phase + this.one_over_sr * (double)this.frequency) % 1.0 + 1.0) % 1.0;
                fArray[i] = (float)this.phase;
            }
        } else {
            this.frequencyUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.frequency = this.frequencyUGen.getValue(0, i);
                this.phase = ((this.phase + this.one_over_sr * (double)this.frequency) % 1.0 + 1.0) % 1.0;
                fArray[i] = (float)this.phase;
            }
        }
    }

    public UGen getFrequencyUGen() {
        return this.frequencyUGen;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public Phasor setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.frequency);
        } else {
            this.frequencyUGen = uGen;
            uGen.update();
            this.frequency = uGen.getValue();
        }
        return this;
    }

    public Phasor setFrequency(float f) {
        this.frequency = f;
        this.frequencyUGen = null;
        return this;
    }

    public float getPhase() {
        return (float)this.phase;
    }

    public Phasor setPhase(float f) {
        this.phase = f;
        return this;
    }
}

