/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class SignalReporter
extends UGen {
    private long interval = 44100L;
    private long index = 44100L;
    private long count = 0L;
    private long total = 0L;
    private float flInt;
    protected String name = "";

    public SignalReporter(AudioContext audioContext, float f, String string) {
        super(audioContext, 1, 0);
        this.setInterval(f);
        this.index = this.interval;
        this.name = string;
        audioContext.out.addDependent(this);
    }

    public void setInterval(float f) {
        if (f <= 0.0f) {
            f = 1000.0f;
        }
        this.flInt = f;
        this.interval = (long)this.context.msToSamples(f);
    }

    public float getInterval() {
        return this.flInt;
    }

    @Override
    public void calculateBuffer() {
        if (this.index >= this.interval) {
            this.notify(this.count, this.bufIn[0][0]);
            ++this.count;
            this.index -= this.interval;
        }
        this.total += (long)this.bufferSize;
        this.index += (long)this.bufferSize;
    }

    public void notify(long l, float f) {
        System.out.println("SignalReporter " + this.name + ", report #" + l + ": " + f);
    }

    public void resetCount() {
        this.count = 0L;
    }
}

