/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.TapIn;

public class TapOut
extends UGen {
    private TapIn ti;
    private UGen delayUGen;
    private float delay;
    private float sampsPerMS;
    private InterpolationType mode;
    private int sampDelayInt;
    private int sampDelayAPInt;
    private float lastY = 0.0f;
    private float sampDelayFloat;
    private float g;
    public static final InterpolationType NO_INTERP = InterpolationType.NO_INTERP;
    public static final InterpolationType LINEAR = InterpolationType.LINEAR;
    public static final InterpolationType ALLPASS = InterpolationType.ALLPASS;

    protected TapOut(AudioContext audioContext, TapIn tapIn) {
        super(audioContext, 0, 1);
        this.sampsPerMS = (float)audioContext.msToSamples(1.0);
        this.ti = tapIn;
        this.addDependent(tapIn);
        this.setMode(NO_INTERP);
    }

    public TapOut(AudioContext audioContext, TapIn tapIn, float f) {
        this(audioContext, tapIn);
        this.setDelay(f);
    }

    public TapOut(AudioContext audioContext, TapIn tapIn, UGen uGen) {
        this(audioContext, tapIn);
        this.setDelay(uGen);
    }

    public TapOut(AudioContext audioContext, TapIn tapIn, InterpolationType interpolationType, float f) {
        this(audioContext, tapIn);
        this.setDelay(f).setMode(interpolationType);
    }

    public TapOut(AudioContext audioContext, TapIn tapIn, InterpolationType interpolationType, UGen uGen) {
        this(audioContext, tapIn);
        this.setDelay(this.delay).setMode(interpolationType);
    }

    @Override
    public void calculateBuffer() {
        if (this.delayUGen == null) {
            switch (this.mode) {
                case NO_INTERP: {
                    this.ti.fillBufferNoInterp(this.bufOut[0], this.sampDelayInt);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case LINEAR: {
                    this.ti.fillBufferLinear(this.bufOut[0], this.sampDelayFloat);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case ALLPASS: {
                    this.lastY = this.ti.fillBufferAllpass(this.bufOut[0], this.sampDelayAPInt, this.g, this.lastY);
                }
            }
        } else {
            this.delayUGen.update();
            switch (this.mode) {
                case NO_INTERP: {
                    this.ti.fillBufferNoInterp(this.bufOut[0], this.delayUGen);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case LINEAR: {
                    this.ti.fillBufferLinear(this.bufOut[0], this.delayUGen);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case ALLPASS: {
                    this.lastY = this.ti.fillBufferAllpass(this.bufOut[0], this.delayUGen, this.lastY);
                }
            }
        }
    }

    public float getDelay() {
        return this.delay;
    }

    public TapOut setDelay(float f) {
        this.delay = f;
        this.sampDelayFloat = this.sampsPerMS * f;
        this.sampDelayInt = (int)((double)this.sampDelayFloat + 0.5);
        this.sampDelayAPInt = (int)this.sampDelayFloat;
        float f2 = this.sampDelayFloat % 1.0f;
        this.g = (1.0f - f2) / (1.0f + f2);
        this.delayUGen = null;
        return this;
    }

    public TapOut setDelay(UGen uGen) {
        if (uGen == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = uGen;
            uGen.update();
            this.delay = uGen.getValue();
        }
        return this;
    }

    public UGen getDelayUGen() {
        return this.delayUGen;
    }

    public TapOut setMode(InterpolationType interpolationType) {
        switch (interpolationType) {
            case NO_INTERP: {
                this.mode = interpolationType;
                break;
            }
            case LINEAR: {
                this.mode = interpolationType;
                break;
            }
            case ALLPASS: {
                this.mode = interpolationType;
            }
        }
        return this;
    }

    public InterpolationType getMode() {
        return this.mode;
    }

    public static enum InterpolationType {
        NO_INTERP,
        LINEAR,
        ALLPASS;

    }
}

