/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioIO;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.core.IOAudioFormat;
import net.beadsproject.beads.core.UGen;

public class JavaSoundAudioIO
extends AudioIO {
    public static final int DEFAULT_SYSTEM_BUFFER_SIZE = 5000;
    private Mixer mixer;
    private SourceDataLine sourceDataLine;
    private int systemBufferSizeInFrames;
    private Thread audioThread;
    private int threadPriority;
    private byte[] bbuf;

    public JavaSoundAudioIO() {
        this(5000);
    }

    public JavaSoundAudioIO(int n) {
        this.systemBufferSizeInFrames = n;
        this.setThreadPriority(10);
    }

    public boolean create() {
        IOAudioFormat iOAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(iOAudioFormat.sampleRate, iOAudioFormat.bitDepth, iOAudioFormat.outputs, iOAudioFormat.signed, iOAudioFormat.bigEndian);
        this.getDefaultMixerIfNotAlreadyChosen();
        if (this.mixer == null) {
            return false;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.sourceDataLine = (SourceDataLine)this.mixer.getLine(info);
            if (this.systemBufferSizeInFrames < 0) {
                this.sourceDataLine.open(audioFormat);
            } else {
                this.sourceDataLine.open(audioFormat, this.systemBufferSizeInFrames * audioFormat.getFrameSize());
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println(((Object)((Object)this)).getClass().getName() + " : Error getting line\n");
        }
        return true;
    }

    private void getDefaultMixerIfNotAlreadyChosen() {
        if (this.mixer == null) {
            this.selectMixer(0);
        }
    }

    public void chooseMixerCommandLine() {
        System.out.println("Choose a mixer...");
        JavaSoundAudioIO.printMixerInfo();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            this.selectMixer(Integer.parseInt(bufferedReader.readLine()) - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectMixer(int n) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        this.mixer = AudioSystem.getMixer(infoArray[n]);
        if (this.mixer != null) {
            System.out.print("JavaSoundAudioIO: Chosen mixer is ");
            System.out.println(this.mixer.getMixerInfo().getName() + ".");
        } else {
            System.out.println("JavaSoundAudioIO: Failed to get mixer.");
        }
    }

    public static void printMixerInfo() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            String string = infoArray[i].getName();
            if (string.equals("")) {
                string = "No name";
            }
            System.out.println(i + 1 + ") " + string + " --- " + infoArray[i].getDescription());
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo();
            for (int j = 0; j < infoArray2.length; ++j) {
                System.out.println("  - " + infoArray2[j].toString());
            }
        }
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
        if (this.audioThread != null) {
            this.audioThread.setPriority(this.threadPriority);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    protected boolean destroy() {
        this.sourceDataLine.drain();
        this.sourceDataLine.stop();
        this.sourceDataLine.close();
        this.sourceDataLine = null;
        this.mixer.close();
        this.mixer = null;
        return true;
    }

    protected boolean start() {
        this.audioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JavaSoundAudioIO.this.create();
                JavaSoundAudioIO.this.runRealTime();
                JavaSoundAudioIO.this.destroy();
            }
        });
        this.audioThread.setPriority(this.threadPriority);
        this.audioThread.start();
        return true;
    }

    private void runRealTime() {
        AudioContext audioContext = this.getContext();
        IOAudioFormat iOAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(iOAudioFormat.sampleRate, iOAudioFormat.bitDepth, iOAudioFormat.outputs, iOAudioFormat.signed, iOAudioFormat.bigEndian);
        int n = audioContext.getBufferSize();
        this.bbuf = new byte[n * audioFormat.getFrameSize()];
        float[] fArray = new float[audioFormat.getChannels() * n];
        this.sourceDataLine.start();
        while (audioContext.isRunning()) {
            this.update();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < audioFormat.getChannels(); ++j) {
                    fArray[n2++] = audioContext.out.getValue(j, i);
                }
            }
            AudioUtils.floatToByte((byte[])this.bbuf, (float[])fArray, (boolean)audioFormat.isBigEndian());
            this.sourceDataLine.write(this.bbuf, 0, this.bbuf.length);
        }
    }

    protected UGen getAudioInput(int[] nArray) {
        IOAudioFormat iOAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(iOAudioFormat.sampleRate, iOAudioFormat.bitDepth, iOAudioFormat.inputs, iOAudioFormat.signed, iOAudioFormat.bigEndian);
        return new JavaSoundRTInput(this.getContext(), audioFormat);
    }

    private class JavaSoundRTInput
    extends UGen {
        private AudioFormat audioFormat;
        private TargetDataLine targetDataLine;
        private boolean javaSoundInitialized;
        private float[] interleavedSamples;
        private byte[] bbuf;

        JavaSoundRTInput(AudioContext audioContext, AudioFormat audioFormat) {
            super(audioContext, audioFormat.getChannels());
            this.audioFormat = audioFormat;
            this.javaSoundInitialized = false;
        }

        public void initJavaSound() {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            try {
                int n = 5000;
                this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                this.targetDataLine.open(this.audioFormat, n);
                if (this.targetDataLine == null) {
                    System.out.println("no line");
                } else {
                    System.out.println("CHOSEN INPUT: " + this.targetDataLine.getLineInfo() + ", buffer size in bytes: " + n);
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
                System.out.println(((Object)((Object)this)).getClass().getName() + " : Error getting line\n");
            }
            this.targetDataLine.start();
            this.javaSoundInitialized = true;
            this.interleavedSamples = new float[this.bufferSize * this.audioFormat.getChannels()];
            this.bbuf = new byte[this.bufferSize * this.audioFormat.getFrameSize()];
        }

        public void calculateBuffer() {
            if (!this.javaSoundInitialized) {
                this.initJavaSound();
            }
            this.targetDataLine.read(this.bbuf, 0, this.bbuf.length);
            AudioUtils.byteToFloat((float[])this.interleavedSamples, (byte[])this.bbuf, (boolean)this.audioFormat.isBigEndian());
            AudioUtils.deinterleave((float[])this.interleavedSamples, (int)this.audioFormat.getChannels(), (int)this.bufferSize, (float[][])this.bufOut);
        }
    }
}

