/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.audiofile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.data.SampleAudioFormat;
import net.beadsproject.beads.data.audiofile.AudioFileReader;
import net.beadsproject.beads.data.audiofile.AudioFileType;
import net.beadsproject.beads.data.audiofile.AudioFileWriter;
import net.beadsproject.beads.data.audiofile.OperationUnsupportedException;
import net.beadsproject.beads.data.audiofile.WavFileReaderWriter;

public class JavaSoundAudioFile
implements AudioFileReader,
AudioFileWriter {
    private File file;
    private URL url;
    private AudioInputStream audioInputStream;
    private String name;
    private boolean finished = false;
    private AudioFormat encodedFormat;
    private AudioFormat decodedFormat;
    private AudioInputStream encodedStream = null;
    private AudioInputStream decodedStream = null;
    private boolean isEncoded = false;
    private SampleAudioFormat audioFormat;
    private float[][] sampleData;
    private WavFileReaderWriter wavBackup = new WavFileReaderWriter();

    public static SampleAudioFormat convertJavasoundAudioFormatToBeadsAudioFormat(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        SampleAudioFormat sampleAudioFormat = new SampleAudioFormat(audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), bl, audioFormat.isBigEndian());
        return sampleAudioFormat;
    }

    public static AudioFormat convertBeadsAudioFormatToJavasoundAudioFormat(SampleAudioFormat sampleAudioFormat) {
        AudioFormat audioFormat = new AudioFormat(sampleAudioFormat.sampleRate, sampleAudioFormat.bitDepth, sampleAudioFormat.channels, sampleAudioFormat.signed, sampleAudioFormat.bigEndian);
        return audioFormat;
    }

    public void writeAudioFile(float[][] fArray, String string, AudioFileType audioFileType, SampleAudioFormat sampleAudioFormat) throws IOException, OperationUnsupportedException {
        if (!this.getSupportedFileTypesForWriting().contains(audioFileType)) {
            throw new OperationUnsupportedException("Unsupported file type for writing: " + audioFileType);
        }
        if (sampleAudioFormat.bitDepth > 16) {
            throw new OperationUnsupportedException("Unsupported bit depth. Javasound cannot write WAV or AIFF files with bit depth > 16.");
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[] fArray2 = new float[n * n2];
        AudioUtils.interleave((float[][])fArray, (int)n, (int)n2, (float[])fArray2);
        byte[] byArray = new byte[n * n2 * sampleAudioFormat.bitDepth / 8];
        AudioUtils.floatToByte((byte[])byArray, (float[])fArray2, (boolean)sampleAudioFormat.bigEndian);
        AudioFormat audioFormat = new AudioFormat(sampleAudioFormat.sampleRate, sampleAudioFormat.bitDepth, sampleAudioFormat.channels, sampleAudioFormat.signed, sampleAudioFormat.bigEndian);
        AudioFileFormat.Type type = AudioFileFormat.Type.WAVE;
        if (audioFileType == AudioFileType.AIFF) {
            type = AudioFileFormat.Type.AIFF;
        }
        AudioSystem.write(new AudioInputStream(new ByteArrayInputStream(byArray), audioFormat, n2), type, new File(string));
    }

    public HashSet<AudioFileType> getSupportedFileTypesForWriting() {
        HashSet<AudioFileType> hashSet = new HashSet<AudioFileType>();
        hashSet.add(AudioFileType.WAV);
        hashSet.add(AudioFileType.AIFF);
        return hashSet;
    }

    public float[][] readAudioFile(String string) throws IOException {
        try {
            this.url = new URL(string);
            this.file = null;
            this.name = this.url.getFile();
        }
        catch (Exception exception) {
            this.file = new File(string);
            this.url = null;
            this.name = this.file.getAbsolutePath();
        }
        this.audioInputStream = null;
        try {
            this.prepareForReading();
            this.readEntireFile();
        }
        catch (Exception exception) {
            throw new IOException("Could not read audio file: " + this.name);
        }
        this.close();
        return this.sampleData;
    }

    public HashSet<AudioFileType> getSupportedFileTypesForReading() {
        HashSet<AudioFileType> hashSet = new HashSet<AudioFileType>();
        hashSet.add(AudioFileType.WAV);
        hashSet.add(AudioFileType.AIFF);
        hashSet.add(AudioFileType.MP3);
        return hashSet;
    }

    private void prepareForReading() throws IOException {
        this.finished = false;
        try {
            this.encodedStream = this.getStream();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException.getMessage());
        }
        this.encodedFormat = this.encodedStream.getFormat();
        int n = 16;
        this.decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.encodedFormat.getSampleRate(), n, this.encodedFormat.getChannels(), this.encodedFormat.getChannels() * (n / 8), 44100.0f, this.encodedFormat.isBigEndian());
        if (AudioSystem.isConversionSupported(this.decodedFormat, this.encodedFormat)) {
            this.isEncoded = true;
            this.decodedStream = AudioSystem.getAudioInputStream(this.decodedFormat, this.encodedStream);
        } else {
            this.isEncoded = false;
            this.decodedFormat = this.encodedFormat;
            this.decodedStream = this.encodedStream;
            if (this.decodedFormat.getFrameSize() != 2 * this.decodedFormat.getChannels()) {
                this.close();
                String string = "Tried to load " + 8 * this.decodedFormat.getFrameSize() / this.decodedFormat.getChannels() + "-bit file, but couldn't convert to 16-bit.";
                throw new IOException(string);
            }
        }
        this.audioFormat = JavaSoundAudioFile.convertJavasoundAudioFormatToBeadsAudioFormat(this.decodedFormat);
    }

    private void readEntireFile() throws IOException {
        byte[] byArray;
        int n;
        byte[] byArray2 = new byte[4096];
        int n2 = 4096;
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        while ((n = this.read(byArray2)) != -1) {
            if (n > n2 - n3) {
                n2 = Math.max(n2 * 2, n2 + n);
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                byArray3 = byArray;
            }
            System.arraycopy(byArray2, 0, byArray3, n3, n);
            n3 += n;
        }
        if (n2 > n3) {
            n2 = n3;
            byArray = new byte[n2];
            System.arraycopy(byArray3, 0, byArray, 0, n2);
            byArray3 = byArray;
        }
        int n4 = n2 / (2 * this.audioFormat.channels);
        this.sampleData = new float[this.audioFormat.channels][n4];
        float[] fArray = new float[this.audioFormat.channels * n4];
        AudioUtils.byteToFloat((float[])fArray, (byte[])byArray3, (boolean)this.audioFormat.bigEndian);
        AudioUtils.deinterleave((float[])fArray, (int)this.audioFormat.channels, (int)n4, (float[][])this.sampleData);
    }

    private int read(byte[] byArray) {
        if (this.finished) {
            return -1;
        }
        int n = -1;
        try {
            int n2;
            for (n2 = 0; n2 < byArray.length; n2 += n) {
                n = this.decodedStream.read(byArray, n2, byArray.length - n2);
                if (n != -1) continue;
                this.finished = true;
                if (n2 <= 0) break;
                n = n2;
                break;
            }
            if (n2 == byArray.length) {
                n = n2;
            }
        }
        catch (IOException iOException) {
            this.finished = true;
        }
        if (this.finished || n == -1) {
            this.finished = true;
            return n;
        }
        return n;
    }

    private AudioInputStream getStream() throws UnsupportedAudioFileException, IOException {
        if (this.file != null) {
            return AudioSystem.getAudioInputStream(this.file);
        }
        if (this.url != null) {
            return AudioSystem.getAudioInputStream(this.url);
        }
        return this.audioInputStream;
    }

    private void close() throws IOException {
        if (this.isEncoded) {
            this.decodedStream.close();
        }
        if (this.encodedStream != null) {
            this.encodedStream.close();
            this.encodedStream = null;
        }
        this.decodedStream = null;
    }

    public SampleAudioFormat getSampleAudioFormat() {
        return this.audioFormat;
    }
}

