/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.core.UGen;
import org.tritonus.share.sampled.AudioSystemShadow;
import org.tritonus.share.sampled.file.AudioOutputStream;

public class RecordToFile
extends UGen {
    private static final boolean DEBUG = false;
    private AudioOutputStream audioOutputStream;
    private AudioFormat audioFormat;

    public RecordToFile(AudioContext audioContext, int n, File file, AudioFileFormat.Type type) throws IOException {
        super(audioContext, n, 0);
        if (type != AudioFileFormat.Type.WAVE) {
            System.out.printf("RecordToFile: AudioFileFormat.%s is unsupported. (Only WAVE is currently supported.) \nBeads will continue to use the type specified but it may not output sensible audio data.\n", type.toString());
        }
        this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioContext.getSampleRate(), 16, this.getIns(), 2 * this.getIns(), audioContext.getSampleRate(), false);
        this.audioOutputStream = AudioSystemShadow.getAudioOutputStream((AudioFileFormat.Type)type, (AudioFormat)this.audioFormat, (long)-1L, (File)file);
    }

    public RecordToFile(AudioContext audioContext, int n, File file) throws IOException {
        this(audioContext, n, file, AudioFileFormat.Type.WAVE);
    }

    public void calculateBuffer() {
        int n = this.bufIn[0].length;
        byte[] byArray = new byte[this.getIns() * n * 2];
        if (this.getIns() > 1) {
            float[] fArray = new float[this.getIns() * n];
            AudioUtils.interleave((float[][])this.bufIn, (int)this.getIns(), (int)n, (int)0, (float[])fArray);
            AudioUtils.floatToByte((byte[])byArray, (float[])fArray, (boolean)false);
        } else {
            AudioUtils.floatToByte((byte[])byArray, (float[])this.bufIn[0], (boolean)false);
        }
        try {
            int n2 = this.audioOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void kill() {
        super.kill();
        try {
            this.audioOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

