/*
 * Decompiled with CFR 0.152.
 */
package jode.type;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import jode.AssertError;
import jode.bytecode.ClassInfo;
import jode.type.ArrayType;
import jode.type.RangeType;
import jode.type.ReferenceType;
import jode.type.Type;

public class ClassInterfacesType
extends ReferenceType {
    private static final Hashtable keywords = new Hashtable();
    ClassInfo clazz;
    ClassInfo[] ifaces;

    public ClassInfo getClazz() {
        return this.clazz != null ? this.clazz : ClassInfo.javaLangObject;
    }

    static ClassInterfacesType create(ClassInfo classInfo, ClassInfo[] classInfoArray) {
        if (classInfoArray.length == 0 && classInfo == null) {
            return Type.tObject;
        }
        if (classInfoArray.length == 0) {
            return Type.tClass(classInfo);
        }
        if (classInfoArray.length == 1 && classInfo == null) {
            return Type.tClass(classInfoArray[0]);
        }
        return new ClassInterfacesType(classInfo, classInfoArray);
    }

    public Type getSubType() {
        if (this.clazz == null && this.ifaces.length == 1 || this.ifaces.length == 0) {
            return Type.tRange(this, Type.tNull);
        }
        throw new AssertError("getSubType called on set of classes and interfaces!");
    }

    public Type getHint() {
        if (this.ifaces.length == 0 || this.clazz == null && this.ifaces.length == 1) {
            return this;
        }
        if (this.clazz != null) {
            return Type.tClass(this.clazz.getName());
        }
        return Type.tClass(this.ifaces[0].getName());
    }

    public Type getCanonic() {
        if (this.ifaces.length == 0 || this.clazz == null && this.ifaces.length == 1) {
            return this;
        }
        if (this.clazz != null) {
            return Type.tClass(this.clazz.getName());
        }
        return Type.tClass(this.ifaces[0].getName());
    }

    public Type createRangeType(ReferenceType referenceType) {
        int n;
        if (referenceType.typecode != 10) {
            return Type.tError;
        }
        ClassInterfacesType classInterfacesType = (ClassInterfacesType)referenceType;
        if (referenceType == Type.tObject) {
            return this == Type.tObject ? Type.tObject : Type.tRange(Type.tObject, this);
        }
        if (classInterfacesType.clazz != null) {
            if (!classInterfacesType.clazz.superClassOf(this.clazz)) {
                return Type.tError;
            }
            int n2 = 0;
            while (n2 < classInterfacesType.ifaces.length) {
                if (!classInterfacesType.ifaces[n2].implementedBy(this.clazz)) {
                    return Type.tError;
                }
                ++n2;
            }
            if (classInterfacesType.clazz == this.clazz && classInterfacesType.ifaces.length == 0) {
                return classInterfacesType;
            }
            if (this.ifaces.length != 0) {
                return Type.tRange(classInterfacesType, ClassInterfacesType.create(this.clazz, new ClassInfo[0]));
            }
            return Type.tRange(classInterfacesType, this);
        }
        ClassInfo classInfo = this.clazz;
        if (classInfo != null) {
            n = 0;
            while (n < classInterfacesType.ifaces.length) {
                if (!classInterfacesType.ifaces[n].implementedBy(classInfo)) {
                    classInfo = null;
                    break;
                }
                ++n;
            }
        }
        if (classInfo == null && classInterfacesType.ifaces.length == 1) {
            n = 0;
            while (n < this.ifaces.length) {
                if (this.ifaces[n] == classInterfacesType.ifaces[0]) {
                    return classInterfacesType;
                }
                ++n;
            }
        }
        ClassInfo[] classInfoArray = new ClassInfo[this.ifaces.length];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.ifaces.length) {
            block21: {
                int n5 = 0;
                while (n5 < classInterfacesType.ifaces.length) {
                    if (classInterfacesType.ifaces[n5].implementedBy(this.ifaces[n4])) {
                        ++n5;
                        continue;
                    }
                    break block21;
                }
                classInfoArray[n3++] = this.ifaces[n4];
            }
            ++n4;
        }
        if (classInfo == null && n3 == 0) {
            return Type.tError;
        }
        if (n3 < classInfoArray.length) {
            ClassInfo[] classInfoArray2 = new ClassInfo[n3];
            System.arraycopy(classInfoArray, 0, classInfoArray2, 0, n3);
            classInfoArray = classInfoArray2;
        } else if (classInfo == this.clazz) {
            return Type.tRange(classInterfacesType, this);
        }
        return Type.tRange(classInterfacesType, ClassInterfacesType.create(classInfo, classInfoArray));
    }

    public Type getSpecializedType(Type type) {
        int n;
        ClassInfo classInfo;
        ClassInfo classInfo2;
        int n2 = type.typecode;
        if (n2 == 103) {
            type = ((RangeType)type).getBottom();
            n2 = type.typecode;
        }
        if (n2 == 8) {
            return this;
        }
        if (n2 == 9) {
            return ((ArrayType)type).getSpecializedType(this);
        }
        if (n2 != 10) {
            return Type.tError;
        }
        ClassInterfacesType classInterfacesType = (ClassInterfacesType)type;
        if (this.clazz == null) {
            classInfo2 = classInterfacesType.clazz;
        } else if (classInterfacesType.clazz == null) {
            classInfo2 = this.clazz;
        } else if (this.clazz.superClassOf(classInterfacesType.clazz)) {
            classInfo2 = classInterfacesType.clazz;
        } else if (classInterfacesType.clazz.superClassOf(this.clazz)) {
            classInfo2 = this.clazz;
        } else {
            return Type.tError;
        }
        if (classInfo2 == this.clazz && ReferenceType.implementsAllIfaces(this.clazz, this.ifaces, classInterfacesType.ifaces)) {
            return this;
        }
        if (classInfo2 == classInterfacesType.clazz && ReferenceType.implementsAllIfaces(classInterfacesType.clazz, classInterfacesType.ifaces, this.ifaces)) {
            return classInterfacesType;
        }
        Vector<ClassInfo> vector = new Vector<ClassInfo>();
        int n3 = 0;
        while (n3 < this.ifaces.length) {
            block22: {
                classInfo = this.ifaces[n3];
                if (classInfo2 == null || !classInfo.implementedBy(classInfo2)) {
                    n = 0;
                    while (n < classInterfacesType.ifaces.length) {
                        if (!classInfo.implementedBy(classInterfacesType.ifaces[n])) {
                            ++n;
                            continue;
                        }
                        break block22;
                    }
                    vector.addElement(classInfo);
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < classInterfacesType.ifaces.length) {
            block23: {
                classInfo = classInterfacesType.ifaces[n3];
                if (classInfo2 == null || !classInfo.implementedBy(classInfo2)) {
                    n = 0;
                    while (n < vector.size()) {
                        if (!classInfo.implementedBy((ClassInfo)vector.elementAt(n))) {
                            ++n;
                            continue;
                        }
                        break block23;
                    }
                    vector.addElement(classInfo);
                }
            }
            ++n3;
        }
        Object[] objectArray = new ClassInfo[vector.size()];
        vector.copyInto(objectArray);
        return ClassInterfacesType.create(classInfo2, (ClassInfo[])objectArray);
    }

    public Type getGeneralizedType(Type type) {
        Object object;
        ClassInfo classInfo;
        int n = type.typecode;
        if (n == 103) {
            type = ((RangeType)type).getTop();
            n = type.typecode;
        }
        if (n == 8) {
            return this;
        }
        if (n == 9) {
            return ((ArrayType)type).getGeneralizedType(this);
        }
        if (n != 10) {
            return Type.tError;
        }
        ClassInterfacesType classInterfacesType = (ClassInterfacesType)type;
        if (this.clazz == null || classInterfacesType.clazz == null) {
            classInfo = null;
        } else {
            classInfo = this.clazz;
            while (classInfo != null) {
                if (classInfo.superClassOf(classInterfacesType.clazz)) break;
                classInfo = classInfo.getSuperclass();
            }
            if (classInfo == ClassInfo.javaLangObject) {
                classInfo = null;
            }
        }
        if (classInfo == this.clazz && ReferenceType.implementsAllIfaces(classInterfacesType.clazz, classInterfacesType.ifaces, this.ifaces)) {
            return this;
        }
        if (classInfo == classInterfacesType.clazz && ReferenceType.implementsAllIfaces(this.clazz, this.ifaces, classInterfacesType.ifaces)) {
            return classInterfacesType;
        }
        Stack<ClassInfo> stack = new Stack<ClassInfo>();
        if (this.clazz != null) {
            object = this.clazz;
            while (classInfo != object) {
                ClassInfo[] classInfoArray = ((ClassInfo)object).getInterfaces();
                int n2 = 0;
                while (n2 < classInfoArray.length) {
                    stack.push(classInfoArray[n2]);
                    ++n2;
                }
                object = ((ClassInfo)object).getSuperclass();
            }
        }
        object = new Vector();
        int n3 = 0;
        while (n3 < this.ifaces.length) {
            stack.push(this.ifaces[n3]);
            ++n3;
        }
        block4: while (!stack.isEmpty()) {
            ClassInfo classInfo2 = (ClassInfo)stack.pop();
            if (classInfo != null && classInfo2.implementedBy(classInfo) || ((Vector)object).contains(classInfo2)) continue;
            if (classInterfacesType.clazz != null && classInfo2.implementedBy(classInterfacesType.clazz)) {
                ((Vector)object).addElement(classInfo2);
                continue;
            }
            int n4 = 0;
            while (n4 < classInterfacesType.ifaces.length) {
                if (classInfo2.implementedBy(classInterfacesType.ifaces[n4])) {
                    ((Vector)object).addElement(classInfo2);
                    continue block4;
                }
                ++n4;
            }
            ClassInfo[] classInfoArray = classInfo2.getInterfaces();
            int n5 = 0;
            while (n5 < classInfoArray.length) {
                stack.push(classInfoArray[n5]);
                ++n5;
            }
        }
        Object[] objectArray = new ClassInfo[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return ClassInterfacesType.create(classInfo, (ClassInfo[])objectArray);
    }

    public String getTypeSignature() {
        if (this.clazz != null) {
            return "L" + this.clazz.getName().replace('.', '/') + ";";
        }
        if (this.ifaces.length > 0) {
            return "L" + this.ifaces[0].getName().replace('.', '/') + ";";
        }
        return "Ljava/lang/Object;";
    }

    public Class getTypeClass() throws ClassNotFoundException {
        if (this.clazz != null) {
            return Class.forName(this.clazz.getName());
        }
        if (this.ifaces.length > 0) {
            return Class.forName(this.ifaces[0].getName());
        }
        return Class.forName("java.lang.Object");
    }

    public ClassInfo getClassInfo() {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.ifaces.length > 0) {
            return this.ifaces[0];
        }
        return ClassInfo.javaLangObject;
    }

    public String toString() {
        if (this == Type.tObject) {
            return "java.lang.Object";
        }
        if (this.ifaces.length == 0) {
            return this.clazz.getName();
        }
        if (this.clazz == null && this.ifaces.length == 1) {
            return this.ifaces[0].getName();
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        String string = "";
        if (this.clazz != null) {
            stringBuffer = stringBuffer.append(this.clazz.getName());
            string = ", ";
        }
        int n = 0;
        while (n < this.ifaces.length) {
            stringBuffer.append(string).append(this.ifaces[n].getName());
            string = ", ";
            ++n;
        }
        return stringBuffer.append("}").toString();
    }

    public Type getCastHelper(Type type) {
        Type type2 = type.getHint();
        switch (type2.getTypeCode()) {
            case 9: {
                if (this.clazz == null && ReferenceType.implementsAllIfaces(null, ArrayType.arrayIfaces, this.ifaces)) {
                    return null;
                }
                return Type.tObject;
            }
            case 10: {
                ClassInterfacesType classInterfacesType = (ClassInterfacesType)type2;
                if (classInterfacesType.clazz == null || this.clazz == null || this.clazz.superClassOf(classInterfacesType.clazz) || classInterfacesType.clazz.superClassOf(this.clazz)) {
                    return null;
                }
                ClassInfo classInfo = this.clazz.getSuperclass();
                while (classInfo != null && !classInfo.superClassOf(classInterfacesType.clazz)) {
                    classInfo = classInfo.getSuperclass();
                }
                return Type.tClass(classInfo.getName());
            }
            case 101: {
                return null;
            }
        }
        return Type.tObject;
    }

    public boolean isValidType() {
        return this.ifaces.length == 0 || this.clazz == null && this.ifaces.length == 1;
    }

    public boolean isClassType() {
        return true;
    }

    public String getDefaultName() {
        ClassInfo classInfo = this.clazz != null ? this.clazz : (this.ifaces.length > 0 ? this.ifaces[0] : ClassInfo.javaLangObject);
        String string = classInfo.getName();
        int n = Math.max(string.lastIndexOf(46), string.lastIndexOf(36));
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if (Character.isUpperCase(string.charAt(0))) {
            if (keywords.get(string = string.toLowerCase()) != null) {
                return "var_" + string;
            }
            return string;
        }
        return "var_" + string;
    }

    public int hashCode() {
        int n = this.clazz == null ? 0 : this.clazz.hashCode();
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            n ^= this.ifaces[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Type && ((Type)object).typecode == 10) {
            ClassInterfacesType classInterfacesType = (ClassInterfacesType)object;
            if (classInterfacesType.clazz == this.clazz && classInterfacesType.ifaces.length == this.ifaces.length) {
                int n = 0;
                while (n < classInterfacesType.ifaces.length) {
                    block6: {
                        int n2 = 0;
                        while (n2 < this.ifaces.length) {
                            if (classInterfacesType.ifaces[n] != this.ifaces[n2]) {
                                ++n2;
                                continue;
                            }
                            break block6;
                        }
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public ClassInterfacesType(String string) {
        super(10);
        ClassInfo classInfo = ClassInfo.forName(string);
        if (classInfo.isInterface()) {
            this.clazz = null;
            this.ifaces = new ClassInfo[]{classInfo};
        } else {
            this.clazz = classInfo == ClassInfo.javaLangObject ? null : classInfo;
            this.ifaces = new ClassInfo[0];
        }
    }

    public ClassInterfacesType(ClassInfo classInfo) {
        super(10);
        if (classInfo.isInterface()) {
            this.clazz = null;
            this.ifaces = new ClassInfo[]{classInfo};
        } else {
            this.clazz = classInfo == ClassInfo.javaLangObject ? null : classInfo;
            this.ifaces = new ClassInfo[0];
        }
    }

    public ClassInterfacesType(ClassInfo classInfo, ClassInfo[] classInfoArray) {
        super(10);
        this.clazz = classInfo;
        this.ifaces = classInfoArray;
    }

    static {
        keywords.put("abstract", Boolean.TRUE);
        keywords.put("default", Boolean.TRUE);
        keywords.put("if", Boolean.TRUE);
        keywords.put("private", Boolean.TRUE);
        keywords.put("throw", Boolean.TRUE);
        keywords.put("boolean", Boolean.TRUE);
        keywords.put("do", Boolean.TRUE);
        keywords.put("implements", Boolean.TRUE);
        keywords.put("protected", Boolean.TRUE);
        keywords.put("throws", Boolean.TRUE);
        keywords.put("break", Boolean.TRUE);
        keywords.put("double", Boolean.TRUE);
        keywords.put("import", Boolean.TRUE);
        keywords.put("public", Boolean.TRUE);
        keywords.put("transient", Boolean.TRUE);
        keywords.put("byte", Boolean.TRUE);
        keywords.put("else", Boolean.TRUE);
        keywords.put("instanceof", Boolean.TRUE);
        keywords.put("return", Boolean.TRUE);
        keywords.put("try", Boolean.TRUE);
        keywords.put("case", Boolean.TRUE);
        keywords.put("extends", Boolean.TRUE);
        keywords.put("int", Boolean.TRUE);
        keywords.put("short", Boolean.TRUE);
        keywords.put("void", Boolean.TRUE);
        keywords.put("catch", Boolean.TRUE);
        keywords.put("final", Boolean.TRUE);
        keywords.put("interface", Boolean.TRUE);
        keywords.put("static", Boolean.TRUE);
        keywords.put("volatile", Boolean.TRUE);
        keywords.put("char", Boolean.TRUE);
        keywords.put("finally", Boolean.TRUE);
        keywords.put("long", Boolean.TRUE);
        keywords.put("super", Boolean.TRUE);
        keywords.put("while", Boolean.TRUE);
        keywords.put("class", Boolean.TRUE);
        keywords.put("float", Boolean.TRUE);
        keywords.put("native", Boolean.TRUE);
        keywords.put("switch", Boolean.TRUE);
        keywords.put("const", Boolean.TRUE);
        keywords.put("for", Boolean.TRUE);
        keywords.put("new", Boolean.TRUE);
        keywords.put("synchronized", Boolean.TRUE);
        keywords.put("continue", Boolean.TRUE);
        keywords.put("goto", Boolean.TRUE);
        keywords.put("package", Boolean.TRUE);
        keywords.put("this", Boolean.TRUE);
        keywords.put("strictfp", Boolean.TRUE);
        keywords.put("null", Boolean.TRUE);
        keywords.put("true", Boolean.TRUE);
        keywords.put("false", Boolean.TRUE);
    }
}

