/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.jsyn2.unitvoices;

import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.instruments.WaveShapingVoice;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.InterpolatingDelay;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.JMSLPlugin;
import com.softsynth.jmsl.jsyn2.JSynMusicDevice;
import com.softsynth.shared.time.TimeStamp;

public class SimpleDelay
extends Circuit
implements UnitVoice,
UnitSink,
JMSLPlugin {
    private VariableRateMonoReader a;
    private InterpolatingDelay b = new InterpolatingDelay();
    private Multiply c;
    private SegmentedEnvelope d;
    public UnitInputPort delay;
    public UnitInputPort amplitude;

    public SimpleDelay() {
        this.add((UnitGenerator)this.b);
        this.b.allocate(22050);
        this.b.delay.set(0.3);
        this.c = new Multiply();
        this.add((UnitGenerator)this.c);
        this.a = new VariableRateMonoReader();
        this.add((UnitGenerator)this.a);
        this.a.output.connect(this.c.inputB);
        this.c.output.connect(this.b.input);
        double[] dArray = new double[]{0.01, 1.0, 0.01, 0.0};
        this.d = new SegmentedEnvelope(dArray);
        this.delay = this.b.delay;
        this.addPort((UnitPort)this.delay);
        this.delay.setup(0.0, 0.2, 0.5);
        this.amplitude = this.a.amplitude;
        this.addPort((UnitPort)this.amplitude);
    }

    public UnitInputPort getInput() {
        return this.c.inputA;
    }

    public UnitOutputPort getOutput() {
        return this.b.output;
    }

    public void noteOn(double d2, double d3, TimeStamp timeStamp) {
        this.a.dataQueue.queue((SequentialData)this.d, 0, 1, timeStamp);
    }

    public void noteOff(TimeStamp timeStamp) {
        this.a.dataQueue.queue((SequentialData)this.d, 1, 1, timeStamp);
    }

    public static void main(String[] stringArray) {
        JSynMusicDevice jSynMusicDevice = JSynMusicDevice.instance();
        jSynMusicDevice.open();
        LineOut lineOut = new LineOut();
        jSynMusicDevice.add((UnitGenerator)lineOut);
        lineOut.start();
        WaveShapingVoice waveShapingVoice = new WaveShapingVoice();
        jSynMusicDevice.add((UnitGenerator)waveShapingVoice);
        SimpleDelay simpleDelay = new SimpleDelay();
        jSynMusicDevice.add((UnitGenerator)simpleDelay);
        waveShapingVoice.getOutput().connect(0, lineOut.input, 0);
        waveShapingVoice.getOutput().connect(0, simpleDelay.getInput(), 0);
        simpleDelay.getOutput().connect(0, lineOut.input, 1);
        double d2 = JMSL.realTime();
        double d3 = jSynMusicDevice.jmslTimeToJSynTime(d2);
        TimeStamp timeStamp = new TimeStamp(d3 + 2.0);
        TimeStamp timeStamp2 = new TimeStamp(d3 + 2.25);
        TimeStamp timeStamp3 = new TimeStamp(d3 + 3.0);
        waveShapingVoice.noteOn(880.0, 0.2, timeStamp);
        waveShapingVoice.noteOff(timeStamp3);
        double d4 = 0.0;
        simpleDelay.noteOn(d4, 0.2, timeStamp);
        simpleDelay.noteOff(timeStamp2);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        JMSL.closeMusicDevices();
        System.exit(0);
    }
}

