/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.util;

public abstract class Tuning {
    private double a = 2.0;
    private double b = 0.0;
    private double c = 8.175;
    private int d = 0;

    public abstract double getFrequency(double var1, int var3);

    public abstract double getFrequency(double var1);

    public static double freqPlusCents(double d2, double d3) {
        return d2 * Math.pow(2.0, d3 / 1200.0);
    }

    public void setOctaveStretchCents(int n2) {
        this.d = n2;
    }

    public int getOctaveStretchCents() {
        return this.d;
    }

    public abstract double getStepsPerOctave();

    public void setOctaveRatio(double d2) {
        this.a = d2;
    }

    public double getOctaveRatio() {
        return this.a;
    }

    public double getReferencePitch() {
        return this.b;
    }

    public void setReferencePitch(double d2) {
        this.b = d2;
    }

    public double getReferenceFrequency() {
        return this.c;
    }

    public void setReferenceFrequency(double d2) {
        this.c = d2;
    }

    public double stretch(double d2, double d3) {
        double d4 = d2 - this.getReferencePitch();
        double d5 = Tuning.freqPlusCents(d3, d4 * (double)this.getOctaveStretchCents() / this.getStepsPerOctave());
        return d5;
    }

    public static void main(String[] stringArray) {
        System.out.println(Tuning.freqPlusCents(440.0, 1.0));
        System.out.println(Tuning.freqPlusCents(880.0, 2.0));
    }
}

