/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.JMSLPlugin;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Track;
import java.util.Enumeration;

public class ExtremeLevelReporter
implements ScoreOperator,
JMSLPlugin {
    private static final int MAX_ACCEPTABLE_LEVEL = 142;
    private static final int MIN_ACCEPTABLE_LEVEL = 114;
    private StringBuffer buf;

    public String getName() {
        return "Check for notes with 5 ledger lines or more";
    }

    public void operate(Score score) {
        System.out.println("ExtremeLevelReporter operator by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        this.buf = new StringBuffer();
        this.buf.append("The following staves have notes more than 5 ledger lines away from the staff. ");
        this.buf.append("You might consider using 8va or 8vb for these notes.\n");
        boolean reportContainsStuff = false;
        int i = 0;
        while (i < score.size()) {
            Measure m = score.getMeasure(i);
            Enumeration e = m.elements();
            while (e.hasMoreElements()) {
                Staff staff = (Staff)e.nextElement();
                Enumeration t = staff.elements();
                while (t.hasMoreElements()) {
                    Track track = (Track)t.nextElement();
                    boolean containsExtremeLevels = this.checkForExtremeLevels(track);
                    if (!containsExtremeLevels) continue;
                    reportContainsStuff = true;
                    this.buf.append("Measure " + (m.getMeasureIndex() + 1) + ", staff " + (track.getStaff().getStaffIndex() + 1) + "\n");
                }
            }
            ++i;
        }
        if (!reportContainsStuff) {
            this.buf.append("No Measures contain notes with extreme levels");
        }
    }

    private boolean checkForExtremeLevels(Track track) {
        boolean extremeLevelFlag = false;
        if (track.size() == 0) {
            return false;
        }
        Enumeration e = track.elements();
        while (e.hasMoreElements()) {
            int level;
            Note n = (Note)e.nextElement();
            if (n.isRest() || (level = n.getLevel()) <= 142 && level >= 114) continue;
            extremeLevelFlag = true;
            break;
        }
        return extremeLevelFlag;
    }

    public String getResultString() {
        return this.buf.toString();
    }
}

