/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.JMSLPlugin;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.NoteFactory;
import com.softsynth.jmsl.score.NotePropertiesTransform;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.SelectionBuffer;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.view.Alert;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class SwitchTracksTransform
extends NotePropertiesTransform
implements JMSLPlugin {
    public SwitchTracksTransform() {
        this.setName("SwitchTracks");
    }

    public void operate(Score score, SelectionBuffer selectionBuffer) {
        int destinationTrackIndex;
        System.out.println("SwitchTracksTransform moves notes from one Track to the other, by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        int origTrackIndex = -1;
        Vector<Track> originalTracks = new Vector<Track>();
        boolean continueWithTransform = true;
        Enumeration e = selectionBuffer.elements();
        while (e.hasMoreElements()) {
            Note n = (Note)e.nextElement();
            if (origTrackIndex == -1) {
                origTrackIndex = n.getTrack().getTrackIndex();
            }
            if (origTrackIndex != n.getTrack().getTrackIndex()) {
                continueWithTransform = false;
                new Alert().alert("Problem with selection", "All selected Notes must be in same Track");
            }
            if (originalTracks.contains(n.getTrack())) continue;
            originalTracks.addElement(n.getTrack());
        }
        int n = destinationTrackIndex = origTrackIndex == 0 ? 1 : 0;
        if (continueWithTransform) {
            Note n2;
            Vector<Note> intervalsStorage = new Vector<Note>();
            Enumeration e2 = selectionBuffer.elements();
            while (e2.hasMoreElements()) {
                n2 = (Note)e2.nextElement();
                System.out.println("switching tracks on note " + n2.getPitchData() + ", chord? " + n2.isChord() + ", interval? " + n2.isInterval());
                if (!n2.isInterval()) continue;
                intervalsStorage.addElement(n2);
            }
            e2 = selectionBuffer.elements();
            while (e2.hasMoreElements()) {
                n2 = (Note)e2.nextElement();
                Track sourceTrack = n2.getTrack();
                Track destTrack = n2.getTrack().getStaff().getTrack(destinationTrackIndex);
                boolean isInterval = intervalsStorage.contains(n2);
                System.out.println("second pass, switching tracks on note " + n2.getPitchData() + ", chord? " + n2.isChord() + ", interval? " + isInterval);
                if (isInterval) continue;
                destTrack.insertNote(n2, destTrack.size());
                System.out.println("Inserting note " + n2.getPitchData());
                if (!n2.isChord()) continue;
                System.out.println("n.getIntervals().size()=" + n2.getIntervals().size());
                Enumeration intervEnum = n2.getIntervals().elements();
                while (intervEnum.hasMoreElements()) {
                    Note interval = (Note)intervEnum.nextElement();
                    System.out.println("interval=" + interval.getPitchData());
                    interval.setTrack(destTrack);
                }
            }
            e2 = originalTracks.elements();
            while (e2.hasMoreElements()) {
                Track t = (Track)e2.nextElement();
                System.out.println("deleting notes from track " + t.getTrackIndex());
                t.removeAll();
                double[] data = new double[]{4.0, 0.0, 0.0, 0.0};
                Note rest = NoteFactory.makeNote((double[])data);
                t.insertNote(rest, 0);
            }
        }
    }

    public static void main(String[] args) {
        Score score = new Score(1, 800, 600);
        score.addMeasure();
        ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addScore(score);
        scoreFrame.addNotePropertiesTransform((NotePropertiesTransform)new SwitchTracksTransform());
        scoreFrame.pack();
        scoreFrame.setVisible(true);
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                System.exit(0);
            }
        });
    }
}

