/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.didkovsky.portview.ViewFactory;
import com.didkovsky.portview.swing.ViewFactorySwing;
import com.punosmusic.jmsl.plugins.TranscribingUnaryTransform;
import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.MusicShape;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.ScoreOperator;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class TranscribingBinaryTransform
extends TranscribingUnaryTransform {
    public String getName() {
        return "TranscribingBinaryTransform";
    }

    protected void binaryMusicShapeOperation(MusicShape musicShape1, MusicShape musicShape2) {
        MusicShape s = null;
        s = this.compatibleDimensionNameSpaces(musicShape1, musicShape2) ? new MusicShape((DimensionNameSpace)musicShape1) : new MusicShape(4);
        int i = 0;
        while (i < Math.min(musicShape1.size(), musicShape2.size())) {
            double[] data = new double[s.dimension()];
            int d = 0;
            while (d < s.dimension()) {
                double result;
                double d1 = musicShape1.get(i, d);
                double d2 = musicShape2.get(i, d);
                data[d] = result = (d1 + d2) / 2.0;
                ++d;
            }
            s.add(data);
            ++i;
        }
        this.transcribeMusicShape(this.getScore(), s);
    }

    public void operate(Score score) {
        System.out.println("TranscribingBinaryTransform by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        this.setScore(score);
        this.setMessage(null);
        if (score.getSelectedMeasure() == null || score.getSelectedStaff() == null) {
            this.setMessage("You must click in an empty measure and staff to select a destination for this operator.");
            return;
        }
        System.out.println("TranscribingBinaryTransform, selected measure: " + score.getSelectedMeasure().getMeasureIndex());
        System.out.println("TranscribingBinaryTransform, selected staff: " + score.getSelectedStaff().getStaffIndex());
        if (score.getSelectedStaff().getTrack(0).size() != 0) {
            this.setMessage("Please select an EMPTY destination staff");
            return;
        }
        MusicShape musicShape1 = this.copyBufferToMusicShape(Score.auxCopyBuffer1);
        MusicShape musicShape2 = this.copyBufferToMusicShape(Score.auxCopyBuffer2);
        if (musicShape1 != null && musicShape2 != null) {
            this.binaryMusicShapeOperation(musicShape1, musicShape2);
        }
    }

    protected boolean compatibleDimensionNameSpaces(MusicShape musicShape1, MusicShape musicShape2) {
        if (musicShape1.dimension() != musicShape2.dimension()) {
            return false;
        }
        boolean flag = true;
        int i = 0;
        while (i < musicShape1.dimension()) {
            String dimName2;
            String dimName1 = musicShape1.getDimensionName(i);
            if (!dimName1.equalsIgnoreCase(dimName2 = musicShape2.getDimensionName(i))) {
                flag = false;
                break;
            }
            ++i;
        }
        return flag;
    }

    public static void main(String[] args) {
        JMSL.setViewFactory((ViewFactory)new ViewFactorySwing());
        Score score = new Score(2, 800, 600);
        score.addMeasure(4, 4);
        score.addMeasure(5, 4);
        score.addMeasure(3, 4);
        final ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addScoreOperator((ScoreOperator)new TranscribingBinaryTransform());
        scoreFrame.addScore(score);
        scoreFrame.setSize(900, 700);
        scoreFrame.setVisible(true);
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JMSL.closeMusicDevices();
                scoreFrame.quit();
            }
        });
    }
}

