/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score.util;

import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentAdapter;
import com.softsynth.jmsl.JMSLRandom;
import com.softsynth.jmsl.score.Clef;
import com.softsynth.jmsl.score.KeySignature;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.NoteNamer;
import com.softsynth.jmsl.score.Orchestra;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Tempo;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.score.operators.DurationReporter;
import com.softsynth.jmsl.score.operators.UnbalancedRepeatsReporter;
import com.softsynth.jmsl.score.util.AutoBeamer;
import com.softsynth.jmsl.util.JMSLMath;
import com.softsynth.jmsl.util.TimeSignature;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LilyPondWriter {
    public static final String LY_VERSION;
    private String a;
    private String b;
    private Score c;
    private PrintWriter d;
    private TimeSignature e;
    private KeySignature[] f;
    private Clef g;
    private int h;
    private Tempo i;
    private String j;
    private boolean k;
    private boolean l;
    private boolean m;
    private boolean n;
    private int o;
    private boolean p;
    private boolean q;
    private Vector r;
    private File s;
    private String t;
    private String u;
    private boolean v;
    private Vector w;
    private static final String[] x;
    private String[] y;
    private boolean z;
    Color A;
    static String B;
    private static String[] C;

    public LilyPondWriter(Score score, File file) throws IOException {
        boolean bl = AutoBeamer.c;
        this.a = C[233];
        this.b = null;
        this.e = null;
        this.g = null;
        this.h = 0;
        this.i = null;
        this.j = "";
        this.k = true;
        this.l = false;
        this.m = false;
        this.n = false;
        this.o = 0;
        this.p = false;
        this.q = false;
        this.v = false;
        this.w = new Vector();
        this.y = new String[]{C[234], C[235], C[240], C[236], C[238], C[239], C[231], C[241], C[230], C[232]};
        this.z = false;
        this.A = null;
        this.c = score;
        this.s = file;
        this.a = file.getName();
        if (this.a(this.a)) {
            throw new IOException(C[237] + this.a + "\"");
        }
        this.a();
        this.b();
        if (this.a.indexOf(".") != -1) {
            this.a = this.a.substring(0, this.a.indexOf("."));
        }
        this.b = file.getParentFile().getAbsolutePath();
        this.f = new KeySignature[score.getNumStaves()];
        if (bl) {
            int n2 = Note.D;
            Note.D = ++n2;
        }
    }

    private void a() {
        DurationReporter durationReporter = new DurationReporter();
        durationReporter.operate(this.c);
        this.t = durationReporter.getResultString();
        if (this.durationErrorsInScore()) {
            this.t = C[109] + this.c.getName() + C[143] + C[142] + this.t;
        }
    }

    private void b() {
        UnbalancedRepeatsReporter unbalancedRepeatsReporter = new UnbalancedRepeatsReporter();
        unbalancedRepeatsReporter.operate(this.c);
        this.u = unbalancedRepeatsReporter.getResultString();
        if (this.unbalancedRepeatsErrorsInScore()) {
            this.u = C[109] + this.c.getName() + C[107] + C[108] + this.u;
        }
    }

    private boolean a(String string) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < x.length; ++i2) {
            if (this.a.indexOf(x[i2]) == -1) continue;
            bl2 = false;
            if (!bl) break;
            if (!bl) continue;
        }
        return !bl2;
    }

    boolean a(Note note) {
        return note.getText() != null && note.getText().length() > 0;
    }

    boolean a(int n2) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            Measure measure = this.c.getMeasure(i2);
            Staff staff = measure.getStaff(n2);
            block1: for (int i3 = 0; i3 < staff.size(); ++i3) {
                Track track = staff.getTrack(i3);
                Enumeration enumeration = track.elements();
                while (enumeration.hasMoreElements()) {
                    Note note = (Note)enumeration.nextElement();
                    if (!note.isRest() && !note.getTiedIn()) {
                        boolean bl3 = bl2 = bl2 && this.a(note);
                        if (!bl2 && !bl) continue block1;
                    }
                    if (!bl) continue;
                }
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        bl2 = false;
        System.out.println(C[60]);
        return bl2;
    }

    public void write() throws IOException {
        boolean bl = AutoBeamer.c;
        int n2 = this.c.getNumStaves();
        this.r = new Vector();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.v = this.a(i2);
            if (this.v) {
                this.w = new Vector();
                System.out.println(C[188] + i2 + C[190]);
            }
            this.b(i2);
            this.k();
            this.c();
            for (int i3 = 0; i3 < this.c.size(); ++i3) {
                Measure measure = this.c.getMeasure(i3);
                this.d.println(C[189] + (i3 + 1));
                if (this.h != 0) {
                    this.u();
                }
                this.h = 0;
                Staff staff = measure.getStaff(i2);
                if (i3 == 0 && staff.getInstrument() != null) {
                    this.a(staff);
                }
                this.c(staff);
                if (!bl) continue;
            }
            this.e();
            this.d();
            this.s();
            if (!bl) continue;
        }
        this.f();
        this.g();
    }

    private void c() {
        if (this.v) {
            this.d.println("{");
        }
    }

    private void d() {
        if (this.v) {
            this.d.println("}");
            this.d.println(C[34]);
            Enumeration enumeration = this.w.elements();
            while (enumeration.hasMoreElements()) {
                this.d.print((String)enumeration.nextElement() + " ");
                if (!AutoBeamer.c) continue;
            }
            this.d.println("}");
        }
    }

    private void a(Measure measure) {
        block2: {
            block3: {
                if (measure.getMeasureText() == null || measure.getMeasureText().length() <= 0) break block2;
                this.d.println(C[29]);
                if (measure.getMeasureText().length() != 1) break block3;
                this.d.println(C[26] + measure.getMeasureText() + C[28]);
                if (!AutoBeamer.c) break block2;
            }
            this.d.println(C[27] + measure.getMeasureText() + "\"");
        }
    }

    private void e() {
        if (this.o != 0) {
            this.d.println(C[205]);
        }
        if (this.n) {
            this.d.print(C[141]);
        }
        if (this.m) {
            this.d.print(C[138]);
        }
        if (this.l && !this.p) {
            this.d.print(C[213]);
        }
    }

    public boolean durationErrorsInScore() {
        return this.t != null && this.t.indexOf(C[170]) == -1;
    }

    public String getDurationErrorReport() {
        return this.t;
    }

    public boolean unbalancedRepeatsErrorsInScore() {
        return this.u != null && this.u.toLowerCase().indexOf(C[171]) != -1;
    }

    public String getUnbalancedRepeatsErrorReport() {
        return this.u;
    }

    private void a(Staff staff) {
        String string;
        String string2 = string = staff.getInstrument().getName();
        String string3 = string;
        if (string.indexOf("_") != -1) {
            string2 = string.substring(0, string.indexOf("_"));
            string3 = string.substring(string.indexOf("_") + 1, string.length());
        }
        this.d.println("\n");
        this.d.println(C[174] + string2 + C[3]);
        this.d.println(C[175] + string3 + C[3]);
    }

    private void f() throws IOException {
        this.d = new PrintWriter(new FileWriter(this.s));
        this.w();
        this.v();
        this.q();
        this.r();
        this.d.println(C[169]);
        this.p();
        this.i();
        this.x();
        this.y();
        this.t();
        this.h();
        this.j();
        this.u();
        this.d.close();
    }

    private void g() throws IOException {
        int n2 = 0;
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            Staff staff = this.c.getMeasure(0).getStaff(n2);
            String string = C[245] + n2;
            Instrument instrument = staff.getInstrument();
            if (instrument != null && (string = staff.getInstrument().getName()).indexOf("_") != -1) {
                string = string.substring(0, string.indexOf("_"));
            }
            String string2 = (String)enumeration.nextElement();
            int n3 = string2.indexOf(".");
            String string3 = string2.substring(0, n3);
            String string4 = this.a;
            String string5 = this.b(string);
            string4 = string4 + "-" + string5 + C[22];
            System.out.println(C[243] + string4);
            File file = new File(this.b, string4);
            this.d = new PrintWriter(new FileWriter(file));
            this.w();
            this.v();
            this.r();
            this.p();
            this.i();
            this.d(string);
            this.y();
            this.t();
            this.h();
            this.d.println(C[244]);
            this.d.println(C[210]);
            this.d.println(C[212] + string3);
            this.d.println(C[211]);
            this.u();
            this.d.close();
            ++n2;
            if (!AutoBeamer.c) continue;
        }
    }

    private void h() {
        this.d.println(C[127]);
    }

    private String b(String string) {
        return string.replace(' ', '_');
    }

    private void i() {
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.d.println(C[33] + string + "\"");
            if (!AutoBeamer.c) continue;
        }
    }

    private void j() {
        this.d.println(C[210]);
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf("."));
            this.d.println(C[212] + string2);
            if (!AutoBeamer.c) continue;
        }
        this.d.println(C[211]);
    }

    private void k() {
        this.e = null;
        this.g = null;
        this.h = 0;
        this.l = false;
        this.m = false;
        this.n = false;
        this.p = false;
        this.j = "";
        this.k = true;
        this.o = 0;
        this.q = false;
        this.i = null;
    }

    private void b(int n2) throws IOException {
        String string = this.h(n2);
        this.r.addElement(string);
        this.d = new PrintWriter(new FileWriter(new File(this.b, string)));
        this.w();
        this.v();
        this.l();
        this.d.println(C[168] + (n2 + 1) + "\n");
        this.c(string);
        this.t();
        this.o();
        this.n();
    }

    private void a(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        String string5 = string3.equalsIgnoreCase(C[13]) ? C[10] : C[9];
        this.d.println(string + C[8]);
        this.d.println(C[0]);
        this.d.println(C[7]);
        this.d.println(C[6]);
        this.d.println(C[4] + string5 + C[3] + string2 + C[15] + string4 + C[12]);
        this.d.println(C[14]);
        this.d.println(C[11]);
        this.d.println(C[5]);
        this.d.println(C[2] + string5 + C[3] + string2 + C[15] + string4 + C[12]);
        this.d.println(C[1]);
        this.d.println(C[16]);
        this.d.println("");
    }

    private void l() {
        this.m();
        for (int i2 = 0; i2 < this.y.length / 2; ++i2) {
            this.a(this.y[i2 * 2], this.y[i2 * 2 + 1]);
            if (!AutoBeamer.c) continue;
        }
    }

    private void m() {
        this.d.println(C[41]);
        this.d.println(C[42]);
        this.d.println(C[45]);
        this.d.println(C[49]);
        this.d.println(C[44]);
        this.d.println(C[40]);
        this.d.println(C[46]);
        this.d.println(C[43]);
        this.d.println(C[37]);
        this.d.println(C[48]);
        this.d.println(C[39]);
        this.d.println(C[38]);
        this.d.println("");
        this.d.println(C[36]);
        this.d.println(C[42]);
        this.d.println(C[45]);
        this.d.println(C[47]);
        this.d.println(C[44]);
        this.d.println(C[40]);
        this.d.println(C[46]);
        this.d.println(C[43]);
        this.d.println(C[37]);
        this.d.println(C[48]);
        this.d.println(C[39]);
        this.d.println(C[38]);
        this.d.println("");
    }

    private void n() {
        this.d.println(C[105]);
        this.d.println(C[106]);
    }

    private void o() {
        this.d.println(C[102]);
        this.d.println(C[103]);
        this.d.println(C[104]);
        this.d.println(C[101]);
    }

    private void p() {
        this.d.println(C[225]);
        this.d.println(C[224]);
        this.d.println(C[226]);
        this.d.println(C[228]);
        this.d.println(C[222]);
        this.d.println(C[229]);
        this.d.println(C[223]);
        this.d.println(C[227]);
    }

    private void q() {
        this.d.println(C[35]);
    }

    private void r() {
        this.d.println(C[97]);
        this.d.println(C[100]);
        this.d.println(C[95]);
        this.d.println(C[96]);
        this.d.println(C[94]);
        this.d.println(C[99]);
        this.d.println(C[98]);
    }

    private void c(String string) {
        String string2 = string.substring(0, string.indexOf("."));
        this.d.print("\"" + string2 + "\"" + C[8]);
    }

    private void s() {
        if (this.h != 0) {
            this.u();
        }
        this.u();
        this.d.close();
    }

    private boolean b(Staff staff) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < staff.size(); ++i2) {
            Track track = staff.getTrack(i2);
            boolean bl3 = bl2 = track.size() == 0;
            if (!bl2 && !bl) break;
            if (!bl) continue;
        }
        return bl2;
    }

    private void c(Staff staff) throws IOException {
        block10: {
            boolean bl;
            boolean bl2;
            block9: {
                bl2 = AutoBeamer.c;
                this.a(staff.getMeasure());
                this.e(staff);
                this.j(staff);
                this.d(staff);
                this.i(staff);
                this.h(staff);
                if (!this.b(staff)) break block9;
                this.g(staff);
                if (!bl2) break block10;
            }
            if (bl = staff.isMultiTrack()) {
                this.d.print(C[185]);
            }
            for (int i2 = staff.size() - 1; i2 >= 0; --i2) {
                Track track = staff.getTrack(i2);
                track.layoutChildren();
                if (bl) {
                    this.t();
                }
                for (int i3 = 0; i3 < track.size(); ++i3) {
                    Note note = track.getNote(i3);
                    this.g(note);
                    this.c(note);
                    this.a(staff, note);
                    this.i(note);
                    this.j(note);
                    this.l(note);
                    if (!bl2) continue;
                }
                if (bl) {
                    this.u();
                }
                if (!bl || i2 == 0) continue;
                this.d.println(C[187]);
                if (!bl2) continue;
            }
            if (bl) {
                this.d.println(C[186]);
            }
        }
        this.f(staff);
    }

    private String a(int n2, String string) {
        String string2 = n2 % 2 == 1 ? C[184] : C[183];
        return "\\" + string + string2;
    }

    private void d(Staff staff) {
        String string;
        block7: {
            block6: {
                int n2 = staff.getKeySignature().getNumAccidentals();
                int n3 = staff.getKeySignature().getKeySignatureType();
                string = null;
                KeySignature keySignature = this.f[staff.getStaffIndex()];
                if (keySignature != null && keySignature.equals(staff.getKeySignature())) {
                    this.f[staff.getStaffIndex()] = staff.getKeySignature();
                    return;
                }
                this.f[staff.getStaffIndex()] = staff.getKeySignature();
                if (n2 == 0) {
                    this.d.println(C[134]);
                    return;
                }
                string = n3 == 0 ? KeySignature.KEYSIG_SHARP_NAMES[n2 - 1] : KeySignature.KEYSIG_FLAT_NAMES[n2 - 1];
                if (!(string = string.substring(0, string.indexOf(47))).endsWith("#")) break block6;
                string = string.substring(0, 1) + C[132];
                if (!AutoBeamer.c) break block7;
            }
            if (string.endsWith("b") && string.length() == 2) {
                string = string.substring(0, 1) + C[135];
            }
        }
        string = string.toLowerCase();
        this.d.println(C[131] + string + C[133]);
    }

    private boolean b(Note note) {
        boolean bl;
        block6: {
            int n2;
            block5: {
                bl = true;
                if (note.getTuplet() != 0) break block5;
                bl = false;
                if (!AutoBeamer.c) break block6;
            }
            int n3 = note.getTuplet();
            if (note.nextNote() != null && (n2 = note.nextNote().getTuplet()) == n3) {
                boolean bl2 = bl = !note.getBeamedOut();
            }
            if (note.prevNote() != null && (n2 = note.prevNote().getTuplet()) == n3) {
                bl = bl && !note.prevNote().getBeamedOut();
            }
        }
        return bl;
    }

    private void c(Note note) {
        if (this.o != 1 && note.is8va()) {
            this.d.println(C[207]);
            this.o = 1;
            return;
        }
        if (this.o != -1 && note.is8vb()) {
            this.d.println(C[206]);
            this.o = -1;
            return;
        }
        if (this.o != 0 && !note.is8va() && !note.is8vb()) {
            this.d.println(C[205]);
            this.o = 0;
            return;
        }
    }

    private void e(Staff staff) {
        if (staff.getMeasure().getRepeatStart()) {
            int n2 = this.b(staff.getMeasure());
            this.d.println(C[19] + n2);
            this.t();
            if (n2 > 1) {
                String string = C[21];
                if (this.z) {
                    string = C[17];
                }
                this.d.println(C[20] + (n2 + 1) + C[18] + string + ")");
            }
        }
    }

    private int b(Measure measure) {
        boolean bl = AutoBeamer.c;
        int n2 = 2;
        for (int i2 = measure.getMeasureIndex(); i2 < measure.getScore().size(); ++i2) {
            Measure measure2 = measure.getScore().getMeasure(i2);
            if (!measure2.getRepeatEnd()) continue;
            n2 = measure2.getNumRepeats();
            if (!bl) break;
            if (!bl) continue;
        }
        return n2;
    }

    private void f(Staff staff) {
        block6: {
            String string;
            block7: {
                boolean bl;
                block5: {
                    bl = AutoBeamer.c;
                    this.z = false;
                    if (!staff.getMeasure().getRepeatEnd()) break block5;
                    this.z = true;
                    if (staff.getMeasure().getNumRepeats() > 1) {
                        this.d.println(C[54]);
                        this.d.println(C[56]);
                    }
                    this.u();
                    if (!bl) break block6;
                }
                if (!staff.getMeasure().getDoubleBar()) break block7;
                string = C[58];
                this.d.print(C[57] + string + C[59]);
                if (!bl) break block6;
            }
            if (staff.getMeasure().getPeriodDoubleBar()) {
                string = C[55];
                this.d.print(C[57] + string + C[59]);
            }
        }
    }

    private void g(Staff staff) {
        int n2 = staff.getMeasure().getTimeSig().getNumerator();
        int n3 = staff.getMeasure().getTimeSig().getDenominator();
        String string = "R" + n3 + "*" + n2;
        this.d.print(" " + string + " ");
    }

    private boolean d(Note note) {
        return this.f(note).length() > 0;
    }

    private String e(Note note) {
        String string;
        block7: {
            block6: {
                string = "";
                String string2 = this.h(note);
                if (note.getNoteHeadType() <= 1 || string2.equals(this.j) || this.d(note)) break block6;
                if (!string2.equals(C[50])) {
                    string = string2;
                    if (!note.isChord() && !note.isInterval()) {
                        this.k = false;
                    }
                }
                if (note.isChord() || note.isInterval()) break block7;
                this.j = string2;
                if (!AutoBeamer.c) break block7;
            }
            if (this.d(note)) {
                String string3;
                string = string3 = this.f(note);
            }
        }
        return string;
    }

    private String f(Note note) {
        String string;
        block5: {
            block10: {
                boolean bl;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    bl = AutoBeamer.c;
                                    string = "";
                                    if (note.getNoteHeadType() != 8) break block4;
                                    string = C[151];
                                    if (!bl) break block5;
                                }
                                if (note.getNoteHeadType() != 7) break block6;
                                string = C[151];
                                if (!bl) break block5;
                            }
                            if (note.getNoteHeadType() != 2) break block7;
                            string = C[153];
                            if (!bl) break block5;
                        }
                        if (note.getNoteHeadType() != 3) break block8;
                        string = C[150];
                        if (!bl) break block5;
                    }
                    if (note.getNoteHeadType() != 12) break block9;
                    string = C[149];
                    if (!bl) break block5;
                }
                if (note.getNoteHeadType() != 6) break block10;
                string = C[152];
                if (!bl) break block5;
            }
            if (note.getNoteHeadType() == 5) {
                string = C[152];
            }
        }
        return string;
    }

    private void g(Note note) {
    }

    private String h(Note note) {
        return C[50];
    }

    private void i(Note note) {
        if (!this.n && note.getCrescOut()) {
            this.d.print(C[139]);
            this.n = true;
            return;
        }
        if (!this.n && note.getDecrescOut()) {
            this.d.print(C[140]);
            this.n = true;
            return;
        }
        if (this.n && !note.getDecrescOut() && !note.getCrescOut()) {
            this.d.print(C[141]);
            this.n = false;
            return;
        }
    }

    private void j(Note note) {
        if (!this.m && note.getSlurredOut()) {
            this.d.print(C[137]);
            this.m = true;
            return;
        }
        if (this.m && !note.getSlurredOut()) {
            this.d.print(C[138]);
            this.m = false;
            return;
        }
    }

    private boolean k(Note note) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = false;
        int n2 = note.getTuplet();
        while (note != null && n2 == note.getTuplet() && n2 != 0 && note.getBeamedOut()) {
            boolean bl3 = bl2 = note.getCoreDuration() <= 2;
            if (bl2 && !bl) break;
            note = note.nextNote();
            if (!bl) continue;
        }
        if (!bl2 && n2 == note.getTuplet() && n2 != 0 && !note.getBeamedOut()) {
            bl2 = note.getCoreDuration() <= 2;
        }
        return bl2;
    }

    private void l(Note note) {
        if (!this.l && note.getBeamedOut()) {
            this.p = this.k(note);
            if (!this.p) {
                this.d.print(C[242]);
            }
            this.l = true;
            return;
        }
        if (this.l && !note.getBeamedOut()) {
            if (!this.p) {
                this.d.print(C[213]);
            }
            this.l = false;
            this.p = false;
            this.c(0);
            return;
        }
    }

    private void h(Staff staff) {
        boolean bl = AutoBeamer.c;
        Clef clef = staff.getClef();
        if (this.g == null || !this.g.equals(clef)) {
            String string = "";
            switch (clef.getClefType()) {
                case 0: {
                    string = C[202];
                    if (!bl) break;
                }
                case 1: {
                    string = C[201];
                    if (!bl) break;
                }
                case 2: {
                    string = C[199];
                    if (!bl) break;
                }
                case 3: {
                    string = C[200];
                    if (!bl) break;
                }
                case 4: {
                    string = C[203];
                }
            }
            this.d.println(C[204] + string);
            this.g = clef;
        }
    }

    private void t() {
        this.d.println("{");
    }

    private void u() {
        this.d.println(C[144]);
    }

    private String m(Note note) {
        boolean bl = AutoBeamer.c;
        String string = C[172];
        for (int i2 = 0; i2 < note.getMarks().size(); ++i2) {
            int n2 = (Integer)note.getMarks().elementAt(i2);
            if (n2 != 19) continue;
            string = C[173];
            if (!bl) break;
            if (!bl) continue;
        }
        return string;
    }

    int n(Note note) {
        boolean bl = AutoBeamer.c;
        int n2 = 0;
        for (int i2 = 0; i2 < note.getMarks().size(); ++i2) {
            int n3 = (Integer)note.getMarks().elementAt(i2);
            if (n3 == 16) {
                n2 = 2;
                if (!bl) break;
            }
            if (n3 == 17) {
                n2 = 3;
                if (!bl) break;
            }
            if (n3 != 18) continue;
            n2 = 4;
            if (!bl) break;
            if (!bl) continue;
        }
        return n2;
    }

    int o(Note note) {
        int n2 = note.getCoreDuration();
        return Math.max(1, n2 - 1);
    }

    private int p(Note note) {
        int n2 = this.n(note);
        int n3 = this.o(note);
        System.out.println(C[30] + note.getCoreDuration() + C[32] + n2 + C[31] + n3);
        int n4 = n2 + n3;
        int n5 = (int)Math.pow(2.0, n4);
        return n5;
    }

    private String q(Note note) {
        String string = "";
        if (this.n(note) != 0) {
            string = ":" + this.p(note);
        }
        return string;
    }

    private void a(Staff staff, Note note) {
        block41: {
            block40: {
                String string;
                boolean bl;
                block38: {
                    block39: {
                        String string2;
                        String string3;
                        Object object;
                        block37: {
                            block36: {
                                block35: {
                                    String string4;
                                    block32: {
                                        block31: {
                                            block30: {
                                                bl = AutoBeamer.c;
                                                if (note.isVisible()) break block30;
                                                this.d.print(C[156]);
                                                if (!bl) break block31;
                                            }
                                            if (!note.isStemVisible()) {
                                                this.d.print(C[163]);
                                            }
                                        }
                                        string4 = this.b(staff, note);
                                        if (note.getGraceNotes().size() <= 1) break block32;
                                        boolean bl2 = false;
                                        for (int i2 = 0; i2 < note.getGraceNotes().size(); ++i2) {
                                            block34: {
                                                block33: {
                                                    object = (Note)note.getGraceNotes().elementAt(i2);
                                                    string3 = this.c(staff, (Note)object);
                                                    string2 = this.z((Note)object);
                                                    if (i2 != 0) break block33;
                                                    if (staff.isMultiTrack()) {
                                                        this.d.print(this.a(note.getTrack().getTrackIndex(), C[159]) + " ");
                                                    }
                                                    this.d.print("\\" + this.m((Note)object) + C[162] + string3 + string2);
                                                    bl2 = ((Note)object).getBeamedOut();
                                                    if (!bl2) break block34;
                                                    this.d.print(C[155]);
                                                    if (!bl) break block34;
                                                }
                                                this.d.print(" " + string3 + string2);
                                            }
                                            if (i2 != note.getGraceNotes().size() - 1) continue;
                                            if (bl2) {
                                                this.d.print(C[157]);
                                            }
                                            this.d.println(C[158]);
                                            this.d.println(string4);
                                            if (!bl) continue;
                                        }
                                        if (!bl) break block35;
                                    }
                                    if (note.getGraceNotes().size() == 1) {
                                        Note note2 = (Note)note.getGraceNotes().elementAt(0);
                                        String string5 = this.c(staff, note2);
                                        object = this.z(note2);
                                        if (staff.isMultiTrack()) {
                                            this.d.print(this.a(note.getTrack().getTrackIndex(), C[159]) + " ");
                                        }
                                        this.d.print("\\" + this.m(note2) + " " + string5 + (String)object + " " + string4);
                                    }
                                }
                                this.c(note.getTuplet());
                                string = this.c(staff, note);
                                this.d.println(this.r(note));
                                if (this.w(note) && staff.isMultiTrack()) {
                                    this.d.print(this.a(note.getTrack().getTrackIndex(), C[161]) + " ");
                                }
                                if (!note.isChord()) break block36;
                                string = C[166] + this.e(note) + " " + string;
                                Enumeration enumeration = note.getIntervals().elements();
                                while (enumeration.hasMoreElements()) {
                                    object = (Note)enumeration.nextElement();
                                    string3 = this.y((Note)object);
                                    string = string + this.r((Note)object);
                                    string = string + " " + this.e((Note)object) + " " + this.c(staff, (Note)object) + string3;
                                    if (!bl) continue;
                                }
                                string = string + C[164];
                                if (!bl) break block37;
                            }
                            string = this.e(note) + " " + string;
                        }
                        String string6 = this.z(note);
                        object = this.A(note);
                        string3 = this.v(note);
                        string2 = this.u(note);
                        String string7 = this.y(note);
                        String string8 = this.q(note);
                        string = string + string6;
                        string = string + (String)object;
                        string = string + string8;
                        if (!note.isChord()) {
                            string = string + string3;
                        }
                        string = string + string2;
                        string = string + string7;
                        if (this.b(note)) {
                            string = string + C[160] + note.getTuplet() + C[28];
                        }
                        if (!this.a(note)) break block38;
                        if (!this.v) break block39;
                        this.w.addElement(note.getText());
                        if (!bl) break block38;
                    }
                    string = string + this.s(note);
                }
                if (note.prevNote() != null && !note.prevNote().getBeamedOut()) {
                    string = string + C[154];
                }
                this.d.print(string + " ");
                if (note.isVisible()) break block40;
                this.d.println(C[167]);
                if (!bl) break block41;
            }
            if (!note.isStemVisible()) {
                this.d.print(C[165]);
            }
        }
    }

    private String b(Staff staff, Note note) {
        String string = "";
        boolean bl = staff.isMultiTrack();
        if (bl) {
            string = note.getTrack().getTrackIndex() % 2 == 1 ? C[52] : C[53];
        }
        return string;
    }

    private String r(Note note) {
        String string;
        block4: {
            block6: {
                double d2;
                double d3;
                double d4;
                block5: {
                    string = "";
                    if (!(note.getNoteheadColor() == null && this.A != null || note.getNoteheadColor() != null && this.A == null) && (note.getNoteheadColor() == null || this.A == null || this.A.equals(note.getNoteheadColor()))) break block4;
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    if (note.getNoteheadColor() != null) {
                        d4 = (double)note.getNoteheadColor().getRed() / 255.0;
                        d3 = (double)note.getNoteheadColor().getGreen() / 255.0;
                        d2 = (double)note.getNoteheadColor().getBlue() / 255.0;
                    }
                    if (!note.isInterval()) break block5;
                    string = C[128] + d4 + " " + d3 + " " + d2 + C[130];
                    if (!AutoBeamer.c) break block6;
                }
                string = C[129] + d4 + " " + d3 + " " + d2 + ")";
            }
            this.A = note.getNoteheadColor();
        }
        return string;
    }

    private String s(Note note) {
        return C[208] + note.getText() + C[209];
    }

    private String t(Note note) {
        return C[182] + note.getText() + C[59];
    }

    private String u(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        String string = "";
        switch (note.getDynamic()) {
            case 0: {
                if (!bl) break;
            }
            case 1: {
                string = C[216];
                if (!bl) break;
            }
            case 2: {
                string = C[215];
                if (!bl) break;
            }
            case 3: {
                string = C[219];
                if (!bl) break;
            }
            case 4: {
                string = C[221];
                if (!bl) break;
            }
            case 5: {
                string = C[220];
                if (!bl) break;
            }
            case 6: {
                string = C[218];
                if (!bl) break;
            }
            case 7: {
                string = C[214];
                if (!bl) break;
            }
            case 8: {
                string = C[217];
            }
        }
        return string;
    }

    private String v(Note note) {
        return this.w(note) ? "~" : "";
    }

    private boolean w(Note note) {
        return note.getTiedOut() && !note.isRest();
    }

    private void c(int n2) {
        if (n2 != this.h) {
            if (this.h != 0) {
                this.u();
            }
            this.h = n2;
            if (n2 != 0) {
                this.d(n2);
                this.t();
                this.h = n2;
            }
        }
    }

    private void d(int n2) {
        this.d.println(C[51] + this.e(n2) + " ");
    }

    private String e(int n2) {
        int n3 = (int)Math.pow(2.0, JMSLMath.highestPowerOfTwoLessThan((int)n2));
        int n4 = n2;
        return n3 + "/" + n4;
    }

    private String c(Staff staff, Note note) {
        String string;
        String string2 = "";
        if ((note.isChord() || note.isInterval()) && (string = this.h(note)).indexOf(C[50]) == -1) {
            string2 = string2 + this.h(note) + " ";
        }
        string2 = string2 + this.a(note, staff).toLowerCase();
        int n2 = this.b(note, staff);
        if (!note.isRest() && note.is8va()) {
            ++n2;
        }
        if (!note.isRest() && note.is8vb()) {
            --n2;
        }
        String string3 = this.x(note);
        String string4 = this.v(note);
        String string5 = this.f(n2);
        string2 = string2 + string3;
        string2 = string2 + string5;
        if (note.isChord() || note.isInterval()) {
            string2 = string2 + string4;
        }
        if (note.isInterval() && this.a(note)) {
            string2 = string2 + this.t(note);
        }
        return string2;
    }

    private String x(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        String string = "";
        switch (note.getAcc()) {
            case 0: {
                if (!bl) break;
            }
            case 1: {
                string = C[132];
                if (!bl) break;
            }
            case 5: {
                string = C[176];
                if (!bl) break;
            }
            case 2: {
                string = C[135];
                if (!bl) break;
            }
            case 4: {
                string = C[180];
                if (!bl) break;
            }
            case 6: {
                string = C[178];
                if (!bl) break;
            }
            case 8: {
                string = C[177];
                if (!bl) break;
            }
            case 7: {
                string = C[181];
                if (!bl) break;
            }
            case 9: {
                string = C[179];
                break;
            }
        }
        return string;
    }

    private String y(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        Vector vector = note.getMarks();
        String string = "";
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object object;
            Integer n2 = (Integer)vector.elementAt(i2);
            boolean bl2 = true;
            if (note.isInterval() && ((Vector)(object = note.getHandle().getMarks())).contains(n2)) {
                bl2 = false;
            }
            if (!bl2) continue;
            object = "";
            switch (n2) {
                case 1: {
                    object = C[93];
                    if (!bl) break;
                }
                case 5: {
                    object = C[83];
                    if (!bl) break;
                }
                case 6: {
                    object = C[91];
                    if (!bl) break;
                }
                case 8: {
                    object = C[87];
                    if (!bl) break;
                }
                case 9: {
                    object = C[84];
                    if (!bl) break;
                }
                case 15: {
                    object = C[89];
                    if (!bl) break;
                }
                case 14: {
                    object = C[82];
                    if (!bl) break;
                }
                case 2: {
                    object = C[92];
                    if (!bl) break;
                }
                case 3: {
                    object = C[90];
                    if (!bl) break;
                }
                case 10: {
                    object = C[86];
                    if (!bl) break;
                }
                case 11: {
                    object = C[86];
                    if (!bl) break;
                }
                case 13: {
                    object = C[86];
                    if (!bl) break;
                }
                case 12: {
                    object = C[86];
                    if (!bl) break;
                }
                case 4: {
                    object = C[85];
                    if (!bl) break;
                }
                case 7: {
                    object = C[88];
                }
            }
            if (((String)object).length() <= 0) continue;
            string = string + "\\" + (String)object;
            if (!bl) continue;
        }
        return string;
    }

    private String z(Note note) {
        int n2 = note.getNoteDur();
        int n3 = (int)Math.pow(2.0, n2);
        return n3 + "";
    }

    private String A(Note note) {
        String string = "";
        for (int i2 = 0; i2 < note.getNumDots(); ++i2) {
            string = string + ".";
            if (!AutoBeamer.c) continue;
        }
        return string;
    }

    private String f(int n2) {
        if (n2 == 3 || n2 == -1) {
            return "";
        }
        String string = "'";
        String string2 = "'";
        int n3 = n2 - 4;
        if (n2 < 3) {
            string = ",";
            string2 = ",";
            n3 = 2 - n2;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + string2;
            if (!AutoBeamer.c) continue;
        }
        return string;
    }

    private void i(Staff staff) {
        TimeSignature timeSignature = staff.getMeasure().getTimeSig();
        if (this.e == null || !this.e.equals((Object)timeSignature)) {
            if (this.a(timeSignature)) {
                this.d.println(C[126]);
            }
            this.d.println(C[125] + timeSignature.getNumerator() + "/" + timeSignature.getDenominator());
            this.e = timeSignature;
        }
    }

    private boolean a(TimeSignature timeSignature) {
        return timeSignature.getNumerator() == 4 && timeSignature.getDenominator() == 4 || timeSignature.getNumerator() == 2 && timeSignature.getDenominator() == 2;
    }

    private void j(Staff staff) {
        if (this.i != null && this.i.equals(staff.getMeasure().getTempo())) {
            return;
        }
        Tempo tempo = staff.getMeasure().getTempo();
        String string = C[24] + (int)tempo.getBPM();
        if (!this.q) {
            this.d.println(C[25]);
            this.q = true;
        }
        this.d.println(string);
        this.i = tempo;
    }

    private void v() {
        this.d.println(C[146]);
        this.d.println(C[148] + new Date());
        this.d.println(C[145]);
        this.d.println(C[147]);
    }

    private String a(Note note, Staff staff) {
        if (note.isRest()) {
            return "r";
        }
        int n2 = this.k(staff);
        int n3 = note.getLevel();
        return NoteNamer.getPitchName(n3, n2);
    }

    private int k(Staff staff) {
        int n2 = staff.getClef().getClefLevelOffset();
        if (staff.getClef().getClefType() == Clef.PERCUSSION_CLEF.getClefType()) {
            n2 += 6;
        }
        return n2;
    }

    private int b(Note note, Staff staff) {
        if (note.isRest()) {
            return -1;
        }
        int n2 = this.k(staff);
        return NoteNamer.getOctaveName(note.getLevel(), n2);
    }

    private void w() {
        this.d.println(C[136]);
    }

    private void x() {
        this.d((String)null);
    }

    private void d(String string) {
        this.d.println(C[196]);
        this.d.println(C[197] + this.c.getName() + "\"");
        if (this.c.getSubtitle() != null && this.c.getSubtitle().length() > 0) {
            this.d.println(C[193] + this.c.getSubtitle() + "\"");
        }
        this.d.println(C[192] + this.c.getComposer() + "\"");
        if (this.c.getCopyright() != null && this.c.getCopyright().length() > 0) {
            this.d.println(C[191] + this.c.getCopyright() + "\"");
        }
        String string2 = this.c.getName();
        if (string != null) {
            string2 = string2 + C[195] + string + ")";
            this.d.println(C[198] + string + "\"");
        }
        this.d.println(C[194] + string2 + "\"");
        this.d.println("}");
    }

    private void y() {
        this.d.println(C[123]);
        this.d.println(C[119]);
        this.d.println(C[121]);
        this.d.println(C[124]);
        this.d.println(C[112]);
        this.d.println(C[120]);
        this.d.println(C[122]);
        this.d.println(C[111]);
        this.d.println(C[117]);
        this.d.println(C[115]);
        this.d.println(C[110]);
        this.d.println(C[111]);
        this.d.println(C[116]);
        this.d.println(C[113]);
        this.d.println(C[118]);
        this.d.println(C[110]);
        this.d.println(C[114]);
        this.d.println("}");
    }

    private static String g(int n2) {
        int n3 = n2 % 26;
        int n4 = n2 / 26;
        return B.substring(n4, n4 + 1) + B.substring(n3, n3 + 1);
    }

    private String h(int n2) {
        String string = LilyPondWriter.g(n2);
        return this.a + C[23] + string + C[22];
    }

    public static void main(String[] stringArray) {
        double d2;
        int n2;
        int n3;
        int n4;
        double d3;
        Object object;
        boolean bl = AutoBeamer.c;
        int n5 = 10;
        String[] stringArray2 = new String[]{C[62], C[74], C[81], C[76], C[65], C[71], C[67]};
        Orchestra orchestra = new Orchestra();
        for (int i2 = 0; i2 < n5; ++i2) {
            object = new InstrumentAdapter();
            object.setName(stringArray2[i2 % stringArray2.length]);
            orchestra.addInstrument((Instrument)object, object.getName());
            if (!bl) continue;
        }
        Score score = new Score(n5, 800, 600);
        score.setComposer(C[68]);
        score.setCopyright(C[64]);
        score.setName(C[63]);
        score.addMeasure(5, 4);
        score.setOrchestra(orchestra);
        score.getMeasure(0).getStaff(1).setClef(Clef.BASS_CLEF);
        score.getMeasure(0).getStaff(5).setClef(Clef.PERCUSSION_CLEF);
        object = score.addMeasure(4, 4);
        ((Measure)((Object)object)).setRepeatStart(true);
        ((Measure)((Object)object)).setTempo(90.0);
        object = score.addMeasure(4, 4);
        ((Measure)((Object)object)).setRepeatEnd(true);
        object.setRepeats(3);
        object = score.addMeasure();
        ((Measure)((Object)object)).setDoubleBar(true);
        object = score.addMeasure();
        ((Measure)((Object)object)).setDoubleBar(false);
        score.rewind();
        score.setCurrentStaffNumber(0);
        for (int i3 = 0; i3 < 24; ++i3) {
            boolean bl2 = i3 % 3 != 2;
            double d4 = 0.25;
            d3 = i3 + 60;
            Note note = score.addNote(d4, d3, 1.0, 0.4);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAccPref(1);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAltEnharmonicSpelling(true);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAccPref(1);
            note.setAltEnharmonicSpelling(true);
            note.setSlurredOut(bl2);
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(1);
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        double[] dArray = new double[]{0.75, 0.25};
        for (int i4 = 0; i4 < 48; ++i4) {
            n4 = i4 % 5 != 4 ? 1 : 0;
            d3 = dArray[i4 % dArray.length];
            int n6 = 60 + i4 - 24;
            Note note = score.addNote(d3, (double)n6, 0.5, 0.4);
            note.setSlurredOut(n4 != 0);
            note.setBeamedOut(i4 % 2 == 0);
            note.addInterval(n6 + 4);
            note.addInterval(n6 + 7);
            note.setDynamic(nArray[i4 % nArray.length]);
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(2);
        int[] nArray2 = new int[]{3, 3, 5, 5, 7, 9, 11, 13};
        for (n4 = 0; n4 < 24; ++n4) {
            int n7 = nArray2[n4 % nArray2.length];
            double d5 = 1.0;
            double d6 = d5 / (double)n7;
            for (int i5 = 0; i5 < n7; ++i5) {
                int n8 = 60 + n4;
                if (i5 == 1) {
                    n8 = 0;
                }
                boolean bl3 = i5 != n7 - 1;
                Note note = score.addNote(d6, (double)n8, 0.5, d6 * 0.8);
                note.setBeamedOut(i5 != n7 - 1);
                note.setTiedOut(i5 == 3 || i5 == 4);
                note.setCrescOut(bl3);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(3);
        Note note = score.addNote(0.6666, 72.0, 0.5, 0.5);
        note.setBeamedOut(true);
        note = score.addNote(0.3333, 72.0, 0.5, 0.5);
        note.setBeamedOut(false);
        for (n3 = 0; n3 < 3; ++n3) {
            note = score.addNote(0.3333, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 2);
            if (!bl) continue;
        }
        note = score.addNote(0.3333, 72.0, 0.5, 0.5);
        note.setBeamedOut(true);
        note = score.addNote(0.6666, 72.0, 0.5, 0.5);
        note.setBeamedOut(false);
        for (n3 = 0; n3 < 3; ++n3) {
            note = score.addNote(0.666, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 2);
            if (!bl) continue;
        }
        for (n3 = 0; n3 < 5; ++n3) {
            note = score.addNote(0.8, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 4);
            if (!bl) continue;
        }
        score.rewind();
        score.setCurrentStaffNumber(4);
        note = score.addNote(2.0, 60.0, 0.5, 0.8);
        note.addInterval(68.0).setTiedOut(true);
        note.addInterval(72.0);
        note = score.addNote(3.0, 60.0, 0.5, 0.8);
        note.addInterval(68.0);
        note.addInterval(72.0);
        score.rewind();
        score.setCurrentStaffNumber(5);
        score.addNote(3.0, 72.0, 0.5, 2.0).setTiedOut(true);
        score.addNote(2.0, 72.0, 0.5, 2.0);
        for (n3 = 0; n3 < 4; ++n3) {
            score.addNote(1.0, (double)(62 + n3 % 2 * 10), 0.5, 0.8);
            if (!bl) continue;
        }
        score.setCurrentTrackNumber(1);
        for (n3 = 0; n3 < 8; ++n3) {
            note = score.addNote(0.5, 79.0, 0.5, 0.4);
            note.setBeamedOut(n3 % 2 == 0);
            note.setNoteHeadType(2);
            if (!bl) continue;
        }
        score.setCurrentTrackNumber(0);
        score.addNote(4.0, 72.0, 0.5, 2.0);
        score.rewind();
        score.setCurrentStaffNumber(6);
        int[] nArray3 = new int[]{1, 5, 6, 8, 9, 15, 14, 2, 3, 10, 11, 13, 12, 4, 7};
        for (int i6 = 0; i6 < nArray3.length; ++i6) {
            score.addNote(1.0, 66.0, 0.5, 0.8).setMark(nArray3[i6]);
            if (!bl) continue;
        }
        score.addNote(2.0, 0.0, 0.0, 0.8);
        score.rewind();
        score.setCurrentStaffNumber(7);
        int[] nArray4 = new int[]{6, 5, 8, 7, 10, 9, 5, 6, 2, 4, 3, 12};
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[0]);
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[0]);
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[nArray4.length - 1]);
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            note = score.addNote(0.25, 72.0, 0.5, 0.4);
            note.setNoteHeadType(nArray4[n2]);
            note.addInterval(76.0);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            note = score.addNote(0.25, 72.0, 0.5, 0.4);
            note.setNoteHeadType(nArray4[n2]);
            if (n2 > 1 && n2 < 8) {
                note.set8va(true);
                if (!bl) continue;
            }
            if (n2 <= 9 || n2 >= 13) continue;
            note.set8vb(true);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            score.addNote(2.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[n2]);
            if (!bl) continue;
        }
        score.rewind();
        score.setCurrentStaffNumber(8);
        for (n2 = 0; n2 < 24; ++n2) {
            double d7 = 0.5;
            double d8 = 60.0 + (double)n2 * 0.5;
            double d9 = 0.5;
            d2 = d7 * 0.8;
            note = score.addNote(d7, d8, d9, d2);
            note.setBeamedOut(n2 % 2 == 0);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < 24; ++n2) {
            double d10 = 0.5;
            double d11 = 72.0 - (double)n2 * 0.5;
            double d12 = 0.5;
            d2 = d10 * 0.8;
            note = score.addNote(d10, d11, d12, d2);
            note.setAccPref(1);
            note.setBeamedOut(n2 % 2 == 0);
            if (!bl) continue;
        }
        note = score.addNote(1.0, 0.0, 0.0, 1.0);
        String[] stringArray3 = new String[]{C[78], C[79], C[77], C[61], C[66], C[70], C[69], C[66], C[72]};
        score.rewind();
        score.setCurrentStaffNumber(9);
        for (int i7 = 0; i7 < 66; ++i7) {
            double d13 = 0.5;
            double d14 = 84 - i7;
            double d15 = 0.5;
            double d16 = d13 * 0.8;
            note = score.addNote(d13, d14, d15, d16);
            note.setAccPref(1);
            note.setBeamedOut(i7 % 4 == 0);
            note.setText(stringArray3[JMSLRandom.choose((int)stringArray3.length)]);
            if (!(d14 < 60.0)) continue;
            note.getTrack().getStaff().setClef(Clef.BASS_CLEF);
            if (!bl) continue;
        }
        score.getMeasure(score.size() - 1).setDoubleBar(true);
        File file = new File(C[75]);
        try {
            System.out.println(C[80]);
            LilyPondWriter lilyPondWriter = new LilyPondWriter(score, file);
            lilyPondWriter.write();
            if (lilyPondWriter.durationErrorsInScore()) {
                System.err.println(lilyPondWriter.getDurationErrorReport());
            }
            System.out.println(C[73]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        String[] stringArray = new String[246];
        Object var0 = null;
        LY_VERSION = LilyPondWriter.z(LilyPondWriter.z("\u001fxtn>\u001f"));
        var0 = null;
        stringArray[0] = LilyPondWriter.z(LilyPondWriter.z("\u000e~!3vD8 {}X%,5=K#+5dD9+v8]77%u_v)9sL\",9~\r;0%yN\u007fm:i\u0017;0%yNil"));
        var0 = null;
        stringArray[1] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\u000e;0%yN"));
        var0 = null;
        stringArray[2] = LilyPondWriter.z(LilyPondWriter.z("\rvev0q9+5u\r\n1!uL=e\u0018\u007fY3\r3qIx6\"uC5,:0\u000e~"));
        var0 = null;
        stringArray[3] = LilyPondWriter.z(LilyPondWriter.z("\rt"));
        var0 = null;
        stringArray[4] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rve\n\u007fC5 vLB  $bD2 v^B\" \u001euL2k%dH8&?|\rkeu8"));
        var0 = null;
        stringArray[5] = LilyPondWriter.z(LilyPondWriter.z("\rveuk"));
        var0 = null;
        stringArray[6] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\ru>"));
        var0 = null;
        stringArray[7] = LilyPondWriter.z(LilyPondWriter.z("\rvm?v\r~(#cD5h?c\u00009#{dT& i0@#6?s\rq  uC\"h5xB$!\u007f"));
        var0 = null;
        stringArray[8] = LilyPondWriter.z(LilyPondWriter.z("\rke"));
        var0 = null;
        stringArray[9] = LilyPondWriter.z(LilyPondWriter.z("C32{xH7!{vD. 2=I#77dD9+"));
        var0 = null;
        stringArray[10] = LilyPondWriter.z(LilyPondWriter.z("C32{xH7!"));
        var0 = null;
        stringArray[11] = LilyPondWriter.z(LilyPondWriter.z("\rveum"));
        var0 = null;
        stringArray[12] = LilyPondWriter.z(LilyPondWriter.z("\u000f\u007f"));
        var0 = null;
        stringArray[13] = LilyPondWriter.z(LilyPondWriter.z("X% 2e_"));
        var0 = null;
        stringArray[14] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rveu}X%,5"));
        var0 = null;
        stringArray[15] = LilyPondWriter.z(LilyPondWriter.z("\u000fvg"));
        var0 = null;
        stringArray[16] = LilyPondWriter.z(LilyPondWriter.z("\rveum\u0004\u007f"));
        var0 = null;
        stringArray[17] = LilyPondWriter.z(LilyPondWriter.z("\r3+2=_353qYv6\"q_\"h$u]3$\""));
        var0 = null;
        stringArray[18] = LilyPondWriter.z(LilyPondWriter.z("Utlv"));
        var0 = null;
        stringArray[19] = LilyPondWriter.z(LilyPondWriter.z("q$ &uL\"e \u007fA\"$v"));
        var0 = null;
        stringArray[20] = LilyPondWriter.z(LilyPondWriter.z("q% \"0~5*$u\u0003$ &uL\"\u00069}@7+2c\rkeu7\u0005vm \u007fA\"$v2"));
        var0 = null;
        stringArray[21] = LilyPondWriter.z(LilyPondWriter.z("\r%17bY{73`H71"));
        var0 = null;
        stringArray[22] = LilyPondWriter.z(LilyPondWriter.z("\u0003:<"));
        var0 = null;
        stringArray[23] = LilyPondWriter.z(LilyPondWriter.z("~\"$0v"));
        var0 = null;
        stringArray[24] = LilyPondWriter.z(LilyPondWriter.z("q\" ;`Bvqk"));
        var0 = null;
        stringArray[25] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u001b \"bB8*;u`77=0\u000eq57tI?+10\u0010vfb>\u0018"));
        var0 = null;
        stringArray[26] = LilyPondWriter.z(LilyPondWriter.z("q;$${\r\n(7bF#5-0q4*.0"));
        var0 = null;
        stringArray[27] = LilyPondWriter.z(LilyPondWriter.z("q;$${\rt"));
        var0 = null;
        stringArray[28] = LilyPondWriter.z(LilyPondWriter.z("\r+"));
        var0 = null;
        stringArray[29] = LilyPondWriter.z(LilyPondWriter.z("q9+5u\r\n* u_$,2u\r\u0005&9bHx\u00173xH77%qA\u001b$${\rub%uA0h7|D1+;uC\"h\u000e0\u0010vf:uK\""));
        var0 = null;
        stringArray[30] = LilyPondWriter.z(LilyPondWriter.z("Y$ ;0N9!3*\r5*$u\r20$0\u0010"));
        var0 = null;
        stringArray[31] = LilyPondWriter.z(LilyPondWriter.z("\u0001v$2tD\",9~L:\u007fv"));
        var0 = null;
        stringArray[32] = LilyPondWriter.z(LilyPondWriter.z("\u0001v59gH$e9v\r\"290K$*;0Y$ ;0\u0010v"));
        var0 = null;
        stringArray[33] = LilyPondWriter.z(LilyPondWriter.z("q?+5|X2 v2"));
        var0 = null;
        stringArray[34] = LilyPondWriter.z(LilyPondWriter.z("q7!2|T$,5c\r-"));
        var0 = null;
        stringArray[35] = LilyPondWriter.z(LilyPondWriter.z("\u000e~63d\u00002 0qX:1{`L& $=^??30\u000f: \"dH$gv7A7+2cN7539"));
        var0 = null;
        stringArray[36] = LilyPondWriter.z(LilyPondWriter.z("\u000e~!3vD8 v8C32{xH7!{vD. 2=I#77dD9+vdT& v`_3#?h\u0004"));
        var0 = null;
        stringArray[37] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\u00054 1yC"));
        var0 = null;
        stringArray[38] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0^\",:9\u0004\u007fl"));
        var0 = null;
        stringArray[39] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\rvm:i\u00178*\"u\u0000> 7t\u0017l5$yC\"e1bB4l\u007f"));
        var0 = null;
        stringArray[40] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\rvev0\rvev8A/\u007f1bB4h2uK70:d\u00000*8d\r179r\u0004"));
        var0 = null;
        stringArray[41] = LilyPondWriter.z(LilyPondWriter.z("\u000e~!3vD8 v8C32{xH7!vdT& v`_3#?h\u0004"));
        var0 = null;
        stringArray[42] = LilyPondWriter.z(LilyPondWriter.z("\rvm:q@4!70\u0005179r\u0004"));
        var0 = null;
        stringArray[43] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\r~,00\u0005:<lcY3+5yA{ ;`Y/zvcY?)\u007f"));
        var0 = null;
        stringArray[44] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\r~6\"yAvm:i\u00170*8d\u00001 \"=J:<&x"));
        var0 = null;
        stringArray[45] = LilyPondWriter.z(LilyPondWriter.z("\rvev8A31|0\u0005~!#bL\",9~\r~)/*J$*4=]$*&u_\"<vw_9'v7I#77dD9+{|B1l\u007f"));
        var0 = null;
        stringArray[46] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\rvev0\rvevxH7!\u007f9\u0004"));
        var0 = null;
        stringArray[47] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\r~-3qIvm0\u007f_;$\"0\u000e0et~B\" >uL26xnL($(q\u000fv5$uK?=v\"\r\"<&u\u0004\u007f"));
        var0 = null;
        stringArray[48] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\rvm:i\u0017!$$~D8\"v2x8.8\u007fZ8e\u0018\u007fY3\r3qIle(q\u0001v,1~B$,8w\u0003te>uL2l"));
        var0 = null;
        stringArray[49] = LilyPondWriter.z(LilyPondWriter.z("\rvev0\rvev0\r~-3qIvm0\u007f_;$\"0\u000e0et~B\" >uL26xnL($(q\u000fv5$uK?=vtX$$\"yB8e\"i]3l\u007f"));
        var0 = null;
        stringArray[50] = LilyPondWriter.z(LilyPondWriter.z("x\u0018\u0016\u0003@}\u0019\u0017\u0002Ui"));
        var0 = null;
        stringArray[51] = LilyPondWriter.z(LilyPondWriter.z("'\n1?}H%e"));
        var0 = null;
        stringArray[52] = LilyPondWriter.z(LilyPondWriter.z("q *?sH\u0019+3"));
        var0 = null;
        stringArray[53] = LilyPondWriter.z(LilyPondWriter.z("q *?sH\u000229"));
        var0 = null;
        stringArray[54] = LilyPondWriter.z(LilyPondWriter.z("q% \"0~5*$u\u0003$ &uL\"\u00069}@7+2c\rkeu7\u0005vm \u007fA\"$v2\rtlvuC2h$u]3$\"9"));
        var0 = null;
        stringArray[55] = LilyPondWriter.z(LilyPondWriter.z("Qx"));
        var0 = null;
        stringArray[56] = LilyPondWriter.z(LilyPondWriter.z("q% \"0~5*$u\u0003$ &uL\"\u00069}@7+2c\rkeu7\u0005~39|Y7euv\u0004\u007f"));
        var0 = null;
        stringArray[57] = LilyPondWriter.z(LilyPondWriter.z("\r\n'7b\rt"));
        var0 = null;
        stringArray[58] = LilyPondWriter.z(LilyPondWriter.z("Q*"));
        var0 = null;
        stringArray[59] = LilyPondWriter.z(LilyPondWriter.z("\u000fv"));
        var0 = null;
        stringArray[60] = LilyPondWriter.z(LilyPondWriter.z("a?)/`D8!\u0001bD\" $0C91vg_?1?~Jv)/bD56z0X%,8w\r;$${X&6vyC%13qI"));
        var0 = null;
        stringArray[61] = LilyPondWriter.z(LilyPondWriter.z("^'03uW3"));
        var0 = null;
        stringArray[62] = LilyPondWriter.z(LilyPondWriter.z("Y&1"));
        var0 = null;
        stringArray[63] = LilyPondWriter.z(LilyPondWriter.z("y36\"0g\u001b\u0016\u001a0\u0000he\u001ayA/\u00159~Iv .`B$13b"));
        var0 = null;
        stringArray[64] = LilyPondWriter.z(LilyPondWriter.z("\u00055lv\"\u001dfsv^D5.vTD2.9f^=<v?\r\u000608\u007f^v\b#cD5e~R`\u001fl"));
        var0 = null;
        stringArray[65] = LilyPondWriter.z(LilyPondWriter.z("H11$"));
        var0 = null;
        stringArray[66] = LilyPondWriter.z(LilyPondWriter.z("@3"));
        var0 = null;
        stringArray[67] = LilyPondWriter.z(LilyPondWriter.z("H4"));
        var0 = null;
        stringArray[68] = LilyPondWriter.z(LilyPondWriter.z("c?&=0i?!=\u007f[%./"));
        var0 = null;
        stringArray[69] = LilyPondWriter.z(LilyPondWriter.z("A31"));
        var0 = null;
        stringArray[70] = LilyPondWriter.z(LilyPondWriter.z("C333b"));
        var0 = null;
        stringArray[71] = LilyPondWriter.z(LilyPondWriter.z("I;6"));
        var0 = null;
        stringArray[72] = LilyPondWriter.z(LilyPondWriter.z("J9"));
        var0 = null;
        stringArray[73] = LilyPondWriter.z(LilyPondWriter.z("I9+3"));
        var0 = null;
        stringArray[74] = LilyPondWriter.z(LilyPondWriter.z("]0"));
        var0 = null;
        stringArray[75] = LilyPondWriter.z(LilyPondWriter.z("nlj\u0012\u007fN#(3~Y%e7~Iv\u00163dY?+1c\u0002\u0018,5{\u0003\u0006\u0010\u0018_~{\u0003g\"n\u0010rb'\u0014y\u00013cF\"*&?A?)/`B8!ydH%1x|T"));
        var0 = null;
        stringArray[76] = LilyPondWriter.z(LilyPondWriter.z("O5)"));
        var0 = null;
        stringArray[77] = LilyPondWriter.z(LilyPondWriter.z("]: 7cH"));
        var0 = null;
        stringArray[78] = LilyPondWriter.z(LilyPondWriter.z("B>"));
        var0 = null;
        stringArray[79] = LilyPondWriter.z(LilyPondWriter.z("O7'/"));
        var0 = null;
        stringArray[80] = LilyPondWriter.z(LilyPondWriter.z("z$,\"yC1e\u001ayA/\u00159~Iv#?|H"));
        var0 = null;
        stringArray[81] = LilyPondWriter.z(LilyPondWriter.z("^%="));
        var0 = null;
        stringArray[82] = LilyPondWriter.z(LilyPondWriter.z("@972uC\""));
        var0 = null;
        stringArray[83] = LilyPondWriter.z(LilyPondWriter.z("L5&3~Y\n6\"qN5$\"\u007f"));
        var0 = null;
        stringArray[84] = LilyPondWriter.z(LilyPondWriter.z("K:$1uB: \""));
        var0 = null;
        stringArray[85] = LilyPondWriter.z(LilyPondWriter.z("_\"*3"));
        var0 = null;
        stringArray[86] = LilyPondWriter.z(LilyPondWriter.z("Y$,:|"));
        var0 = null;
        stringArray[87] = LilyPondWriter.z(LilyPondWriter.z("K37;qY7"));
        var0 = null;
        stringArray[88] = LilyPondWriter.z(LilyPondWriter.z("_\"*3L^\"$5sL\"*"));
        var0 = null;
        stringArray[89] = LilyPondWriter.z(LilyPondWriter.z("I928}B$!3~Y"));
        var0 = null;
        stringArray[90] = LilyPondWriter.z(LilyPondWriter.z("Y3+#dB"));
        var0 = null;
        stringArray[91] = LilyPondWriter.z(LilyPondWriter.z("L5&3~Y\n13~X\"*"));
        var0 = null;
        stringArray[92] = LilyPondWriter.z(LilyPondWriter.z("^\"$5sL\"*"));
        var0 = null;
        stringArray[93] = LilyPondWriter.z(LilyPondWriter.z("L5&3~Y"));
        var0 = null;
        stringArray[94] = LilyPondWriter.z(LilyPondWriter.z("$_m%uYwe~|Tl(#cD5h&bB& $dTv(v7Y! 7{^\u007f"));
        var0 = null;
        stringArray[95] = LilyPondWriter.z(LilyPondWriter.z("$~)3d\r~m\"uU\"e~}L$.#`\ru\u007f0\u007fC\"6?jHvhg0^\"7?~J{13hY\u007fl"));
        var0 = null;
        stringArray[96] = LilyPondWriter.z(LilyPondWriter.z("$~(v8@7.3=@#6?s\rq\u0003?~J37?~J\u001333~Yvb2yJ?1v \r\u007fl\u007f"));
        var0 = null;
        stringArray[97] = LilyPondWriter.z(LilyPondWriter.z("\b7!2DH.1vtH0,8yY?*8"));
        var0 = null;
        stringArray[98] = LilyPondWriter.z(LilyPondWriter.z("$;l\u007f"));
        var0 = null;
        stringArray[99] = LilyPondWriter.z(LilyPondWriter.z("$_m7sB86v7Y3=\"0Y3=\"0\u0005:<l}X%,5=]$*&u_\"<v}\rq1!uL=6\u007f9\u0004"));
        var0 = null;
        stringArray[100] = LilyPondWriter.z(LilyPondWriter.z("L2!\u0002uU\"ek0\u000e~!3vD8 {}X%,5=K#+5dD9+v8]77%u_v)9sL\",9~\r%1$yC1h\"uU\"lv8^\"7?~Jil"));
        var0 = null;
        stringArray[101] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u0000*:dL\u001477sF31v3\n0*8d\u0000%,,u\rkeu;\u001c"));
        var0 = null;
        stringArray[102] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u0004 >uL$67|`77=0\u000eq#9~Y{6?jHvxv3\u0000g"));
        var0 = null;
        stringArray[103] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u0000*:dL\u001477sF31v3\n0*8d\u00008$;u\rkeu2c32vSH81#bTv\u00165xB9)4\u007fB=g"));
        var0 = null;
        stringArray[104] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u0000*:dL\u001477sF31v3\n0*8d\u0000%-7`Hvxv3\n4*:t"));
        var0 = null;
        stringArray[105] = LilyPondWriter.z(LilyPondWriter.z("\b\" .d\r\u00197?uC\"$\"yB8"));
        var0 = null;
        stringArray[106] = LilyPondWriter.z(LilyPondWriter.z("q% \"0{9,5u\u00030,8wH$,8wb$,3~Y71?\u007fC%ek0\u000eqm:uK\"l"));
        var0 = null;
        stringArray[107] = LilyPondWriter.z(LilyPondWriter.z("\u000fv&9~Y7,8c\r#+4qA7+5uIv73`H71vrL$6vlQlellQ\\"));
        var0 = null;
        stringArray[108] = LilyPondWriter.z(LilyPondWriter.z("y>,%0Z?):0_36#|Yv,80^333bA/e5\u007f_$0&dH2e\u001ayA/\u00159~Iv)7iB#1x\u001a"));
        var0 = null;
        stringArray[109] = LilyPondWriter.z(LilyPondWriter.z("g\u001b\u0016\u001a0~5*$u\rt"));
        var0 = null;
        stringArray[110] = LilyPondWriter.z(LilyPondWriter.z("$_8"));
        var0 = null;
        stringArray[111] = LilyPondWriter.z(LilyPondWriter.z("$_\u00190yA:h:yC3e-"));
        var0 = null;
        stringArray[112] = LilyPondWriter.z(LilyPondWriter.z("$$$1wH2h:q^\"h4\u007fY\"*;-\u000eu#"));
        var0 = null;
        stringArray[113] = LilyPondWriter.z(LilyPondWriter.z("$_L\n\u007fC{1>u\u00000)/0\u000e8*\"=K?7%d\u0000&$1u\r\n#$\u007f@&79`H$1/0\u000eq-3qI37ldL1)?~H"));
        var0 = null;
        stringArray[114] = LilyPondWriter.z(LilyPondWriter.z("$+"));
        var0 = null;
        stringArray[115] = LilyPondWriter.z(LilyPondWriter.z("$_L\n\u007fC{1>u\u00000)/0\u000e0,$cY{57wHv\u00190bB;5$\u007f]37\"i\rub>uL2 $*N95/bD1-\""));
        var0 = null;
        stringArray[116] = LilyPondWriter.z(LilyPondWriter.z("$_Ls5\r\"$1|D8 vxH7!3b\r0,3|Iv*80L:)vrX\"e0y_%1v`L1 x"));
        var0 = null;
        stringArray[117] = LilyPondWriter.z(LilyPondWriter.z("$_Ls5\r\u0015*&i_?\">d\r> 7tH$e0yH:!v\u007fC:<v\u007fCv#?b^\"e&qJ3k"));
        var0 = null;
        stringArray[118] = LilyPondWriter.z(LilyPondWriter.z("$_L+"));
        var0 = null;
        stringArray[119] = LilyPondWriter.z(LilyPondWriter.z("$4 \"gH3+{cT%13}\u0000%57sHvxv!\u0003c\u00195}"));
        var0 = null;
        stringArray[120] = LilyPondWriter.z(LilyPondWriter.z("$9!2VB913b`77=e]vxvL@77=e]v>"));
        var0 = null;
        stringArray[121] = LilyPondWriter.z(LilyPondWriter.z("$4 \"gH3+{cT%13}\u0000&$2tD8\"v-\rut"));
        var0 = null;
        stringArray[122] = LilyPondWriter.z(LilyPondWriter.z("$_\u00195\u007fA#(80V"));
        var0 = null;
        stringArray[123] = LilyPondWriter.z(LilyPondWriter.z("q&$&u_v>"));
        var0 = null;
        stringArray[124] = LilyPondWriter.z(LilyPondWriter.z("$$$1wH2h4\u007fY\"*;-\u000eu#"));
        var0 = null;
        stringArray[125] = LilyPondWriter.z(LilyPondWriter.z("'\n1?}Hv"));
        var0 = null;
        stringArray[126] = LilyPondWriter.z(LilyPondWriter.z("'\n* u_$,2u\r\u000517vKx\u0011?}H\u0005,1~L\"0$u\rub%dT: v-\rub~9"));
        var0 = null;
        stringArray[127] = LilyPondWriter.z(LilyPondWriter.z("q933b_?!30~5*$u\u0003\u00020&|H\"\u000b#}O37v3\n\u000eh3hY3+\"0\u0010vfq8\u001dvkv \u0004v"));
        var0 = null;
        stringArray[128] = LilyPondWriter.z(LilyPondWriter.z("\r\n1!uL=eu7N9)9b\rub~"));
        var0 = null;
        stringArray[129] = LilyPondWriter.z(LilyPondWriter.z("'\n* u_$,2u\r\u0018*\"ue3$20\u000eq&9|B$ek0\u000eqm"));
        var0 = null;
        stringArray[130] = LilyPondWriter.z(LilyPondWriter.z("\u0004v"));
        var0 = null;
        stringArray[131] = LilyPondWriter.z(LilyPondWriter.z("q= /0"));
        var0 = null;
        stringArray[132] = LilyPondWriter.z(LilyPondWriter.z("D%"));
        var0 = null;
        stringArray[133] = LilyPondWriter.z(LilyPondWriter.z("\r\n(7zB$"));
        var0 = null;
        stringArray[134] = LilyPondWriter.z(LilyPondWriter.z("q= /0Nv\u0019;qG97"));
        var0 = null;
        stringArray[135] = LilyPondWriter.z(LilyPondWriter.z("H%"));
        var0 = null;
        stringArray[136] = LilyPondWriter.z(LilyPondWriter.z("q  $cD9+v2\u001fxtn>\u001ft"));
        var0 = null;
        stringArray[137] = LilyPondWriter.z(LilyPondWriter.z("\r~e"));
        var0 = null;
        stringArray[138] = LilyPondWriter.z(LilyPondWriter.z("\r\u007fe"));
        var0 = null;
        stringArray[139] = LilyPondWriter.z(LilyPondWriter.z("\r\n&$0"));
        var0 = null;
        stringArray[140] = LilyPondWriter.z(LilyPondWriter.z("\r\n!3s_v"));
        var0 = null;
        stringArray[141] = LilyPondWriter.z(LilyPondWriter.z("\r\ndv"));
        var0 = null;
        stringArray[142] = LilyPondWriter.z(LilyPondWriter.z("y>,%0Z?):0_36#|Yv,80X8 .`H513t\r; 7cX$ vsB813~Y%e?~\r\u001a,:i}9+2>'"));
        var0 = null;
        stringArray[143] = LilyPondWriter.z(LilyPondWriter.z("\u000fv&9~Y7,8c\r; 7cX$ %0Z?1>0Y9*v}L8<v\u007f_v19\u007f\r0 !0Y917|\r20$qY?*8c\u0003\\"));
        var0 = null;
        stringArray[144] = LilyPondWriter.z(LilyPondWriter.z("'+"));
        var0 = null;
        stringArray[145] = LilyPondWriter.z(LilyPondWriter.z("\bv\u000f\u001bCav190a?)/@B8!vsB833bY37vrTv\u000b?sFv\u0001?tF93%{Tze~s\u0004vwf \u001bv\u000b?sFv\u0001?tF93%{T"));
        var0 = null;
        stringArray[146] = LilyPondWriter.z(LilyPondWriter.z("\bv\u0006$uL\" 20O/\u007fvZL $v]X%,50~& 5yK?&7dD9+v\\L8\"#qJ3ivRx\u001f\t\u00120\u001fftb!\u001cfw"));
        var0 = null;
        stringArray[147] = LilyPondWriter.z(LilyPondWriter.z("\bv3?cD\"e!gZx$:wB;0%yNx&9}\r7+20Z!2x|D:<&\u007fC2k9bJ"));
        var0 = null;
        stringArray[148] = LilyPondWriter.z(LilyPondWriter.z("\bv\u0006$uL\",9~\r2$\"u\u0017v"));
        var0 = null;
        stringArray[149] = LilyPondWriter.z(LilyPondWriter.z("q%)7cE\u0018*\"uE3$2"));
        var0 = null;
        stringArray[150] = LilyPondWriter.z(LilyPondWriter.z("q\u0019\u001d\u0018\u007fY3-3qI"));
        var0 = null;
        stringArray[151] = LilyPondWriter.z(LilyPondWriter.z("q4)7sF\u00027?qC1)3^B\" >uL2"));
        var0 = null;
        stringArray[152] = LilyPondWriter.z(LilyPondWriter.z("q2,7}B8!"));
        var0 = null;
        stringArray[153] = LilyPondWriter.z(LilyPondWriter.z("q\u000e\u000b9dH> 7t"));
        var0 = null;
        stringArray[154] = LilyPondWriter.z(LilyPondWriter.z("q8*\u0014uL;"));
        var0 = null;
        stringArray[155] = LilyPondWriter.z(LilyPondWriter.z("\r\re"));
        var0 = null;
        stringArray[156] = LilyPondWriter.z(LilyPondWriter.z("\r\n':qC=+9dH%e"));
        var0 = null;
        stringArray[157] = LilyPondWriter.z(LilyPondWriter.z("\r\u000be"));
        var0 = null;
        stringArray[158] = LilyPondWriter.z(LilyPondWriter.z("\r+e"));
        var0 = null;
        stringArray[159] = LilyPondWriter.z(LilyPondWriter.z("^:0$"));
        var0 = null;
        stringArray[160] = LilyPondWriter.z(LilyPondWriter.z("s\n(7bF#5-LD\"$:yN\n1?~Tv"));
        var0 = null;
        stringArray[161] = LilyPondWriter.z(LilyPondWriter.z("Y? "));
        var0 = null;
        stringArray[162] = LilyPondWriter.z(LilyPondWriter.z("\r-e"));
        var0 = null;
        stringArray[163] = LilyPondWriter.z(LilyPondWriter.z("\r\n':qC=6\"u@%e"));
        var0 = null;
        stringArray[164] = LilyPondWriter.z(LilyPondWriter.z("\rh"));
        var0 = null;
        stringArray[165] = LilyPondWriter.z(LilyPondWriter.z("\r\n08rA7+=cY3(%0"));
        var0 = null;
        stringArray[166] = LilyPondWriter.z(LilyPondWriter.z("\u0011v"));
        var0 = null;
        stringArray[167] = LilyPondWriter.z(LilyPondWriter.z("\r\n08rA7+=~B\" %0"));
        var0 = null;
        stringArray[168] = LilyPondWriter.z(LilyPondWriter.z("'se\u0005dL0#v"));
        var0 = null;
        stringArray[169] = LilyPondWriter.z(LilyPondWriter.z("\u000e~63d\u00001)9rL:h%dL0#{cD, v!\u0019\u007f"));
        var0 = null;
        stringArray[170] = LilyPondWriter.z(LilyPondWriter.z("c9e2e_71?\u007fCv $bB$6vbH&*$dH2"));
        var0 = null;
        stringArray[171] = LilyPondWriter.z(LilyPondWriter.z("H$79b"));
        var0 = null;
        stringArray[172] = LilyPondWriter.z(LilyPondWriter.z("L&59wJ?$\"e_7"));
        var0 = null;
        stringArray[173] = LilyPondWriter.z(LilyPondWriter.z("L5&?qN5$\"e_7"));
        var0 = null;
        stringArray[174] = LilyPondWriter.z(LilyPondWriter.z("q% \"0~\"$0v\u0003?+%d_#(3~Y\u0018$;u\rket"));
        var0 = null;
        stringArray[175] = LilyPondWriter.z(LilyPondWriter.z("q\"$10\u000eq65\u007f_3e\ncH\"e\u0005dL0#xcE97\"YC%1$e@3+\"^L; v-\rt"));
        var0 = null;
        stringArray[176] = LilyPondWriter.z(LilyPondWriter.z("D%,%"));
        var0 = null;
        stringArray[177] = LilyPondWriter.z(LilyPondWriter.z("D>"));
        var0 = null;
        stringArray[178] = LilyPondWriter.z(LilyPondWriter.z("H>"));
        var0 = null;
        stringArray[179] = LilyPondWriter.z(LilyPondWriter.z("D%,>"));
        var0 = null;
        stringArray[180] = LilyPondWriter.z(LilyPondWriter.z("H% %"));
        var0 = null;
        stringArray[181] = LilyPondWriter.z(LilyPondWriter.z("H% >"));
        var0 = null;
        stringArray[182] = LilyPondWriter.z(LilyPondWriter.z("\u0000\n$2ty3=\"0\u000et"));
        var0 = null;
        stringArray[183] = LilyPondWriter.z(LilyPondWriter.z("x&"));
        var0 = null;
        stringArray[184] = LilyPondWriter.z(LilyPondWriter.z("i928"));
        var0 = null;
        stringArray[185] = LilyPondWriter.z(LilyPondWriter.z("\rjyv0"));
        var0 = null;
        stringArray[186] = LilyPondWriter.z(LilyPondWriter.z("\rh{v"));
        var0 = null;
        stringArray[187] = LilyPondWriter.z(LilyPondWriter.z("\r\n\u0019v"));
        var0 = null;
        stringArray[188] = LilyPondWriter.z(LilyPondWriter.z("~\"$0v\r?+2uUv"));
        var0 = null;
        stringArray[189] = LilyPondWriter.z(LilyPondWriter.z("'se\u001buL%0$u\r"));
        var0 = null;
        stringArray[190] = LilyPondWriter.z(LilyPondWriter.z("\r0*#~Iv190E7330L:)v~B\" %0Z?1>0Y3=\"<\r%*vgHv$%cX; vdE3<vq_3e:i_?&%"));
        var0 = null;
        stringArray[191] = LilyPondWriter.z(LilyPondWriter.z("$5*&i_?\">d\rket"));
        var0 = null;
        stringArray[192] = LilyPondWriter.z(LilyPondWriter.z("$5*;`B% $0\u0010vg"));
        var0 = null;
        stringArray[193] = LilyPondWriter.z(LilyPondWriter.z("$%04dD\")30\u0010vg"));
        var0 = null;
        stringArray[194] = LilyPondWriter.z(LilyPondWriter.z("$\"$1|D8 v-\rt"));
        var0 = null;
        stringArray[195] = LilyPondWriter.z(LilyPondWriter.z("\r~"));
        var0 = null;
        stringArray[196] = LilyPondWriter.z(LilyPondWriter.z("q> 7tH$e-"));
        var0 = null;
        stringArray[197] = LilyPondWriter.z(LilyPondWriter.z("$\",\"|Hvxv2"));
        var0 = null;
        stringArray[198] = LilyPondWriter.z(LilyPondWriter.z("$?+%d_#(3~Yvxv2"));
        var0 = null;
        stringArray[199] = LilyPondWriter.z(LilyPondWriter.z("Y3+9b"));
        var0 = null;
        stringArray[200] = LilyPondWriter.z(LilyPondWriter.z("O76%"));
        var0 = null;
        stringArray[201] = LilyPondWriter.z(LilyPondWriter.z("L:19"));
        var0 = null;
        stringArray[202] = LilyPondWriter.z(LilyPondWriter.z("Y$ 4|H"));
        var0 = null;
        stringArray[203] = LilyPondWriter.z(LilyPondWriter.z("]375e^%,9~"));
        var0 = null;
        stringArray[204] = LilyPondWriter.z(LilyPondWriter.z("'\n&:uKv"));
        var0 = null;
        stringArray[205] = LilyPondWriter.z(LilyPondWriter.z("'\n*\"dL $v3\u001d"));
        var0 = null;
        stringArray[206] = LilyPondWriter.z(LilyPondWriter.z("'\n*\"dL $v3\u0000g"));
        var0 = null;
        stringArray[207] = LilyPondWriter.z(LilyPondWriter.z("'\n*\"dL $v3\u001c"));
        var0 = null;
        stringArray[208] = LilyPondWriter.z(LilyPondWriter.z("r\n(7bF#5-0\r\n#9~Y%,,u\ruhb0\u000f"));
        var0 = null;
        stringArray[209] = LilyPondWriter.z(LilyPondWriter.z("\u000f+"));
        var0 = null;
        stringArray[210] = LilyPondWriter.z(LilyPondWriter.z("\u0011j"));
        var0 = null;
        stringArray[211] = LilyPondWriter.z(LilyPondWriter.z("\u0013h"));
        var0 = null;
        stringArray[212] = LilyPondWriter.z(LilyPondWriter.z("$\n+3g\r\u000517vKv\u0019"));
        var0 = null;
        stringArray[213] = LilyPondWriter.z(LilyPondWriter.z("\r\u000b"));
        var0 = null;
        stringArray[214] = LilyPondWriter.z(LilyPondWriter.z("q0#"));
        var0 = null;
        stringArray[215] = LilyPondWriter.z(LilyPondWriter.z("q&5"));
        var0 = null;
        stringArray[216] = LilyPondWriter.z(LilyPondWriter.z("q&5&"));
        var0 = null;
        stringArray[217] = LilyPondWriter.z(LilyPondWriter.z("q0#0"));
        var0 = null;
        stringArray[218] = LilyPondWriter.z(LilyPondWriter.z("q0"));
        var0 = null;
        stringArray[219] = LilyPondWriter.z(LilyPondWriter.z("q&"));
        var0 = null;
        stringArray[220] = LilyPondWriter.z(LilyPondWriter.z("q;#"));
        var0 = null;
        stringArray[221] = LilyPondWriter.z(LilyPondWriter.z("q;5"));
        var0 = null;
        stringArray[222] = LilyPondWriter.z(LilyPondWriter.z("\rvev0q$  u_\"e\u0005dH;eu7Y$$8c]773~Yv"));
        var0 = null;
        stringArray[223] = LilyPondWriter.z(LilyPondWriter.z("O:$8{^\" ;c\rke-0q933b_?!30~\" ;0\rub\"bL86&q_3+\"0\u0010vfud\r+"));
        var0 = null;
        stringArray[224] = LilyPondWriter.z(LilyPondWriter.z("\rvev0q933b_?!30~\" ;0\rub\"bL86&q_3+\"0\u0010vfud\r"));
        var0 = null;
        stringArray[225] = LilyPondWriter.z(LilyPondWriter.z("O:$8{C913c\rke-0q933b_?!30c913XH7!v0\u000eq1$qC%57bH81v-\ruf\""));
        var0 = null;
        stringArray[226] = LilyPondWriter.z(LilyPondWriter.z("\rvev0q933b_?!30\u007f36\"0\rub\"bL86&q_3+\"0\u0010vfud\r+"));
        var0 = null;
        stringArray[227] = LilyPondWriter.z(LilyPondWriter.z("X8':qC=6\"u@%ek0Vv\u0019$u[37\"0~\" ;0\u000eq1$qC%57bH81vm"));
        var0 = null;
        stringArray[228] = LilyPondWriter.z(LilyPondWriter.z("X8':qC=+9dH%ek0Vv\u0019$u[37\"0c913XH7!v3\n\"77~^&$$uC\""));
        var0 = null;
        stringArray[229] = LilyPondWriter.z(LilyPondWriter.z("\rvev0q$  u_\"e\u0004u^\"eu7Y$$8c]773~Yv8"));
        var0 = null;
        stringArray[230] = LilyPondWriter.z(LilyPondWriter.z("I?$;\u007fC2"));
        var0 = null;
        stringArray[231] = LilyPondWriter.z(LilyPondWriter.z("^:$%xc913xH7!"));
        var0 = null;
        stringArray[232] = LilyPondWriter.z(LilyPondWriter.z("X% 2e_{6{}D"));
        var0 = null;
        stringArray[233] = LilyPondWriter.z(LilyPondWriter.z("Y36\""));
        var0 = null;
        stringArray[234] = LilyPondWriter.z(LilyPondWriter.z("O:$5{y$,7~J: \u0018\u007fY3-3qI"));
        var0 = null;
        stringArray[235] = LilyPondWriter.z(LilyPondWriter.z("X% 2e_{!{tB\u0002-?~"));
        var0 = null;
        stringArray[236] = LilyPondWriter.z(LilyPondWriter.z("K?=3t\u0000%h5bB%6"));
        var0 = null;
        stringArray[237] = LilyPondWriter.z(LilyPondWriter.z("c9e2yJ?1%<\r%57sH%iveC2 $cN973c\u0001v*$0I76>u^v$:|B! 20D8e\u001ayA/59~Iv#?|H8$;u\u0017vg"));
        var0 = null;
        stringArray[238] = LilyPondWriter.z(LilyPondWriter.z("b\u000e\u000b9dH> 7t"));
        var0 = null;
        stringArray[239] = LilyPondWriter.z(LilyPondWriter.z("K?=3t\u0000%h.sD$&:u"));
        var0 = null;
        stringArray[240] = LilyPondWriter.z(LilyPondWriter.z("u\u0018*\"uE3$2"));
        var0 = null;
        stringArray[241] = LilyPondWriter.z(LilyPondWriter.z("X% 2e_{6{cA76>"));
        var0 = null;
        stringArray[242] = LilyPondWriter.z(LilyPondWriter.z("vv"));
        var0 = null;
        stringArray[243] = LilyPondWriter.z(LilyPondWriter.z("z$,\"yC1e&q_\"e0yA3e"));
        var0 = null;
        stringArray[244] = LilyPondWriter.z(LilyPondWriter.z("q$ ;\u007f[3\u0012?dE\u0002$10\u000eq65\u007f_3"));
        var0 = null;
        stringArray[245] = LilyPondWriter.z(LilyPondWriter.z("D86{"));
        C = stringArray;
        x = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "_", " "};
        var0 = null;
        B = LilyPondWriter.z(LilyPondWriter.z("l\u0014\u0006\u0012Uk\u0011\r\u001fZf\u001a\b\u0018_}\u0007\u0017\u0005Dx\u0000\u0012\u000eIw"));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x10);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 45;
                            break;
                        }
                        case 1: {
                            n7 = 86;
                            break;
                        }
                        case 2: {
                            n7 = 69;
                            break;
                        }
                        case 3: {
                            n7 = 86;
                            break;
                        }
                        default: {
                            n7 = 16;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

