/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.FieldInfo;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.MethodInfo;
import jode.decompiler.ClassDeclarer;
import jode.decompiler.Declarable;
import jode.decompiler.FieldAnalyzer;
import jode.decompiler.ImportHandler;
import jode.decompiler.LocalInfo;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.Options;
import jode.decompiler.OuterValues;
import jode.decompiler.ProgressListener;
import jode.decompiler.Scope;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.expr.ThisOperator;
import jode.flow.StructuredBlock;
import jode.flow.TransformConstructors;
import jode.type.MethodType;
import jode.type.Type;
import jode.util.SimpleSet;

public class ClassAnalyzer
implements Scope,
Declarable,
ClassDeclarer {
    private static double INITIALIZE_COMPLEXITY = 0.03;
    private static double STEP_COMPLEXITY = 0.03;
    private static int STRICTFP = 2048;
    static int serialnr = 0;
    ImportHandler imports;
    ClassInfo clazz;
    ClassDeclarer parent;
    ProgressListener progressListener;
    double methodComplexity = 0.0;
    double innerComplexity = 0.0;
    String name;
    StructuredBlock[] blockInitializers;
    FieldAnalyzer[] fields;
    MethodAnalyzer[] methods;
    ClassAnalyzer[] inners;
    int modifiers;
    TransformConstructors constrAna;
    MethodAnalyzer staticConstructor;
    MethodAnalyzer[] constructors;
    OuterValues outerValues;

    public final boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public final boolean isStrictFP() {
        return (this.modifiers & STRICTFP) != 0;
    }

    public FieldAnalyzer getField(int n) {
        return this.fields[n];
    }

    public int getFieldIndex(String string, Type type) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].getName().equals(string) && this.fields[n].getType().equals(type)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public MethodAnalyzer getMethod(String string, MethodType methodType) {
        int n = 0;
        while (n < this.methods.length) {
            if (this.methods[n].getName().equals(string) && this.methods[n].getType().equals(methodType)) {
                return this.methods[n];
            }
            ++n;
        }
        return null;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ClassDeclarer getParent() {
        return this.parent;
    }

    public void setParent(ClassDeclarer classDeclarer) {
        this.parent = classDeclarer;
    }

    public ClassInfo getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public OuterValues getOuterValues() {
        return this.outerValues;
    }

    public void addBlockInitializer(int n, StructuredBlock structuredBlock) {
        if (this.blockInitializers[n] == null) {
            this.blockInitializers[n] = structuredBlock;
        } else {
            this.blockInitializers[n].appendBlock(structuredBlock);
        }
    }

    public void initialize() {
        int n;
        FieldInfo[] fieldInfoArray = this.clazz.getFields();
        MethodInfo[] methodInfoArray = this.clazz.getMethods();
        InnerClassInfo[] innerClassInfoArray = this.clazz.getInnerClasses();
        if (fieldInfoArray == null) {
            return;
        }
        if ((Options.options & 2) != 0 && innerClassInfoArray != null) {
            Expression[] expressionArray = new Expression[]{new ThisOperator(this.clazz)};
            n = innerClassInfoArray.length;
            this.inners = new ClassAnalyzer[n];
            int n2 = 0;
            while (n2 < n) {
                ClassInfo classInfo = ClassInfo.forName(innerClassInfoArray[n2].inner);
                this.inners[n2] = new ClassAnalyzer(this, classInfo, this.imports, Modifier.isStatic(innerClassInfoArray[n2].modifiers) ? null : expressionArray);
                ++n2;
            }
        } else {
            this.inners = new ClassAnalyzer[0];
        }
        this.fields = new FieldAnalyzer[fieldInfoArray.length];
        this.methods = new MethodAnalyzer[methodInfoArray.length];
        this.blockInitializers = new StructuredBlock[fieldInfoArray.length + 1];
        int n3 = 0;
        while (n3 < fieldInfoArray.length) {
            this.fields[n3] = new FieldAnalyzer(this, fieldInfoArray[n3], this.imports);
            ++n3;
        }
        this.staticConstructor = null;
        Vector<MethodAnalyzer> vector = new Vector<MethodAnalyzer>();
        n = 0;
        while (n < this.methods.length) {
            this.methods[n] = new MethodAnalyzer(this, methodInfoArray[n], this.imports);
            if (this.methods[n].isConstructor()) {
                if (this.methods[n].isStatic()) {
                    this.staticConstructor = this.methods[n];
                } else {
                    vector.addElement(this.methods[n]);
                }
                if (this.methods[n].isStrictFP()) {
                    this.modifiers |= STRICTFP;
                }
            }
            this.methodComplexity += this.methods[n].getComplexity();
            ++n;
        }
        this.constructors = new MethodAnalyzer[vector.size()];
        vector.copyInto(this.constructors);
        n = 0;
        while (n < this.inners.length) {
            this.inners[n].initialize();
            this.innerComplexity += this.inners[n].getComplexity();
            ++n;
        }
    }

    public double getComplexity() {
        return this.methodComplexity + this.innerComplexity;
    }

    public void analyze(ProgressListener progressListener, double d, double d2) {
        double d3;
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.println("Class " + this.name);
        }
        double d4 = d2 / this.methodComplexity;
        if (progressListener != null) {
            progressListener.updateProgress(d, this.name);
        }
        this.imports.useClass(this.clazz);
        if (this.clazz.getSuperclass() != null) {
            this.imports.useClass(this.clazz.getSuperclass());
        }
        ClassInfo[] classInfoArray = this.clazz.getInterfaces();
        int n = 0;
        while (n < classInfoArray.length) {
            this.imports.useClass(classInfoArray[n]);
            ++n;
        }
        if (this.fields == null) {
            return;
        }
        this.constrAna = null;
        if (this.constructors.length > 0) {
            n = 0;
            while (n < this.constructors.length) {
                if (progressListener != null) {
                    d3 = this.constructors[n].getComplexity() * d4;
                    if (d3 > STEP_COMPLEXITY) {
                        this.constructors[n].analyze(progressListener, d, d3);
                    } else {
                        progressListener.updateProgress(d, this.name);
                        this.constructors[n].analyze(null, 0.0, 0.0);
                    }
                    d += d3;
                } else {
                    this.constructors[n].analyze(null, 0.0, 0.0);
                }
                ++n;
            }
            this.constrAna = new TransformConstructors(this, false, this.constructors);
            this.constrAna.removeSynthInitializers();
        }
        if (this.staticConstructor != null) {
            if (progressListener != null) {
                double d5 = this.staticConstructor.getComplexity() * d4;
                if (d5 > STEP_COMPLEXITY) {
                    this.staticConstructor.analyze(progressListener, d, d5);
                } else {
                    progressListener.updateProgress(d, this.name);
                    this.staticConstructor.analyze(null, 0.0, 0.0);
                }
                d += d5;
            } else {
                this.staticConstructor.analyze(null, 0.0, 0.0);
            }
        }
        if ((Options.options & 0x80) != 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2].analyze();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.methods.length) {
            if (!this.methods[n2].isConstructor()) {
                if (progressListener != null) {
                    d3 = this.methods[n2].getComplexity() * d4;
                    if (d3 > STEP_COMPLEXITY) {
                        this.methods[n2].analyze(progressListener, d, d3);
                    } else {
                        progressListener.updateProgress(d, this.methods[n2].getName());
                        this.methods[n2].analyze(null, 0.0, 0.0);
                    }
                    d += d3;
                } else {
                    this.methods[n2].analyze(null, 0.0, 0.0);
                }
            }
            ++n2;
        }
    }

    public void analyzeInnerClasses(ProgressListener progressListener, double d, double d2) {
        double d3 = d2 / this.innerComplexity;
        if ((Options.options & 0x80) != 0) {
            return;
        }
        int n = 0;
        while (n < this.inners.length) {
            if (progressListener != null) {
                double d4 = this.inners[n].getComplexity() * d3;
                if (d4 > STEP_COMPLEXITY) {
                    double d5 = d3 * this.inners[n].methodComplexity;
                    this.inners[n].analyze(progressListener, d, d5);
                    this.inners[n].analyzeInnerClasses(null, d + d5, d4 - d5);
                } else {
                    progressListener.updateProgress(d, this.inners[n].name);
                    this.inners[n].analyze(null, 0.0, 0.0);
                    this.inners[n].analyzeInnerClasses(null, 0.0, 0.0);
                }
                d += d4;
            } else {
                this.inners[n].analyze(null, 0.0, 0.0);
                this.inners[n].analyzeInnerClasses(null, 0.0, 0.0);
            }
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].analyzeInnerClasses();
            ++n;
        }
    }

    public void makeDeclaration(Set set) {
        if (this.constrAna != null) {
            this.constrAna.transform();
        }
        if (this.staticConstructor != null) {
            new TransformConstructors(this, true, new MethodAnalyzer[]{this.staticConstructor}).transform();
        }
        if ((Options.options & 0x80) != 0) {
            return;
        }
        int n = 0;
        while (n < this.fields.length) {
            this.fields[n].makeDeclaration(set);
            ++n;
        }
        n = 0;
        while (n < this.inners.length) {
            this.inners[n].makeDeclaration(set);
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].makeDeclaration(set);
            ++n;
        }
    }

    public void dumpDeclaration(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.dumpDeclaration(tabbedPrintWriter, null, 0.0, 0.0);
    }

    public void dumpDeclaration(TabbedPrintWriter tabbedPrintWriter, ProgressListener progressListener, double d, double d2) throws IOException {
        ClassInfo[] classInfoArray;
        String string;
        if (this.fields == null) {
            return;
        }
        tabbedPrintWriter.startOp(1, 0);
        int n = this.modifiers & ~(0x20 | STRICTFP);
        if (this.clazz.isInterface()) {
            n &= 0xFFFFFBFF;
        }
        if (this.parent instanceof MethodAnalyzer) {
            n &= 0xFFFFFFFD;
            if (this.name == null) {
                n &= 0xFFFFFFEF;
            }
        }
        if ((string = Modifier.toString(n)).length() > 0) {
            tabbedPrintWriter.print(string + " ");
        }
        if (this.isStrictFP()) {
            tabbedPrintWriter.print("strictfp ");
        }
        if (!this.clazz.isInterface()) {
            tabbedPrintWriter.print("class ");
        }
        tabbedPrintWriter.print(this.name);
        ClassInfo classInfo = this.clazz.getSuperclass();
        if (classInfo != null && classInfo != ClassInfo.javaLangObject) {
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" extends " + tabbedPrintWriter.getClassString(classInfo, 1));
        }
        if ((classInfoArray = this.clazz.getInterfaces()).length > 0) {
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(this.clazz.isInterface() ? " extends " : " implements ");
            tabbedPrintWriter.startOp(0, 1);
            int n2 = 0;
            while (n2 < classInfoArray.length) {
                if (n2 > 0) {
                    tabbedPrintWriter.print(", ");
                    tabbedPrintWriter.breakOp();
                }
                tabbedPrintWriter.print(tabbedPrintWriter.getClassString(classInfoArray[n2], 1));
                ++n2;
            }
            tabbedPrintWriter.endOp();
        }
        tabbedPrintWriter.println();
        tabbedPrintWriter.openBraceClass();
        tabbedPrintWriter.tab();
        this.dumpBlock(tabbedPrintWriter, progressListener, d, d2);
        tabbedPrintWriter.untab();
        tabbedPrintWriter.closeBraceClass();
    }

    public void dumpBlock(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.dumpBlock(tabbedPrintWriter, null, 0.0, 0.0);
    }

    public void dumpBlock(TabbedPrintWriter tabbedPrintWriter, ProgressListener progressListener, double d, double d2) throws IOException {
        double d3;
        double d4 = d2 / this.getComplexity();
        tabbedPrintWriter.pushScope(this);
        boolean bl = false;
        boolean bl2 = false;
        SimpleSet simpleSet = null;
        if ((Options.options & 0x80) != 0) {
            simpleSet = new SimpleSet();
        }
        int n = 0;
        while (n < this.fields.length) {
            if (this.blockInitializers[n] != null) {
                if (bl2) {
                    tabbedPrintWriter.println();
                }
                tabbedPrintWriter.openBrace();
                tabbedPrintWriter.tab();
                this.blockInitializers[n].dumpSource(tabbedPrintWriter);
                tabbedPrintWriter.untab();
                tabbedPrintWriter.closeBrace();
                bl2 = true;
                bl = true;
            }
            if ((Options.options & 0x80) != 0) {
                this.fields[n].analyze();
                this.fields[n].makeDeclaration(simpleSet);
            }
            if (!this.fields[n].skipWriting()) {
                if (bl) {
                    tabbedPrintWriter.println();
                }
                this.fields[n].dumpSource(tabbedPrintWriter);
                bl2 = true;
            }
            ++n;
        }
        if (this.blockInitializers[this.fields.length] != null) {
            if (bl2) {
                tabbedPrintWriter.println();
            }
            tabbedPrintWriter.openBrace();
            tabbedPrintWriter.tab();
            this.blockInitializers[this.fields.length].dumpSource(tabbedPrintWriter);
            tabbedPrintWriter.untab();
            tabbedPrintWriter.closeBrace();
            bl2 = true;
        }
        n = 0;
        while (n < this.inners.length) {
            if (bl2) {
                tabbedPrintWriter.println();
            }
            if ((Options.options & 0x80) != 0) {
                this.inners[n].analyze(null, 0.0, 0.0);
                this.inners[n].analyzeInnerClasses(null, 0.0, 0.0);
                this.inners[n].makeDeclaration(simpleSet);
            }
            if (progressListener != null) {
                d3 = this.inners[n].getComplexity() * d4;
                if (d3 > STEP_COMPLEXITY) {
                    this.inners[n].dumpSource(tabbedPrintWriter, progressListener, d, d3);
                } else {
                    progressListener.updateProgress(d, this.name);
                    this.inners[n].dumpSource(tabbedPrintWriter);
                }
                d += d3;
            } else {
                this.inners[n].dumpSource(tabbedPrintWriter);
            }
            bl2 = true;
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            if ((Options.options & 0x80) != 0) {
                if (!this.methods[n].isConstructor()) {
                    this.methods[n].analyze(null, 0.0, 0.0);
                }
                this.methods[n].analyzeInnerClasses();
                this.methods[n].makeDeclaration(simpleSet);
            }
            if (!this.methods[n].skipWriting()) {
                if (bl2) {
                    tabbedPrintWriter.println();
                }
                if (progressListener != null) {
                    d3 = this.methods[n].getComplexity() * d4;
                    progressListener.updateProgress(d, this.methods[n].getName());
                    this.methods[n].dumpSource(tabbedPrintWriter);
                    d += d3;
                } else {
                    this.methods[n].dumpSource(tabbedPrintWriter);
                }
                bl2 = true;
            }
            ++n;
        }
        tabbedPrintWriter.popScope();
        this.clazz.dropInfo(144);
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.dumpSource(tabbedPrintWriter, null, 0.0, 0.0);
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter, ProgressListener progressListener, double d, double d2) throws IOException {
        this.dumpDeclaration(tabbedPrintWriter, progressListener, d, d2);
        tabbedPrintWriter.println();
    }

    public void dumpJavaFile(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.dumpJavaFile(tabbedPrintWriter, null);
    }

    public void dumpJavaFile(TabbedPrintWriter tabbedPrintWriter, ProgressListener progressListener) throws IOException {
        this.imports.init(this.clazz.getName());
        LocalInfo.init();
        this.initialize();
        double d = 0.05;
        double d2 = 0.75 * this.methodComplexity / (this.methodComplexity + this.innerComplexity);
        this.analyze(progressListener, INITIALIZE_COMPLEXITY, d2);
        this.analyzeInnerClasses(progressListener, d += d2, 0.8 - d);
        this.makeDeclaration(new SimpleSet());
        this.imports.dumpHeader(tabbedPrintWriter);
        this.dumpSource(tabbedPrintWriter, progressListener, 0.8, 0.2);
        if (progressListener != null) {
            progressListener.updateProgress(1.0, this.name);
        }
    }

    public boolean isScopeOf(Object object, int n) {
        return this.clazz.equals(object) && n == 1;
    }

    public void makeNameUnique() {
        this.name = this.name + "_" + serialnr++ + "_";
    }

    public boolean conflicts(String string, int n) {
        return ClassAnalyzer.conflicts(this.clazz, string, n);
    }

    private static boolean conflicts(ClassInfo classInfo, String string, int n) {
        while (classInfo != null) {
            int n2;
            Object[] objectArray;
            if (n == 12 || n == 2) {
                objectArray = classInfo.getMethods();
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (((MethodInfo)objectArray[n2]).getName().equals(string)) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (n == 13 || n == 3 || n == 4) {
                objectArray = classInfo.getFields();
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (((FieldInfo)objectArray[n2]).getName().equals(string)) {
                        return true;
                    }
                    ++n2;
                }
            }
            if ((n == 1 || n == 4) && (objectArray = classInfo.getInnerClasses()) != null) {
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (((InnerClassInfo)objectArray[n2]).name.equals(string)) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (n == 13 || n == 12) {
                return false;
            }
            objectArray = classInfo.getInterfaces();
            n2 = 0;
            while (n2 < objectArray.length) {
                if (ClassAnalyzer.conflicts((ClassInfo)objectArray[n2], string, n)) {
                    return true;
                }
                ++n2;
            }
            classInfo = classInfo.getSuperclass();
        }
        return false;
    }

    public ClassAnalyzer getClassAnalyzer(ClassInfo classInfo) {
        if (classInfo == this.getClazz()) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.getParent().getClassAnalyzer(classInfo);
    }

    public ClassAnalyzer getInnerClassAnalyzer(String string) {
        int n = this.inners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.inners[n2].name.equals(string)) {
                return this.inners[n2];
            }
            ++n2;
        }
        return null;
    }

    public void fillDeclarables(Collection collection) {
        int n = 0;
        while (n < this.methods.length) {
            this.methods[n].fillDeclarables(collection);
            ++n;
        }
    }

    public void addClassAnalyzer(ClassAnalyzer classAnalyzer) {
        if (this.parent != null) {
            this.parent.addClassAnalyzer(classAnalyzer);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getClazz() + "]";
    }

    public ClassAnalyzer(ClassDeclarer classDeclarer, ClassInfo classInfo, ImportHandler importHandler, Expression[] expressionArray) {
        classInfo.loadInfo(127);
        this.parent = classDeclarer;
        this.clazz = classInfo;
        this.imports = importHandler;
        if (expressionArray != null) {
            this.outerValues = new OuterValues(this, expressionArray);
        }
        this.modifiers = classInfo.getModifiers();
        if (classDeclarer != null) {
            InnerClassInfo[] innerClassInfoArray = classInfo.getOuterClasses();
            if (innerClassInfoArray[0].outer == null || innerClassInfoArray[0].name == null ? classDeclarer instanceof ClassAnalyzer : !(classDeclarer instanceof ClassAnalyzer) || !((ClassAnalyzer)classDeclarer).clazz.getName().equals(innerClassInfoArray[0].outer) || innerClassInfoArray[0].name == null) {
                throw new AssertError("ClassInfo Attributes are inconsistent: " + classInfo.getName());
            }
            this.name = innerClassInfoArray[0].name;
            this.modifiers = innerClassInfoArray[0].modifiers;
        } else {
            this.name = classInfo.getName();
            int n = this.name.lastIndexOf(46);
            if (n >= 0) {
                this.name = this.name.substring(n + 1);
            }
        }
    }

    public ClassAnalyzer(ClassDeclarer classDeclarer, ClassInfo classInfo, ImportHandler importHandler) {
        this(classDeclarer, classInfo, importHandler, null);
    }

    public ClassAnalyzer(ClassInfo classInfo, ImportHandler importHandler) {
        this(null, classInfo, importHandler);
    }
}

