/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.mxjedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class MXJClassRefFrame
extends JFrame {
    JTree _ref;
    DefaultTreeModel _tree_model;
    private static final Color DEFAULT_COLOR = new Color(0xFFFFFF);

    public MXJClassRefFrame(Class c) {
        super(c.getName());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(c.getName());
        DefaultMutableTreeNode fields_node = new DefaultMutableTreeNode("fields");
        DefaultMutableTreeNode methods_node = new DefaultMutableTreeNode("methods");
        Method[] methods = c.getDeclaredMethods();
        Arrays.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((Method)o2).getName();
                String s2 = ((Method)o1).getName();
                return s2.compareTo(s1);
            }
        });
        StringBuffer info = new StringBuffer(32);
        Class<?>[] params = null;
        Class<?> return_type = null;
        Method m = null;
        int modifiers = 0;
        int the_meth_cnt = methods.length;
        for (int i = 0; i < methods.length; ++i) {
            m = methods[i];
            modifiers = m.getModifiers();
            if ((modifiers & 2) != 0 || m.getName().indexOf(36) != -1) {
                --the_meth_cnt;
                continue;
            }
            if ((modifiers & 1) != 0) {
                info.append("public ");
            }
            if ((modifiers & 8) != 0) {
                info.append("static ");
            }
            if ((modifiers & 0x400) != 0) {
                info.append("abstract ");
            }
            if ((modifiers & 0x100) != 0) {
                info.append("native ");
            }
            if ((modifiers & 4) != 0) {
                info.append("protected ");
            }
            if ((modifiers & 0x20) != 0) {
                info.append("synchronized ");
            }
            params = m.getParameterTypes();
            return_type = m.getReturnType();
            info.append(this._get_short_classname(return_type) + " ");
            info.append(m.getName() + "(");
            for (int p = 0; p < params.length; ++p) {
                info.append(this._get_short_classname(params[p]));
                if (p == params.length - 1) continue;
                info.append(",");
            }
            info.append(")");
            methods_node.add(new DefaultMutableTreeNode(info.toString()));
            info.setLength(0);
        }
        Field[] fields = c.getDeclaredFields();
        Class<?> field_type = null;
        int the_field_cnt = fields.length;
        for (int i = 0; i < fields.length; ++i) {
            field_type = fields[i].getType();
            modifiers = fields[i].getModifiers();
            if ((modifiers & 2) != 0 || fields[i].getName().indexOf(36) != -1) {
                --the_field_cnt;
                continue;
            }
            if ((modifiers & 1) != 0) {
                info.append("public ");
            }
            if ((modifiers & 8) != 0) {
                info.append("static ");
            }
            if ((modifiers & 4) != 0) {
                info.append("protected ");
            }
            if ((modifiers & 0x40) != 0) {
                info.append("volatile ");
            }
            if ((modifiers & 0x80) != 0) {
                info.append("transient ");
            }
            if ((modifiers & 0x10) != 0) {
                info.append("final ");
            }
            info.append(this._get_short_classname(field_type) + " ");
            info.append(fields[i].getName());
            fields_node.add(new DefaultMutableTreeNode(info.toString()));
            info.setLength(0);
        }
        if (the_field_cnt > 0) {
            root.add(fields_node);
        }
        if (the_meth_cnt > 0) {
            root.add(methods_node);
        }
        this._tree_model = new DefaultTreeModel(root);
        this._ref = new JTree(this._tree_model);
        JScrollPane p = new JScrollPane(this._ref);
        p.setBackground(DEFAULT_COLOR);
        this.getContentPane().add((Component)p, "Center");
        this._ref.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int keycode = evt.getKeyCode();
                int mod = evt.getModifiers();
                if (keycode == 87 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    MXJClassRefFrame.this.setVisible(false);
                    MXJClassRefFrame.this.dispose();
                }
            }
        });
        this.setDefaultCloseOperation(2);
        this.pack();
        this._ref.setBackground(DEFAULT_COLOR);
        this.setSize(300, 400);
        this.setVisible(true);
    }

    private String _get_short_classname(Class c) {
        int idx;
        String classname = c.getName();
        boolean is_array = false;
        if (classname.charAt(0) == '[') {
            switch (classname.charAt(1)) {
                case 'L': {
                    is_array = true;
                    break;
                }
                case 'Z': {
                    return "boolean[]";
                }
                case 'B': {
                    return "byte[]";
                }
                case 'C': {
                    return "char[]";
                }
                case 'S': {
                    return "short[]";
                }
                case 'I': {
                    return "int[]";
                }
                case 'J': {
                    return "long[]";
                }
                case 'F': {
                    return "float[]";
                }
                case 'D': {
                    return "double[]";
                }
            }
        }
        if ((idx = classname.lastIndexOf(46)) != -1) {
            classname = classname.substring(idx + 1, classname.length());
        }
        if (is_array) {
            classname = classname.substring(0, classname.length() - 1) + "[]";
        }
        return classname;
    }

    public static void main(String[] args) {
        String classname = args[0];
        try {
            Class<?> c = Class.forName(classname);
            new MXJClassRefFrame(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

