/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.flow.BreakableBlock;
import jode.flow.CaseBlock;
import jode.flow.EmptyBlock;
import jode.flow.FlowBlock;
import jode.flow.InstructionContainer;
import jode.flow.Jump;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;

public class SwitchBlock
extends InstructionContainer
implements BreakableBlock {
    static int serialno = 0;
    CaseBlock[] caseBlocks;
    VariableStack exprStack;
    VariableStack breakedStack;
    boolean isBreaked = false;
    String label = null;

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        int n = this.instr.getFreeOperandCount();
        if (n > 0) {
            this.exprStack = variableStack.peek(n);
            variableStack2 = variableStack.pop(n);
        } else {
            variableStack2 = variableStack;
        }
        VariableStack variableStack3 = variableStack2;
        int n2 = 0;
        while (n2 < this.caseBlocks.length) {
            if (variableStack3 != null) {
                variableStack2.merge(variableStack3);
            }
            variableStack3 = this.caseBlocks[n2].mapStackToLocal(variableStack2);
            ++n2;
        }
        if (variableStack3 != null) {
            this.mergeBreakedStack(variableStack3);
        }
        if (this.jump != null) {
            this.jump.stackMap = this.breakedStack;
            return null;
        }
        return this.breakedStack;
    }

    public void mergeBreakedStack(VariableStack variableStack) {
        if (this.breakedStack != null) {
            this.breakedStack.merge(variableStack);
        } else {
            this.breakedStack = variableStack;
        }
    }

    public void removePush() {
        if (this.exprStack != null) {
            this.instr = this.exprStack.mergeIntoExpression(this.instr);
        }
        super.removePush();
    }

    public StructuredBlock findCase(FlowBlock flowBlock) {
        int n = 0;
        while (n < this.caseBlocks.length) {
            if (this.caseBlocks[n].subBlock != null && this.caseBlocks[n].subBlock instanceof EmptyBlock && this.caseBlocks[n].subBlock.jump != null && this.caseBlocks[n].subBlock.jump.destination == flowBlock) {
                return this.caseBlocks[n].subBlock;
            }
            ++n;
        }
        return null;
    }

    public StructuredBlock prevCase(StructuredBlock structuredBlock) {
        int n = this.caseBlocks.length - 1;
        while (n >= 0) {
            if (this.caseBlocks[n].subBlock == structuredBlock) {
                --n;
                while (n >= 0) {
                    if (this.caseBlocks[n].subBlock != null) {
                        return this.caseBlocks[n].subBlock;
                    }
                    --n;
                }
            }
            --n;
        }
        return null;
    }

    public StructuredBlock getNextBlock(StructuredBlock structuredBlock) {
        int n = 0;
        while (n < this.caseBlocks.length - 1) {
            if (structuredBlock == this.caseBlocks[n]) {
                return this.caseBlocks[n + 1];
            }
            ++n;
        }
        return this.getNextBlock();
    }

    public FlowBlock getNextFlowBlock(StructuredBlock structuredBlock) {
        int n = 0;
        while (n < this.caseBlocks.length - 1) {
            if (structuredBlock == this.caseBlocks[n]) {
                return null;
            }
            ++n;
        }
        return this.getNextFlowBlock();
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.label != null) {
            tabbedPrintWriter.untab();
            tabbedPrintWriter.println(this.label + ":");
            tabbedPrintWriter.tab();
        }
        tabbedPrintWriter.print("switch (");
        this.instr.dumpExpression(0, tabbedPrintWriter);
        tabbedPrintWriter.print(")");
        tabbedPrintWriter.openBrace();
        int n = 0;
        while (n < this.caseBlocks.length) {
            this.caseBlocks[n].dumpSource(tabbedPrintWriter);
            ++n;
        }
        tabbedPrintWriter.closeBrace();
    }

    public StructuredBlock[] getSubBlocks() {
        return this.caseBlocks;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "switch_" + serialno++ + "_";
        }
        return this.label;
    }

    public void setBreaked() {
        this.isBreaked = true;
    }

    public boolean jumpMayBeChanged() {
        return !this.isBreaked && (this.caseBlocks[this.caseBlocks.length - 1].jump != null || this.caseBlocks[this.caseBlocks.length - 1].jumpMayBeChanged());
    }

    public SwitchBlock(Expression expression, int[] nArray, FlowBlock[] flowBlockArray) {
        super(expression);
        int n = flowBlockArray.length;
        FlowBlock flowBlock = flowBlockArray[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (flowBlockArray[n2] == flowBlock) {
                flowBlockArray[n2] = null;
                --n;
            }
            ++n2;
        }
        this.caseBlocks = new CaseBlock[n];
        FlowBlock flowBlock2 = null;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = 0;
            int n5 = 1;
            while (n5 < flowBlockArray.length) {
                if (flowBlockArray[n5] != null && (flowBlockArray[n4] == null || flowBlockArray[n5].getAddr() >= flowBlockArray[n4].getAddr())) {
                    n4 = n5;
                }
                ++n5;
            }
            n5 = n4 == nArray.length ? -1 : nArray[n4];
            this.caseBlocks[n3] = flowBlockArray[n4] == flowBlock2 ? new CaseBlock(n5) : new CaseBlock(n5, new Jump(flowBlockArray[n4]));
            this.caseBlocks[n3].outer = this;
            flowBlock2 = flowBlockArray[n4];
            flowBlockArray[n4] = null;
            if (n4 == nArray.length) {
                this.caseBlocks[n3].isDefault = true;
            }
            --n3;
        }
        this.caseBlocks[n - 1].isLastBlock = true;
        this.jump = null;
        this.isBreaked = false;
    }
}

