/*
 * Decompiled with CFR 0.152.
 */
package jode.type;

import java.util.Vector;
import jode.bytecode.ClassInfo;
import jode.type.ClassInterfacesType;
import jode.type.IntegerType;
import jode.type.RangeType;
import jode.type.ReferenceType;
import jode.type.Type;

public class ArrayType
extends ReferenceType {
    static final ClassInfo[] arrayIfaces = new ClassInfo[]{ClassInfo.forName("java.lang.Cloneable"), ClassInfo.forName("java.io.Serializable")};
    Type elementType;

    public Type getElementType() {
        return this.elementType;
    }

    public Type getSuperType() {
        if (this.elementType instanceof IntegerType) {
            return Type.tRange(Type.tObject, this);
        }
        return Type.tRange(Type.tObject, (ReferenceType)Type.tArray(this.elementType.getSuperType()));
    }

    public Type getSubType() {
        if (this.elementType instanceof IntegerType) {
            return this;
        }
        return Type.tArray(this.elementType.getSubType());
    }

    public Type getHint() {
        return Type.tArray(this.elementType.getHint());
    }

    public Type getCanonic() {
        return Type.tArray(this.elementType.getCanonic());
    }

    public Type createRangeType(ReferenceType referenceType) {
        if (referenceType.getTypeCode() == 9) {
            return Type.tArray(this.elementType.intersection(((ArrayType)referenceType).elementType));
        }
        if (referenceType.getTypeCode() == 10) {
            ClassInterfacesType classInterfacesType = (ClassInterfacesType)referenceType;
            if (classInterfacesType.clazz == null && ReferenceType.implementsAllIfaces(null, arrayIfaces, classInterfacesType.ifaces)) {
                return Type.tRange(classInterfacesType, this);
            }
        }
        return Type.tError;
    }

    public Type getSpecializedType(Type type) {
        if (type.getTypeCode() == 103) {
            type = ((RangeType)type).getBottom();
        }
        if (type == Type.tNull) {
            return this;
        }
        if (type.getTypeCode() == 9) {
            Type type2 = this.elementType.intersection(((ArrayType)type).elementType);
            return type2 != Type.tError ? Type.tArray(type2) : Type.tError;
        }
        if (type.getTypeCode() == 10) {
            ClassInterfacesType classInterfacesType = (ClassInterfacesType)type;
            if (classInterfacesType.clazz == null && ReferenceType.implementsAllIfaces(null, arrayIfaces, classInterfacesType.ifaces)) {
                return this;
            }
        }
        return Type.tError;
    }

    public Type getGeneralizedType(Type type) {
        if (type.getTypeCode() == 103) {
            type = ((RangeType)type).getTop();
        }
        if (type == Type.tNull) {
            return this;
        }
        if (type.getTypeCode() == 9) {
            Type type2 = this.elementType.intersection(((ArrayType)type).elementType);
            if (type2 != Type.tError) {
                return Type.tArray(type2);
            }
            return ClassInterfacesType.create(null, arrayIfaces);
        }
        if (type.getTypeCode() == 10) {
            ClassInterfacesType classInterfacesType = (ClassInterfacesType)type;
            if (ReferenceType.implementsAllIfaces(classInterfacesType.clazz, classInterfacesType.ifaces, arrayIfaces)) {
                return ClassInterfacesType.create(null, arrayIfaces);
            }
            if (classInterfacesType.clazz == null && ReferenceType.implementsAllIfaces(null, arrayIfaces, classInterfacesType.ifaces)) {
                return classInterfacesType;
            }
            Vector<ClassInfo> vector = new Vector<ClassInfo>();
            int n = 0;
            while (n < arrayIfaces.length) {
                if (classInterfacesType.clazz != null && arrayIfaces[n].implementedBy(classInterfacesType.clazz)) {
                    vector.addElement(arrayIfaces[n]);
                } else {
                    int n2 = 0;
                    while (n2 < classInterfacesType.ifaces.length) {
                        if (arrayIfaces[n].implementedBy(classInterfacesType.ifaces[n2])) {
                            vector.addElement(arrayIfaces[n]);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            Object[] objectArray = new ClassInfo[vector.size()];
            vector.copyInto(objectArray);
            return ClassInterfacesType.create(null, (ClassInfo[])objectArray);
        }
        return Type.tError;
    }

    public Type getCastHelper(Type type) {
        Type type2 = type.getHint();
        switch (type2.getTypeCode()) {
            case 9: {
                if (!this.elementType.isClassType() || !((ArrayType)type2).elementType.isClassType()) {
                    return Type.tObject;
                }
                Type type3 = this.elementType.getCastHelper(((ArrayType)type2).elementType);
                if (type3 != null) {
                    return Type.tArray(type3);
                }
                return null;
            }
            case 10: {
                ClassInterfacesType classInterfacesType = (ClassInterfacesType)type2;
                if (classInterfacesType.clazz == null && ReferenceType.implementsAllIfaces(null, arrayIfaces, classInterfacesType.ifaces)) {
                    return null;
                }
                return Type.tObject;
            }
            case 101: {
                return null;
            }
        }
        return Type.tObject;
    }

    public boolean isValidType() {
        return this.elementType.isValidType();
    }

    public boolean isClassType() {
        return true;
    }

    public String getTypeSignature() {
        return "[" + this.elementType.getTypeSignature();
    }

    public Class getTypeClass() throws ClassNotFoundException {
        return Class.forName("[" + this.elementType.getTypeSignature());
    }

    public String toString() {
        return this.elementType.toString() + "[]";
    }

    private static String pluralize(String string) {
        return string + (string.endsWith("s") || string.endsWith("x") || string.endsWith("sh") || string.endsWith("ch") ? "es" : "s");
    }

    public String getDefaultName() {
        if (this.elementType instanceof ArrayType) {
            return this.elementType.getDefaultName();
        }
        return ArrayType.pluralize(this.elementType.getDefaultName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.elementType.equals(this.elementType);
        }
        return false;
    }

    ArrayType(Type type) {
        super(9);
        this.elementType = type;
    }
}

