/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import jode.bytecode.ClassFormatException;
import jode.bytecode.ConstantPool;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;

public class GrowableConstantPool
extends ConstantPool {
    Hashtable entryToIndex = new Hashtable();
    boolean written;

    public final void grow(int n) {
        if (this.written) {
            throw new IllegalStateException("adding to written ConstantPool");
        }
        if (this.tags.length < n) {
            int n2 = Math.max(this.tags.length * 2, n);
            int[] nArray = new int[n2];
            System.arraycopy(this.tags, 0, nArray, 0, this.count);
            this.tags = nArray;
            nArray = new int[n2];
            System.arraycopy(this.indices1, 0, nArray, 0, this.count);
            this.indices1 = nArray;
            nArray = new int[n2];
            System.arraycopy(this.indices2, 0, nArray, 0, this.count);
            this.indices2 = nArray;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.constants, 0, objectArray, 0, this.count);
            this.constants = objectArray;
        }
    }

    private int putConstant(int n, Object object) {
        GrowableConstantPool growableConstantPool = this;
        if (growableConstantPool == null) {
            throw null;
        }
        Key key = growableConstantPool.new Key(n, object, 0);
        Integer n2 = (Integer)this.entryToIndex.get(key);
        if (n2 != null) {
            return n2;
        }
        int n3 = this.count;
        this.grow(this.count + 1);
        this.tags[n3] = n;
        this.constants[n3] = object;
        this.entryToIndex.put(key, new Integer(n3));
        ++this.count;
        return n3;
    }

    private int putLongConstant(int n, Object object) {
        GrowableConstantPool growableConstantPool = this;
        if (growableConstantPool == null) {
            throw null;
        }
        Key key = growableConstantPool.new Key(n, object, 0);
        Integer n2 = (Integer)this.entryToIndex.get(key);
        if (n2 != null) {
            return n2;
        }
        int n3 = this.count;
        this.grow(this.count + 2);
        this.tags[n3] = n;
        this.tags[n3 + 1] = -n;
        this.constants[n3] = object;
        this.entryToIndex.put(key, new Integer(n3));
        this.count += 2;
        return n3;
    }

    int putIndexed(int n, Object object, int n2, int n3) {
        GrowableConstantPool growableConstantPool = this;
        if (growableConstantPool == null) {
            throw null;
        }
        Key key = growableConstantPool.new Key(n, object, n3);
        Integer n4 = (Integer)this.entryToIndex.get(key);
        if (n4 != null) {
            int n5 = n4;
            this.indices1[n5] = n2;
            this.indices2[n5] = n3;
            return n5;
        }
        this.grow(this.count + 1);
        this.tags[this.count] = n;
        this.indices1[this.count] = n2;
        this.indices2[this.count] = n3;
        this.entryToIndex.put(key, new Integer(this.count));
        return this.count++;
    }

    public final int putUTF8(String string) {
        return this.putConstant(1, string);
    }

    public int putClassName(String string) {
        string = string.replace('.', '/');
        TypeSignature.checkTypeSig("L" + string + ";");
        return this.putIndexed(7, string, this.putUTF8(string), 0);
    }

    public int putClassType(String string) {
        TypeSignature.checkTypeSig(string);
        if (string.charAt(0) == 'L') {
            string = string.substring(1, string.length() - 1);
        } else if (string.charAt(0) != '[') {
            throw new IllegalArgumentException("wrong class type: " + string);
        }
        return this.putIndexed(7, string, this.putUTF8(string), 0);
    }

    public int putRef(int n, Reference reference) {
        String string = reference.getClazz();
        String string2 = reference.getType();
        if (n == 9) {
            TypeSignature.checkTypeSig(string2);
        } else {
            TypeSignature.checkMethodTypeSig(string2);
        }
        int n2 = this.putClassType(string);
        int n3 = this.putUTF8(reference.getName());
        int n4 = this.putUTF8(string2);
        int n5 = this.putIndexed(12, reference.getName(), n3, n4);
        return this.putIndexed(n, string, n2, n5);
    }

    public int putConstant(Object object) {
        int n;
        if (object instanceof String) {
            return this.putIndexed(8, object, this.putUTF8((String)object), 0);
        }
        if (object instanceof Integer) {
            n = 3;
        } else if (object instanceof Float) {
            n = 4;
        } else {
            throw new IllegalArgumentException("illegal constant " + object + " of type: " + object.getClass());
        }
        return this.putConstant(n, object);
    }

    public int putLongConstant(Object object) {
        int n;
        if (object instanceof Long) {
            n = 5;
        } else if (object instanceof Double) {
            n = 6;
        } else {
            throw new IllegalArgumentException("illegal long constant " + object + " of type: " + object.getClass());
        }
        return this.putLongConstant(n, object);
    }

    public int reserveConstant(Object object) {
        if (object instanceof String) {
            return this.putIndexed(8, object, -1, 0);
        }
        return this.putConstant(object);
    }

    public int reserveLongConstant(Object object) {
        return this.putLongConstant(object);
    }

    public int copyConstant(ConstantPool constantPool, int n) throws ClassFormatException {
        return this.putConstant(constantPool.getConstant(n));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.written = true;
        dataOutputStream.writeShort(this.count);
        int n = 1;
        while (n < this.count) {
            int n2 = this.tags[n];
            dataOutputStream.writeByte(n2);
            switch (n2) {
                case 7: {
                    dataOutputStream.writeShort(this.indices1[n]);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataOutputStream.writeShort(this.indices1[n]);
                    dataOutputStream.writeShort(this.indices2[n]);
                    break;
                }
                case 8: {
                    dataOutputStream.writeShort(this.indices1[n]);
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt((Integer)this.constants[n]);
                    break;
                }
                case 4: {
                    dataOutputStream.writeFloat(((Float)this.constants[n]).floatValue());
                    break;
                }
                case 5: {
                    dataOutputStream.writeLong((Long)this.constants[n]);
                    ++n;
                    break;
                }
                case 6: {
                    dataOutputStream.writeDouble((Double)this.constants[n]);
                    ++n;
                    break;
                }
                case 12: {
                    dataOutputStream.writeShort(this.indices1[n]);
                    dataOutputStream.writeShort(this.indices2[n]);
                    break;
                }
                case 1: {
                    dataOutputStream.writeUTF((String)this.constants[n]);
                    break;
                }
                default: {
                    throw new ClassFormatException("unknown constant tag");
                }
            }
            ++n;
        }
    }

    public GrowableConstantPool() {
        this.count = 1;
        this.tags = new int[128];
        this.indices1 = new int[128];
        this.indices2 = new int[128];
        this.constants = new Object[128];
        this.written = false;
    }

    private class Key {
        int tag;
        Object objData;
        int intData;

        public int hashCode() {
            return this.tag ^ this.objData.hashCode() ^ this.intData;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.tag == key.tag && this.intData == key.intData && this.objData.equals(key.objData);
            }
            return false;
        }

        public Key(int n, Object object, int n2) {
            this.tag = n;
            this.objData = object;
            this.intData = n2;
        }
    }
}

