/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.expr.BinaryOperator;
import jode.expr.ConstOperator;
import jode.expr.Expression;
import jode.expr.IIncOperator;
import jode.expr.LocalLoadOperator;
import jode.expr.NopOperator;
import jode.expr.Operator;
import jode.expr.PrePostFixOperator;
import jode.expr.StoreInstruction;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.type.Type;

public class CreatePrePostIncExpression {
    public static boolean transform(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        return CreatePrePostIncExpression.createLocalPrePostInc(instructionContainer, structuredBlock) || CreatePrePostIncExpression.createPostInc(instructionContainer, structuredBlock);
    }

    public static boolean createLocalPrePostInc(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        int n;
        boolean bl;
        LocalLoadOperator localLoadOperator;
        IIncOperator iIncOperator;
        if (!(structuredBlock.outer instanceof SequentialBlock) || !(structuredBlock.outer.getSubBlocks()[0] instanceof InstructionBlock)) {
            return false;
        }
        Expression expression = ((InstructionBlock)structuredBlock.outer.getSubBlocks()[0]).getInstruction();
        Expression expression2 = instructionContainer.getInstruction();
        if (expression instanceof IIncOperator && expression2 instanceof LocalLoadOperator) {
            iIncOperator = (IIncOperator)expression;
            localLoadOperator = (LocalLoadOperator)expression2;
            bl = false;
        } else if (expression instanceof LocalLoadOperator && expression2 instanceof IIncOperator) {
            localLoadOperator = (LocalLoadOperator)expression;
            iIncOperator = (IIncOperator)expression2;
            bl = true;
        } else {
            return false;
        }
        if (iIncOperator.getOperatorIndex() == 13) {
            n = 24;
        } else if (iIncOperator.getOperatorIndex() == 14) {
            n = 25;
        } else {
            return false;
        }
        if (iIncOperator.getValue() == -1) {
            n ^= 1;
        } else if (iIncOperator.getValue() != 1) {
            return false;
        }
        if (!iIncOperator.lvalueMatches(localLoadOperator)) {
            return false;
        }
        Type type = localLoadOperator.getType().intersection(Type.tUInt);
        iIncOperator.makeNonVoid();
        PrePostFixOperator prePostFixOperator = new PrePostFixOperator(type, n, iIncOperator.getLValue(), bl);
        instructionContainer.setInstruction(prePostFixOperator);
        instructionContainer.moveDefinitions(structuredBlock.outer, structuredBlock);
        structuredBlock.replace(structuredBlock.outer);
        return true;
    }

    public static boolean createPostInc(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        int n;
        if (!(instructionContainer.getInstruction() instanceof StoreInstruction)) {
            return false;
        }
        StoreInstruction storeInstruction = (StoreInstruction)instructionContainer.getInstruction();
        Expression expression = storeInstruction.getSubExpressions()[0];
        int n2 = expression.getFreeOperandCount();
        if (!(((Operator)expression).isFreeOperator() && storeInstruction.isVoid() && storeInstruction.getSubExpressions()[1] instanceof BinaryOperator)) {
            return false;
        }
        BinaryOperator binaryOperator = (BinaryOperator)storeInstruction.getSubExpressions()[1];
        if (binaryOperator.getSubExpressions() == null || !(binaryOperator.getSubExpressions()[0] instanceof NopOperator) || !(binaryOperator.getSubExpressions()[1] instanceof ConstOperator)) {
            return false;
        }
        ConstOperator constOperator = (ConstOperator)binaryOperator.getSubExpressions()[1];
        if (binaryOperator.getOperatorIndex() == 1) {
            n = 24;
        } else if (binaryOperator.getOperatorIndex() == 2) {
            n = 25;
        } else {
            return false;
        }
        if (!constOperator.isOne(expression.getType())) {
            return false;
        }
        if (!(structuredBlock.outer instanceof SequentialBlock)) {
            return false;
        }
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
        if (!(sequentialBlock.subBlocks[0] instanceof SpecialBlock)) {
            return false;
        }
        SpecialBlock specialBlock = (SpecialBlock)sequentialBlock.subBlocks[0];
        if (specialBlock.type != SpecialBlock.DUP || specialBlock.count != expression.getType().stackSize() || specialBlock.depth != n2) {
            return false;
        }
        if (!(sequentialBlock.outer instanceof SequentialBlock)) {
            return false;
        }
        sequentialBlock = (SequentialBlock)sequentialBlock.outer;
        if (!(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
            return false;
        }
        InstructionBlock instructionBlock = (InstructionBlock)sequentialBlock.subBlocks[0];
        if (!(instructionBlock.getInstruction() instanceof Operator) || !storeInstruction.lvalueMatches((Operator)instructionBlock.getInstruction())) {
            return false;
        }
        if (n2 > 0) {
            if (!(sequentialBlock.outer instanceof SequentialBlock)) {
                return false;
            }
            sequentialBlock = (SequentialBlock)sequentialBlock.outer;
            if (!(sequentialBlock.subBlocks[0] instanceof SpecialBlock)) {
                return false;
            }
            SpecialBlock specialBlock2 = (SpecialBlock)sequentialBlock.subBlocks[0];
            if (specialBlock2.type != SpecialBlock.DUP || specialBlock2.count != n2 || specialBlock2.depth != 0) {
                return false;
            }
        }
        instructionContainer.setInstruction(new PrePostFixOperator(expression.getType(), n, storeInstruction.getLValue(), true));
        instructionContainer.moveDefinitions(sequentialBlock, structuredBlock);
        structuredBlock.replace(sequentialBlock);
        return true;
    }
}

