/*
 * Decompiled with CFR 0.152.
 */
import decider.core.Decider;
import decider.drawing.ControlPanel;
import decider.drawing.SoundEventSliders;
import decider.play.DeciderAgent;
import decider.play.SoundEventUtil;
import decider.play.XSceneStaticLoad;
import java.util.ArrayList;
import my_sound_events_1.BreathSoundEvent;
import my_sound_events_2.BeatTwistSoundEvent;
import my_sound_events_2.ElasticKitSoundEvent;
import my_sound_events_2.NoiseMashSoundEvent;
import my_sound_events_2.StewKitSoundEvent;
import my_sound_events_3.CucinaReduxSoundEvent;
import my_sound_events_3.FMMash3SoundEvent;
import my_sound_events_3.PegPianoReduxSoundEvent;
import my_sound_events_3.PlainToneEvent;
import my_sound_events_3.PlainToneEvent2;
import my_sound_events_3.PotTapReduxSoundEvent;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.IOAudioFormat;
import net.beadsproject.beads.gui.AudioInputGUI;
import org.jaudiolibs.beads.AudioServerIO;

public class DeciderRunMain {
    public static void main(String[] args) throws InterruptedException {
        Class[] eventClasses;
        AudioContext ac = new AudioContext(new AudioServerIO.Jack(), 512, new IOAudioFormat(44100.0f, 16, 2, 2));
        ac.start();
        Thread.sleep(6000L);
        for (Class c : eventClasses = new Class[]{ElasticKitSoundEvent.class, StewKitSoundEvent.class, NoiseMashSoundEvent.class, BeatTwistSoundEvent.class, FMMash3SoundEvent.class, PlainToneEvent2.class, PlainToneEvent.class, PegPianoReduxSoundEvent.class, PotTapReduxSoundEvent.class, CucinaReduxSoundEvent.class}) {
            SoundEventUtil.eventFromClass(c);
        }
        BreathSoundEvent event = new BreathSoundEvent();
        XSceneStaticLoad s = new XSceneStaticLoad(eventClasses);
        Decider d = event.getPreferredDecider();
        System.out.println("NUM LEAVES: " + d.getNumLeaves());
        s.setDecider(d);
        s.getDecider().centerState();
        ArrayList extractors = new ArrayList();
        extractors.add(SpectralCentroid.class);
        extractors.add(Frequency.class);
        extractors.add(Power.class);
        extractors.add(MFCC.class);
        AudioInputGUI newGoo = AudioInputGUI.createAndShow(ac, extractors);
        DeciderAgent da = new DeciderAgent(s, ac.out, newGoo.getAnalyzer());
        ControlPanel.draw(da);
        SoundEventSliders.createAndShow(ac, eventClasses);
    }
}

