/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import decider.analytics.AudioDataSimulation;
import decider.analytics.DeciderSimulationStats;
import decider.core.Decider;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;

public class StudyResponses {
    public static final String home = "/Users/ollie";
    public static final String workingDir = "/Users/ollie/Dropbox/DLab/Publications/ACALCI2015/Study";
    public static final String audioFilePrefix = "/Users/ollie/Dropbox/DLab/Publications/ACALCI2015/Study/Tracks/track";
    public static final String audioFileSuffix = ".wav";
    static String statsData = "timeSteps nodes timeAtZero nodesVisited medianNumVisits maxNumVisits changeRatio numMinimallyShortHolds medianMaxGapLength traversalLinearity\n";
    public static final String deciderFilesDir = "/Users/ollie/Data/ACALCI/evolved deciders/dudes";
    public static final String outputDir = "/Users/ollie/Data/ACALCI/data";
    public static final String[] deciderFileNames = new String[]{"gen0", "gen100", "gen1000", "gen5000", "gen10000", "gen20000", "gen30000", "gen40000", "gen50000", "gen60000"};

    public static void main(String[] args) {
        StudyResponses.run();
    }

    public static void run() {
        for (String deciderFileName : deciderFileNames) {
            String deciderFile = "/Users/ollie/Data/ACALCI/evolved deciders/dudes/" + deciderFileName;
            String thisOutputDir = "/Users/ollie/Data/ACALCI/data/" + deciderFileName;
            new File(thisOutputDir).mkdir();
            Decider d = Decider.read(deciderFile);
            for (int i = 1; i < 7; ++i) {
                String filename = audioFilePrefix + i + audioFileSuffix;
                System.out.println("Running simulation with " + filename);
                System.out.println("----------------------------------");
                AudioDataSimulation adsSound = AudioDataSimulation.newUsingAudioFile(filename, 6);
                d.centerState();
                DeciderSimulationStats dss = adsSound.run(d);
                StudyResponses.writeAllData(thisOutputDir + "/sound_" + i, dss);
            }
            System.out.println("Running simulation with random data");
            System.out.println("----------------------------------");
            AudioDataSimulation adsRand = new AudioDataSimulation(new Random(), 200, 10000, 0.0f);
            d.centerState();
            DeciderSimulationStats dssRand = adsRand.run(d);
            StudyResponses.writeAllData(thisOutputDir + "/rand", dssRand);
            System.out.println("Running simulation with zero data");
            System.out.println("----------------------------------");
            AudioDataSimulation adsZero = new AudioDataSimulation(200, 10000, 0.0f, new float[10000][200]);
            d.centerState();
            DeciderSimulationStats dssZero = adsZero.run(d);
            StudyResponses.writeAllData(thisOutputDir + "/zero", dssZero);
        }
    }

    public static void writeAllData(String stubName, DeciderSimulationStats dss) {
        try {
            Dataset stateHistoryDataSet = dss.stateHistoryToDataSet();
            JFreeChart stateChart = ChartFactory.createXYLineChart("State History", "Time Step", "State Value", (XYDataset)stateHistoryDataSet);
            ChartUtilities.saveChartAsJPEG(new File(stubName + "_state.jpeg"), stateChart, 400, 300);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

