/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.apt;

import com.sun.mirror.apt.Messager;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.apt.mirror.util.SourcePositionImpl;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;

public class MessagerImpl
implements Messager {
    private final Bark bark;
    private static final Context.Key<MessagerImpl> messagerKey = new Context.Key();

    public static MessagerImpl instance(Context context) {
        MessagerImpl messagerImpl = context.get(messagerKey);
        if (messagerImpl == null) {
            messagerImpl = new MessagerImpl(context);
        }
        return messagerImpl;
    }

    private MessagerImpl(Context context) {
        context.put(messagerKey, this);
        this.bark = Bark.instance(context);
    }

    public void printError(String string) {
        this.bark.error(0, "Messager", string);
    }

    public void printError(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            Name name = this.bark.useSource(sourcePositionImpl.getName());
            this.bark.error(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(name);
        } else {
            this.printError(string);
        }
    }

    public void printWarning(String string) {
        this.bark.warning(0, "Messager", string);
    }

    public void printWarning(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            Name name = this.bark.useSource(sourcePositionImpl.getName());
            this.bark.warning(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(name);
        } else {
            this.printWarning(string);
        }
    }

    public void printNotice(String string) {
        this.bark.note("Messager", string);
    }

    public void printNotice(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            Name name = this.bark.useSource(sourcePositionImpl.getName());
            this.bark.note(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(name);
        } else {
            this.printNotice(string);
        }
    }
}

