/*
 * Decompiled with CFR 0.152.
 */
package decider.analytics;

import decider.analytics.DeciderSimulationStats;
import decider.core.Decider;
import decider.play.DeciderAgent;
import java.util.ArrayList;
import java.util.Random;
import net.beadsproject.beads.analysis.Analyzer;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.FeatureTrack;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.events.AudioContextStopTrigger;
import net.beadsproject.beads.ugens.SamplePlayer;

public class AudioDataSimulation {
    public float[][] simulationData;
    int stopAdaptingTime;

    public AudioDataSimulation(Random rng, int numInputs, int duration, float stopAdaptingTimeFract) {
        this.stopAdaptingTime = (int)((float)this.stopAdaptingTime * (float)duration);
        this.simulationData = AudioDataSimulation.randomData(rng, duration, numInputs);
    }

    public AudioDataSimulation(int numInputs, int duration, float stopAdaptingTimeFract, float[][] data) {
        this.stopAdaptingTime = (int)((float)this.stopAdaptingTime * (float)duration);
        this.simulationData = data;
    }

    public static float[][] randomData(Random rng, int length, int numInputs) {
        float[][] newData = new float[length][numInputs];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < numInputs; ++j) {
                newData[i][j] = rng.nextFloat();
            }
        }
        return newData;
    }

    public DeciderSimulationStats run(Decider d) {
        DeciderSimulationStats stats = new DeciderSimulationStats(d);
        d.centerState();
        d.setConsolidate(true);
        int length = this.simulationData.length;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < d.getNumInputs(); ++j) {
                d.setInputFract(j, this.simulationData[i][j]);
            }
            d.process();
            if (i == this.stopAdaptingTime) {
                d.setConsolidate(false);
            }
            if (i <= this.stopAdaptingTime) continue;
            stats.notifyNodeEvent(d.getCurrentLeaf());
        }
        stats.doStats();
        return stats;
    }

    public DeciderSimulationStats runRandomStartTime(Decider d) {
        DeciderSimulationStats stats = new DeciderSimulationStats(d);
        d.centerState();
        d.setConsolidate(true);
        int randomStartTime = (int)(Math.random() * (double)this.simulationData.length / 2.0);
        int length = this.simulationData.length / 2;
        for (int i = randomStartTime; i < randomStartTime + length; ++i) {
            for (int j = 0; j < d.getNumInputs(); ++j) {
                d.setInputFract(j, this.simulationData[i][j]);
            }
            d.process();
            if (i == this.stopAdaptingTime) {
                d.setConsolidate(false);
            }
            if (i <= this.stopAdaptingTime) continue;
            stats.notifyNodeEvent(d.getCurrentLeaf());
        }
        stats.doStats();
        return stats;
    }

    public static AudioDataSimulation newUsingAudioFile(String string, int numInputs) {
        try {
            Sample s = new Sample(string);
            AudioContext ac = new AudioContext();
            ArrayList extractors = new ArrayList();
            extractors.add(SpectralCentroid.class);
            extractors.add(Frequency.class);
            extractors.add(Power.class);
            extractors.add(MFCC.class);
            Analyzer a = new Analyzer(ac, extractors);
            SamplePlayer sp = new SamplePlayer(ac, s);
            a.listenTo(sp);
            a.updateFrom(ac.out);
            sp.setKillListener(new AudioContextStopTrigger(ac));
            ac.runNonRealTime();
            FeatureTrack features = a.getResults().get("Low Level");
            int count = 0;
            int length = features.getNumberOfFrames();
            float[][] simulationData = new float[length][numInputs];
            for (FeatureFrame ff : features) {
                DeciderAgent.getInputDataFromFeatures(ff, simulationData[count]);
                for (int i = 0; i < simulationData[count].length; ++i) {
                }
                ++count;
            }
            AudioDataSimulation ads = new AudioDataSimulation(6, length, 0.0f, simulationData);
            return ads;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

