/*
 * Decompiled with CFR 0.152.
 */
package decider.analytics;

import decider.core.Decider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DeciderSimulationStats {
    Map<Integer, ArrayList<Integer>> nodeVisitTimes;
    ArrayList<Integer> nodeAtTime;
    Map<Integer, Integer> holdLengthHistogram;
    public List<float[]> stateHistory = new ArrayList<float[]>();
    Decider decider;
    DeciderSimulationStatsData data = new DeciderSimulationStatsData();

    public DeciderSimulationStats(Decider d) {
        this.decider = d;
        this.nodeVisitTimes = new Hashtable<Integer, ArrayList<Integer>>();
        this.nodeAtTime = new ArrayList();
        this.data.timeStepsRun = 0;
    }

    protected void notifyNodeEvent(int node) {
        ArrayList<Integer> visitTimes = this.nodeVisitTimes.get(node);
        if (visitTimes == null) {
            visitTimes = new ArrayList();
            this.nodeVisitTimes.put(node, visitTimes);
        }
        visitTimes.add(this.data.timeStepsRun);
        this.nodeAtTime.add(node);
        float[] state = new float[this.decider.getNumHiddenElements()];
        for (int i = 0; i < this.decider.getNumHiddenElements(); ++i) {
            state[i] = this.decider.getStateFract(i);
        }
        this.stateHistory.add(state);
        ++this.data.timeStepsRun;
    }

    public void doStats() {
        int i;
        this.data.nodesVisited = this.nodeVisitTimes.size();
        this.data.timeAtZeroNode = 0.0f;
        if (this.nodeVisitTimes.containsKey(0)) {
            this.data.timeAtZeroNode = (float)this.nodeVisitTimes.get(0).size() / (float)this.data.timeStepsRun;
        }
        int[] visitCounts = new int[(int)this.data.nodesVisited];
        int index = 0;
        for (ArrayList<Integer> visitCount : this.nodeVisitTimes.values()) {
            visitCounts[index++] = visitCount.size();
        }
        Arrays.sort(visitCounts);
        this.data.medianNumVisits = visitCounts[visitCounts.length / 2];
        this.data.maxNumVisits = visitCounts[visitCounts.length - 1];
        int lastNode = 0;
        int changeCount = 0;
        int currentStateLength = 0;
        this.holdLengthHistogram = new TreeMap<Integer, Integer>();
        for (int i2 : this.nodeAtTime) {
            if (i2 != lastNode) {
                ++changeCount;
                lastNode = i2;
                if (currentStateLength != 0) {
                    int currentCount = 0;
                    if (this.holdLengthHistogram.containsKey(currentStateLength)) {
                        currentCount = this.holdLengthHistogram.get(currentStateLength);
                    }
                    this.holdLengthHistogram.put(currentStateLength, currentCount + 1);
                }
                currentStateLength = 1;
                continue;
            }
            ++currentStateLength;
        }
        int currentCount = 0;
        if (this.holdLengthHistogram.containsKey(currentStateLength)) {
            currentCount = this.holdLengthHistogram.get(currentStateLength);
        }
        this.holdLengthHistogram.put(currentStateLength, currentCount + 1);
        this.data.changeRatio = (float)changeCount / (float)this.data.timeStepsRun;
        this.data.numMinimallyShortHolds = 0.0f;
        if (this.holdLengthHistogram.containsKey(1)) {
            this.data.numMinimallyShortHolds = this.holdLengthHistogram.get(1).intValue();
        }
        Hashtable<Integer, ArrayList<Integer>> gapsBetweenVisits = new Hashtable<Integer, ArrayList<Integer>>();
        Hashtable<Integer, Integer> lastTimeVisited = new Hashtable<Integer, Integer>();
        int time = 0;
        this.data.traversalLinearity = 0.0f;
        for (int i3 : this.nodeAtTime) {
            int gapLength = time;
            if (lastTimeVisited.containsKey(i3)) {
                gapLength = time - (Integer)lastTimeVisited.get(i3);
            }
            if (gapLength > 1) {
                ArrayList<Integer> gapsForIndex = (ArrayList<Integer>)gapsBetweenVisits.get(i3);
                if (gapsForIndex == null) {
                    gapsForIndex = new ArrayList<Integer>();
                    gapsBetweenVisits.put(i3, gapsForIndex);
                }
                gapsForIndex.add(gapLength);
            }
            lastTimeVisited.put(i3, time);
            float nodeAsFract = (float)i3 / (float)this.decider.getNumLeaves();
            float timeAsFract = (float)time / (float)this.data.timeStepsRun;
            this.data.traversalLinearity = (float)((double)this.data.traversalLinearity + Math.pow(1.0f - Math.abs(nodeAsFract - timeAsFract) / 2.0f, 2.0));
            ++time;
        }
        this.data.traversalLinearity /= (float)this.nodeAtTime.size();
        if (gapsBetweenVisits.size() == 0) {
            this.data.medianMaxGapLength = 0.0f;
        } else {
            int[] maxGapLengths = new int[gapsBetweenVisits.size()];
            int next = 0;
            for (ArrayList gapList : gapsBetweenVisits.values()) {
                int max = 0;
                Iterator iterator = gapList.iterator();
                while (iterator.hasNext()) {
                    int i4 = (Integer)iterator.next();
                    if (i4 <= max) continue;
                    max = i4;
                }
                maxGapLengths[next++] = max;
            }
            Arrays.sort(maxGapLengths);
            this.data.medianMaxGapLength = maxGapLengths[maxGapLengths.length / 2];
        }
        int states = 10;
        double[][] prob = new double[states][states];
        int count = this.nodeAtTime.size() - 1;
        for (i = 0; i < count; ++i) {
            int n1 = this.nodeAtTime.get(i) % states;
            int n2 = this.nodeAtTime.get(i + 1) % states;
            double[] dArray = prob[n1];
            int n = n2;
            dArray[n] = dArray[n] + 1.0 / (double)count;
        }
        this.data.entropy = 0.0f;
        for (i = 0; i < states; ++i) {
            for (int j = 0; j < states; ++j) {
                if (prob[i][j] == 0.0) continue;
                this.data.entropy = (float)((double)this.data.entropy - prob[i][j] * Math.log(prob[i][j]));
            }
        }
    }

    public void printStats() {
        System.out.println("Time Steps          : " + this.data.timeStepsRun);
        System.out.println("Num nodes           : " + this.decider.getNumLeaves());
        System.out.println("Time at zero        : " + this.data.timeAtZeroNode);
        System.out.println("Nodes visited       : " + this.data.nodesVisited + " (" + this.data.nodesVisited / (float)this.decider.getNumLeaves() + ")");
        System.out.println("Median num visits   : " + this.data.medianNumVisits);
        System.out.println("Maximum num visits  : " + this.data.maxNumVisits + " (" + this.data.maxNumVisits / (float)this.data.timeStepsRun + ")");
        System.out.println("Change ratio        : " + this.data.changeRatio);
        System.out.println("Num short holds     : " + this.data.numMinimallyShortHolds + " (" + this.data.numMinimallyShortHolds / (float)this.data.timeStepsRun + ")");
        System.out.println("Median max gap      : " + this.data.medianMaxGapLength + " (" + this.data.medianMaxGapLength / (float)this.data.timeStepsRun + ")");
        System.out.println("Traversal linearity : " + this.data.medianMaxGapLength + " (" + this.data.medianMaxGapLength / (float)this.data.timeStepsRun + ")");
        System.out.println("Entropy             : " + this.data.entropy);
    }

    public String stateHistoryToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        int t = 0;
        for (float[] state : this.stateHistory) {
            for (int i = 0; i < state.length; ++i) {
                buff.append(state[i] + " ");
            }
            ++t;
            buff.append("\n");
        }
        return buff.toString();
    }

    public Dataset stateHistoryToDataSet() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        int numSeries = this.stateHistory.get(0).length;
        XYSeries[] series = new XYSeries[numSeries];
        for (int i = 0; i < series.length; ++i) {
            series[i] = new XYSeries((Comparable)((Object)("State " + i)));
            dataset.addSeries(series[i]);
        }
        int t = 0;
        for (float[] state : this.stateHistory) {
            for (int i = 0; i < state.length; ++i) {
                series[i].add((double)t, state[i]);
            }
            ++t;
        }
        return dataset;
    }

    public String decisionHistoryToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        boolean t = false;
        for (int x : this.nodeAtTime) {
            buff.append(x + " \n");
        }
        return buff.toString();
    }

    public String statsToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.data.timeStepsRun + " ");
        buff.append(this.decider.getNumLeaves() + " ");
        buff.append(this.data.timeAtZeroNode + " ");
        buff.append(this.data.nodesVisited + " ");
        buff.append(this.data.medianNumVisits + " ");
        buff.append(this.data.maxNumVisits + " ");
        buff.append(this.data.changeRatio + " ");
        buff.append(this.data.numMinimallyShortHolds + " ");
        buff.append(this.data.medianMaxGapLength + " ");
        buff.append(this.data.traversalLinearity);
        buff.append("\n");
        return buff.toString();
    }

    public String holdLengthHistogramToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        for (int key : this.holdLengthHistogram.keySet()) {
            int val = this.holdLengthHistogram.get(key);
            buff.append(key + " " + val + "\n");
        }
        return buff.toString();
    }

    public void printHoldLengthHistogram() {
        System.out.println("--- hold lengths -----");
        int sum = 0;
        for (int holdLength : this.holdLengthHistogram.keySet()) {
            int count = this.holdLengthHistogram.get(holdLength);
            System.out.println(holdLength + " " + count);
            sum += holdLength * count;
        }
        System.out.println("Sum: " + sum);
        System.out.println("----------------------");
    }

    public static DeciderSimulationStatsData average(List<DeciderSimulationStatsData> list) {
        DeciderSimulationStatsData average = new DeciderSimulationStatsData();
        for (DeciderSimulationStatsData dss : list) {
            average.changeRatio += dss.changeRatio;
            average.maxNumVisits += dss.maxNumVisits;
            average.medianNumVisits += dss.medianNumVisits;
            average.nodesVisited += dss.nodesVisited;
            average.numMinimallyShortHolds += dss.numMinimallyShortHolds;
            average.timeAtZeroNode += dss.timeAtZeroNode;
            average.timeStepsRun += dss.timeStepsRun;
        }
        int size = list.size();
        average.changeRatio /= (float)size;
        average.maxNumVisits /= (float)size;
        average.medianNumVisits /= (float)size;
        average.nodesVisited /= (float)size;
        average.numMinimallyShortHolds /= (float)size;
        average.timeAtZeroNode /= (float)size;
        average.timeStepsRun /= size;
        return average;
    }

    public DeciderSimulationStatsData getData() {
        return this.data;
    }

    public int getTimeStepsRun() {
        return this.data.timeStepsRun;
    }

    public float getTimeAtZeroNode() {
        return this.data.timeAtZeroNode;
    }

    public float getNodesVisited() {
        return this.data.nodesVisited;
    }

    public float getMedianNumVisits() {
        return this.data.medianNumVisits;
    }

    public float getMaxNumVisits() {
        return this.data.maxNumVisits;
    }

    public float getNumMinimallyShortHolds() {
        return this.data.numMinimallyShortHolds;
    }

    public float getChangeRatio() {
        return this.data.changeRatio;
    }

    public float getMedianMaxGapLength() {
        return this.data.medianMaxGapLength;
    }

    public float getTraversalLinearity() {
        return this.data.traversalLinearity;
    }

    public static class DeciderSimulationStatsData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int timeStepsRun;
        public float timeAtZeroNode;
        public float nodesVisited;
        public float medianNumVisits;
        public float maxNumVisits;
        public float numMinimallyShortHolds;
        public float changeRatio;
        public float medianMaxGapLength;
        public float traversalLinearity;
        public float entropy;
    }
}

