/*
 * Decompiled with CFR 0.152.
 */
package decider.core;

import decider.core.Condition;
import decider.core.Decider;
import decider.core.Leaf;
import decider.core.Operation;
import decider.core.Process;
import java.util.ArrayList;

public class ProcessArray
extends Leaf {
    private static final long serialVersionUID = 1L;
    private ArrayList<Operation> operations = new ArrayList();

    public ProcessArray(Decider d) {
        super(d);
    }

    @Override
    protected void process() {
        super.process();
        for (Operation p : this.operations) {
            p.process();
        }
    }

    static ProcessArray newRandom(Decider d) {
        ProcessArray pa = new ProcessArray(d);
        int numProcesses = d.rng.nextInt(50);
        for (int i = 0; i < numProcesses; ++i) {
            pa.operations.add(Process.newRandom(d));
        }
        return pa;
    }

    @Override
    protected void resetCounts() {
        super.resetCounts();
        for (Operation p : this.operations) {
            p.resetCounts();
        }
    }

    public void addOperation(Operation o) {
        this.operations.add(o);
    }

    @Override
    protected Operation copyMutate(Decider newDecider) {
        if (this.decider.prob(0.8f)) {
            return this.copy(newDecider);
        }
        if (this.decider.prob(0.05f)) {
            return Condition.newRandom(newDecider, this.decider.randomIndex(), this.copyMutateNoSplit(newDecider), this.copyMutateNoSplit(newDecider));
        }
        return this.copyMutateNoSplit(newDecider);
    }

    protected Operation copyMutateNoSplit(Decider newDecider) {
        ProcessArray copy = new ProcessArray(newDecider);
        for (Operation o : this.operations) {
            if (this.decider.prob(0.5f)) {
                copy.addOperation(o.copyMutate(newDecider));
                continue;
            }
            copy.addOperation(o.copy(newDecider));
        }
        return copy;
    }

    @Override
    protected Operation copy(Decider newDecider) {
        ProcessArray copy = new ProcessArray(newDecider);
        for (Operation o : this.operations) {
            copy.addOperation(o.copy(newDecider));
        }
        return copy;
    }
}

