/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.drawing.SceneDrawer;
import decider.play.DeciderSoundEvent;
import decider.play.Scene;
import decider.play.SplitScene;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import my_sound_events_1.StringResSoundEvent;

public class SplitSceneDrawerCompact
extends SceneDrawer {
    private static final long serialVersionUID = 1L;
    SplitScene s;
    float selectedSource = -1.0f;
    float selectedCurrent;
    JComponent eventSplit;
    boolean narrow;
    private static final Font font = new Font("courier", 0, 9);

    public SplitSceneDrawerCompact(SplitScene ss) {
        this(ss, false);
    }

    public SplitSceneDrawerCompact(SplitScene ss, boolean nnarrow) {
        this.s = ss;
        this.narrow = nnarrow;
        this.setLayout(new BoxLayout(this, 1));
        JComponent header = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.black);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                if (SplitSceneDrawerCompact.this.s.getName() != null) {
                    g.setFont(font);
                    g.drawString(SplitSceneDrawerCompact.this.s.getName(), 5, 10);
                }
            }
        };
        Dimension d = new Dimension(this.narrow ? 30 : 100, 50);
        header.setMinimumSize(d);
        header.setPreferredSize(d);
        header.setMaximumSize(d);
        this.add(header);
        this.eventSplit = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                float[] range = SplitSceneDrawerCompact.this.s.getLastSelectedRange();
                if (range != null) {
                    g.setColor(Color.lightGray);
                    g.fillRect(0, (int)(range[0] * (float)this.getHeight()), this.getWidth(), (int)((range[1] - range[0]) * (float)this.getHeight()));
                }
                g.setColor(Color.black);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setFont(font);
                for (float f : SplitSceneDrawerCompact.this.s.intervals()) {
                    int y = (int)(f * (float)this.getHeight());
                    g.drawLine(0, y, this.getWidth(), y);
                    g.drawString(SplitSceneDrawerCompact.this.s.getEventName(f), 5, y - 5);
                }
                if (SplitSceneDrawerCompact.this.selectedSource != -1.0f) {
                    g.setColor(Color.red);
                    int y = (int)(SplitSceneDrawerCompact.this.selectedCurrent * (float)this.getHeight());
                    g.drawLine(0, y, this.getWidth(), y);
                }
            }
        };
        this.eventSplit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplitSceneDrawerCompact.this.selectedSource = -1.0f;
                float fract = (float)e.getY() / (float)SplitSceneDrawerCompact.this.eventSplit.getHeight();
                if (e.getClickCount() > 1) {
                    SplitSceneDrawerCompact.this.s.addEvent(fract, StringResSoundEvent.class);
                } else if ((e.getModifiers() & 2) != 0 || e.getButton() != 1) {
                    JPopupMenu menu = SplitSceneDrawerCompact.this.createMenu(e, null);
                    menu.show(SplitSceneDrawerCompact.this.eventSplit, e.getX(), e.getY());
                } else {
                    for (float f : SplitSceneDrawerCompact.this.s.intervals()) {
                        if (!(Math.abs(f - fract) < 0.005f)) continue;
                        SplitSceneDrawerCompact.this.selectedSource = f;
                        SplitSceneDrawerCompact.this.selectedCurrent = f;
                        break;
                    }
                }
                SplitSceneDrawerCompact.this.eventSplit.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SplitSceneDrawerCompact.this.selectedSource != -1.0f) {
                    float fract = (float)e.getY() / (float)SplitSceneDrawerCompact.this.eventSplit.getHeight();
                    SplitSceneDrawerCompact.this.s.moveEvent(SplitSceneDrawerCompact.this.selectedSource, fract);
                }
                SplitSceneDrawerCompact.this.selectedSource = -1.0f;
            }
        });
        this.eventSplit.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                SplitSceneDrawerCompact.this.selectedCurrent = (float)e.getY() / (float)SplitSceneDrawerCompact.this.eventSplit.getHeight();
                if (SplitSceneDrawerCompact.this.selectedCurrent > 1.0f) {
                    SplitSceneDrawerCompact.this.selectedCurrent = 1.0f;
                }
                if (SplitSceneDrawerCompact.this.selectedCurrent < 0.0f) {
                    SplitSceneDrawerCompact.this.selectedCurrent = 0.0f;
                }
            }
        });
        this.add(this.eventSplit);
        Dimension dim = new Dimension(this.narrow ? 30 : 100, 400);
        this.eventSplit.setMinimumSize(dim);
        this.eventSplit.setPreferredSize(dim);
        this.eventSplit.setMaximumSize(dim);
    }

    private JPopupMenu createMenu(final MouseEvent e, Class<? extends DeciderSoundEvent>[] eventClasses) {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        Class<? extends DeciderSoundEvent>[] classArray = eventClasses;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<? extends DeciderSoundEvent> cclass;
            final Class<? extends DeciderSoundEvent> ccclass = cclass = classArray[i];
            item = new JMenuItem(cclass.getSimpleName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    float fract = (float)e.getY() / (float)SplitSceneDrawerCompact.this.eventSplit.getHeight();
                    SplitSceneDrawerCompact.this.s.replaceEvent(fract, ccclass);
                }
            });
            menu.add(item);
        }
        item = new JMenuItem("Remove event");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                float fract = (float)e.getY() / (float)SplitSceneDrawerCompact.this.eventSplit.getHeight();
                SplitSceneDrawerCompact.this.s.removeEvent(fract);
            }
        });
        menu.addSeparator();
        menu.add(item);
        return menu;
    }

    @Override
    public void setScene(Scene s) {
        this.s = (SplitScene)s;
    }
}

