/*
 * Decompiled with CFR 0.152.
 */
package decider.drawing;

import decider.core.Condition;
import decider.core.Decider;
import decider.core.Operation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TreeDrawer
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Decider d;
    private int xSpacing;

    public TreeDrawer(Decider dd) {
        this.d = dd;
        Dimension dim = new Dimension(300, 400);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.xSpacing = 30;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() > 10 && e.getX() < 20 && e.getY() > 10 && e.getY() < 20) {
                    TreeDrawer.this.d.setConsolidate(!TreeDrawer.this.d.isConsolidate());
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawOperation(g, this.d.getRoot(), 0, 20, this.getHeight() / 2);
        g.setColor(Color.black);
        g.drawString("" + this.d.getUsageCount(), 30, 20);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.d.isConsolidate()) {
            g.setColor(Color.lightGray);
            g.fillRect(10, 10, 10, 10);
        }
        g.setColor(Color.black);
        g.drawRect(10, 10, 10, 10);
        g.drawString("" + this.d.getCurrentLeaf(), 60, 20);
    }

    private void drawOperation(Graphics g, Operation op, int depth, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (depth > 8) {
            return;
        }
        if (op.getRecentUsageCount() > 0) {
            g.setColor(Color.lightGray);
            g.fillRect(x - 5, y - 5, 10, 10);
        }
        float usage = this.usageCalc(op.getUsageCount());
        g.setColor(new Color(usage, usage, usage));
        g.drawRect(x - 5, y - 5, 10, 10);
        if (op instanceof Condition) {
            Condition c = (Condition)op;
            int updown = this.getHeight() / (int)Math.pow(2.0, depth + 2);
            this.drawOperation(g, c.getYesOperation(), depth + 1, x + this.xSpacing, y - updown);
            this.drawOperation(g, c.getNoOperation(), depth + 1, x + this.xSpacing, y + updown);
            usage = this.usageCalc(c.getYesOperation().getUsageCount());
            g.setColor(new Color(usage, usage, usage));
            g.drawLine(x, y, x + this.xSpacing, y - updown);
            usage = this.usageCalc(c.getNoOperation().getUsageCount());
            g.setColor(new Color(usage, usage, usage));
            g.drawLine(x, y, x + this.xSpacing, y + updown);
        }
    }

    private float usageCalc(int x) {
        if (this.d.getUsageCount() == 0) {
            return 0.9f;
        }
        float usage = 0.9f - (float)Math.pow((float)x / (float)this.d.getUsageCount(), 1.0) * 0.5f;
        usage = Math.min(1.0f, Math.max(0.0f, usage));
        return usage;
    }

    public static TreeDrawer draw(Decider d) {
        final TreeDrawer dr = new TreeDrawer(d);
        JFrame f = new JFrame();
        f.getContentPane().add(dr);
        f.setSize(500, 200);
        f.setVisible(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    dr.repaint();
                    try {
                        2.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
        return dr;
    }

    public void setDecider(Decider newD) {
        this.d = newD;
        this.repaint();
    }
}

