/*
 * Decompiled with CFR 0.152.
 */
package decider.evolve;

import decider.analytics.AudioDataSimulation;
import decider.analytics.DeciderSimulationStats;
import decider.core.Decider;
import decider.evolve.FitnessFunction;
import java.util.Random;

public class DeciderFitnessFunctionVersion1
implements FitnessFunction {
    AudioDataSimulation adsSound = AudioDataSimulation.newUsingAudioFile("/Users/ollie/Music/Audio/Recordings/T+L/lothar.aif", 6);
    AudioDataSimulation adsRand = new AudioDataSimulation(new Random(), 6, 10000, 0.0f);

    @Override
    public float evaluate(Decider d) {
        DeciderSimulationStats dss = this.adsSound.run(d);
        float fitnessSound = (float)Math.pow(Math.min(dss.getNodesVisited(), 4000.0f), 2.0) * this.scaledDistance(dss.getTimeAtZeroNode(), 0.2f, 0.1f) * ((float)dss.getTimeStepsRun() - dss.getNumMinimallyShortHolds()) / (float)dss.getTimeStepsRun() * (float)Math.pow(dss.getMedianMaxGapLength() / (float)dss.getTimeStepsRun(), 0.5);
        dss = this.adsRand.run(d);
        float fitnessRand = (float)Math.pow(Math.min(dss.getNodesVisited(), 4000.0f), 2.0) * this.scaledDistance(dss.getTimeAtZeroNode(), 0.2f, 0.1f) * ((float)dss.getTimeStepsRun() - dss.getNumMinimallyShortHolds()) / (float)dss.getTimeStepsRun() * (float)Math.pow(dss.getMedianMaxGapLength() / (float)dss.getTimeStepsRun(), 0.5);
        return fitnessRand + fitnessSound;
    }

    private float scaledDistance(float x, float centre, float maxDistance) {
        if (x < centre - maxDistance) {
            return 0.0f;
        }
        if (x < centre) {
            return 1.0f - (centre - x) / maxDistance;
        }
        if (x > centre + maxDistance) {
            return 0.0f;
        }
        return 1.0f - (x - centre) / maxDistance;
    }
}

