/*
 * Decompiled with CFR 0.152.
 */
package decider.evolve;

import decider.analytics.AudioDataSimulation;
import decider.analytics.DeciderSimulationStats;
import decider.core.Decider;
import decider.evolve.FitnessFunction;
import java.util.Random;

public class DeciderFitnessFunctionVersion3
implements FitnessFunction {
    AudioDataSimulation adsSound = AudioDataSimulation.newUsingAudioFile("/Users/ollie/Music/Audio/Loops/jungle breaks/action.wav", 200);
    AudioDataSimulation adsRand = new AudioDataSimulation(new Random(), 200, 10000, 0.0f);
    AudioDataSimulation adsZero = new AudioDataSimulation(200, 10000, 0.0f, new float[10000][200]);

    @Override
    public float evaluate(Decider d) {
        DeciderSimulationStats dss = this.adsSound.run(d);
        float fitnessSound = (float)Math.pow(Math.min(dss.getNodesVisited(), 4000.0f), 1.0) * this.scaledDistance(dss.getTimeAtZeroNode(), 0.5f, 0.1f) * ((float)dss.getTimeStepsRun() - dss.getNumMinimallyShortHolds()) / (float)dss.getTimeStepsRun() * (float)Math.pow(dss.getMedianMaxGapLength() / (float)dss.getTimeStepsRun(), 0.5) * dss.getTraversalLinearity();
        dss = this.adsRand.run(d);
        float fitnessRand = (float)Math.pow(Math.min(dss.getNodesVisited(), 4000.0f), 1.0) * this.scaledDistance(dss.getTimeAtZeroNode(), 0.5f, 0.1f) * ((float)dss.getTimeStepsRun() - dss.getNumMinimallyShortHolds()) / (float)dss.getTimeStepsRun() * (float)Math.pow(dss.getMedianMaxGapLength() / (float)dss.getTimeStepsRun(), 0.5) * dss.getTraversalLinearity();
        return fitnessRand + fitnessSound;
    }

    private float scaledDistance(float x, float centre, float maxDistance) {
        if (x < centre - maxDistance) {
            return 0.0f;
        }
        if (x < centre) {
            return 1.0f - (centre - x) / maxDistance;
        }
        if (x > centre + maxDistance) {
            return 0.0f;
        }
        return 1.0f - (x - centre) / maxDistance;
    }
}

