/*
 * Decompiled with CFR 0.152.
 */
package decider.play;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import decider.play.Scene;
import decider.play.SoundEventUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.beadsproject.beads.core.UGen;

public class SplitScene
implements Scene {
    private static final long serialVersionUID = 1L;
    private static boolean playAll = false;
    private String name;
    private Decider decider;
    private transient float[] lastChosen;
    private TreeMap<Float, Class<? extends DeciderSoundEvent>> eventTypes = new TreeMap();
    private transient Map<Class<? extends DeciderSoundEvent>, DeciderSoundEvent> events;

    public SplitScene() {
        this.lastChosen = new float[]{-1.0f, -1.0f};
    }

    @Override
    public void process(UGen output) {
        this.decider.process();
        if (playAll) {
            if (this.events == null) {
                this.setupEvents();
            }
            for (DeciderSoundEvent dse : this.events.values()) {
                dse.play(output, this.decider.getCurrentLeaf(), this.decider);
            }
        } else {
            float fract = 1.0f - (float)this.decider.getCurrentLeaf() / (float)this.decider.getNumLeaves();
            float upperBound = this.getUpperBound(fract);
            float lowerBound = this.getLowerBound(fract);
            if (this.lastChosen == null) {
                this.lastChosen = new float[2];
            }
            this.lastChosen[0] = lowerBound;
            this.lastChosen[1] = upperBound;
            DeciderSoundEvent myEvent = this.getEvent(upperBound);
            if (myEvent != null) {
                int adjustedIndex = (int)((float)this.decider.getCurrentLeaf() - (float)this.decider.getNumLeaves() * lowerBound);
                adjustedIndex = Math.max(0, adjustedIndex);
                myEvent.play(output, adjustedIndex, this.decider);
            }
        }
    }

    private void setupEvents() {
        this.events = new Hashtable<Class<? extends DeciderSoundEvent>, DeciderSoundEvent>();
        for (Class<? extends DeciderSoundEvent> eventType : this.eventTypes.values()) {
            this.events.put(eventType, SoundEventUtil.eventFromClass(eventType));
        }
    }

    private DeciderSoundEvent getEvent(float intervalMarker) {
        DeciderSoundEvent result = null;
        Class<? extends DeciderSoundEvent> eventType = this.eventTypes.get(Float.valueOf(intervalMarker));
        if (eventType == null) {
            return null;
        }
        if (this.events == null) {
            this.events = new Hashtable<Class<? extends DeciderSoundEvent>, DeciderSoundEvent>();
        }
        if ((result = this.events.get(eventType)) == null) {
            result = SoundEventUtil.eventFromClass(eventType);
            this.events.put(eventType, result);
        }
        return result;
    }

    private float getLowerBound(float x) {
        float f;
        float result = 0.0f;
        Iterator<Float> iterator = this.eventTypes.keySet().iterator();
        while (iterator.hasNext() && !(x < (f = iterator.next().floatValue()))) {
            result = f;
        }
        return result;
    }

    private float getUpperBound(float x) {
        float result = 1.0f;
        for (float f : this.eventTypes.keySet()) {
            if (!(x < f)) continue;
            result = f;
            break;
        }
        return result;
    }

    @Override
    public void setInputFract(int i, float f) {
        this.decider.setInputFract(i, f);
    }

    @Override
    public void setDecider(Decider d) {
        this.decider = d;
    }

    @Override
    public Decider getDecider() {
        return this.decider;
    }

    public void addEvent(float upperBound, Class<? extends DeciderSoundEvent> cclass) {
        this.eventTypes.put(Float.valueOf(upperBound), cclass);
        this.setupEvents();
    }

    public void moveEvent(float upperBound, float newUpperBound) {
        Class<? extends DeciderSoundEvent> cclass = this.eventTypes.get(Float.valueOf(upperBound));
        this.eventTypes.remove(Float.valueOf(upperBound));
        this.eventTypes.put(Float.valueOf(newUpperBound), cclass);
    }

    public void removeEvent(float fract) {
        float upperBound = this.getUpperBound(fract);
        this.eventTypes.remove(Float.valueOf(upperBound));
        this.setupEvents();
    }

    public Set<Float> intervals() {
        return this.eventTypes.keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public float[] getLastSelectedRange() {
        return this.lastChosen;
    }

    public String getEventName(float f) {
        return this.eventTypes.get(Float.valueOf(f)).getSimpleName();
    }

    public void replaceEvent(float fract, Class<? extends DeciderSoundEvent> cclass) {
        float upperBound = this.getUpperBound(fract);
        this.eventTypes.put(Float.valueOf(upperBound), cclass);
    }

    @Override
    public void dispose() {
        for (DeciderSoundEvent event : this.events.values()) {
            event.destroy();
        }
    }

    @Override
    public void tick(float tempo, int tickCount) {
    }
}

